/*******************************************************************************
 * Copyright 2023 NXP
 * SPDX-License-Identifier: EPL-1.0
 *******************************************************************************/

package com.freescale.system.browser.epl.help;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

import com.freescale.system.browser.epl.help.TasksTabDescriptorEpl.Column;

public class TasksTreeComparatorEpl extends ViewerComparator {	
	/**
	 * The sort column index. I.e., when the user clicks a column to sort the
	 * table, the index of that column is set here.
	 */
	private int fSortColumn;	
	/**
	 * Constructor
	 * 
	 * @param columns the collection of columns present in the table
	 */
	TasksTreeComparatorEpl(Column[] columns) {
	}
	
	/**
	 * Accessor method. See fSortColumn
	 */
	void setSortColumn(int index) {
		assert(index >= 0);
		if (index >= 0) {
			fSortColumn = index;
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ViewerComparator#compare(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	@Override
	public int compare(Viewer viewer, Object e1, Object e2) {
		return fSortColumn;
	}
}
