/*******************************************************************************
 * Copyright 2023 NXP
 * SPDX-License-Identifier: EPL-1.0
 *******************************************************************************/

package com.freescale.system.browser.epl.help;

import org.eclipse.jface.viewers.IFilter;

import com.freescale.system.browser.epl.ISectionDescriptorEpl;
import com.freescale.system.browser.epl.ISectionEpl;

/**
 * 
 * */
public interface ICustomSectionDescriptorEpl extends ISectionDescriptorEpl{

	/**
	 * Get the section filter instance for this section. Return null if no
	 * filter for this section.
	 * 
	 * @return the section filter instance.
	 */
	public IFilter getFilter();
	
	/**
	 * Get the class that implements this section.
	 * 
	 * @return the class that implements this section.
	 */
	public ISectionEpl getSection();
	
	/**
	 * Get the section identifier below which this section is displayed. <code>"top"</code>
	 * is returned if this section is the top most section or if there is one
	 * section in the tab.
	 * 
	 * @return the section identifier.
	 */
	public String getAfterSection();
	
}
