/**
 * Copyright 2020 NXP
 * Created: 20 Jul 2020
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import java.util.Iterator;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.StructConfig;
import com.nxp.swtools.utils.tooltip.ToolTipableFormatter;

/**
 * Invisible struct control
 * @author Tomas Rudolf - nxf31690
 */
public class StructInvisibleControl extends StructControl {

	/** Struct config which is represented by this control */
	protected @NonNull StructConfig structConfig;

	/**
	 * Constructor
	 * @param structConfig struct config which will be represented by this control
	 * @param controlOptions for this control
	 * @param controllerWrapper containing controller that manages given config
	 */
	public StructInvisibleControl(@NonNull StructConfig structConfig, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
		super(structConfig, controlOptions, controllerWrapper);
		this.structConfig = structConfig;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ChildProvidableControlBase#createMainControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public @Nullable Control createMainControl(@NonNull Composite composite) {
		return null;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.StructControl#createLabelControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public @Nullable Control createLabelControl(@NonNull Composite composite) {
		return null;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.StructControl#update(com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl.UpdateType)
	 */
	@Override
	public void update(@NonNull UpdateType updateType) {
		super.update(updateType);
		if (getChild().isAvailable()) {
			Iterator<ISettingConfig> structItemIterator = structConfig.getChildren().iterator();
			ISettingConfig arrayItem = structItemIterator.hasNext() ? structItemIterator.next() : null;
			while (arrayItem != null) {
				// This should trigger problems generation
				ToolTipableFormatter.getToolTipText(arrayItem);
				arrayItem = structItemIterator.hasNext() ? structItemIterator.next() : null;
			}
		}
	}
}
