/**
 * Copyright 2022 NXP
 * Created: Nov 11, 2022
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.derivative.swt.GridLayoutComponents;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.data.setting.InfoSetting;
import com.nxp.swtools.utils.support.markdown.MarkDownSupport;

/**
 * Class representing the control of a {@link InfoSetting} with markdown content
 * @author Jiri Gallo - nxf95763
 */
public class ScalarInfoMarkdownControl extends ScalarControl {

	/**
	 * @param child to create control for
	 * @param controlOptions for this control
	 * @param controllerWrapper containing the generic controller
	 */
	public ScalarInfoMarkdownControl(@NonNull ScalarConfig child, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
		super(child, controlOptions, controllerWrapper);
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ScalarControl#createMainControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public @NonNull Control createMainControl(@NonNull Composite composite) {
		final Composite textComposite = new Composite(composite, SWT.NONE);
		GridLayoutComponents textCompositeLayout = new GridLayoutComponents();
		textCompositeLayout.marginWidth = textCompositeLayout.marginHeight = 0;
		textComposite.setLayout(textCompositeLayout);
		GridDataComponents textCompositeLayoutData = new GridDataComponents(SWT.FILL, SWT.CENTER, true, false);
		Control text = SWTFactoryProxy.INSTANCE.createStyledTextWithHtml(textComposite, SWT.WRAP);
		if (text != null) {
			text.setBackground(textComposite.getBackground());
			text.setLayoutData(textCompositeLayoutData);
			createErrorDecoration(text, SWT.TOP | SWT.LEFT);
			mainControlInternal = text;
			addScrollListener(text, composite);
		}
		return textComposite;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.view.componentsettings.ScalarControl#updateMainContent(org.eclipse.swt.widgets.Control, com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl.UpdateType)
	 */
	@Override
	protected void updateMainContent(@NonNull Control contentControl, @NonNull UpdateType updateType) {
		Control mainControlInternalLoc = mainControlInternal;
		if (mainControlInternalLoc != null) {
			if (updateType != UpdateType.PROBLEM_DECORATION) {
				String htmlContent = MarkDownSupport.markDownToHtml(String.valueOf(getChild().getValue()), null);
				SWTFactoryProxy.INSTANCE.updateStyledTextWithHtml(mainControlInternalLoc, htmlContent);
			}
			updateErrorDecoration(mainControlInternalLoc);
		}
		updateErrorDecoration(contentControl);
	}

}
