/**
 * Copyright 2021 NXP
 * Created: Mar 15 2021
 */
package com.nxp.swtools.periphs.gui.view;

import java.util.List;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;

/**
 * Content provider for the tree in {@link AddComponentDialog}
 * @author Tomas Rudolf - nxf31690
 */
final class AddComponentTreeProvider implements ITreeContentProvider {
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
	 */
	@Override
	public @NonNull Object @NonNull [] getChildren(@NonNull Object element) {
		if (element instanceof AddComponentDialogEntry) {
			AddComponentDialogEntry dialogEntry = (AddComponentDialogEntry) element;
			List<AddComponentDialogEntry> templateEntries = dialogEntry.getTemplateEntries();
			return templateEntries.toArray(new @NonNull AddComponentDialogEntry[templateEntries.size()]);
		}
		return new AddComponentDialogEntry[0];
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getElements(java.lang.Object)
	 */
	@Override
	public @NonNull Object @NonNull [] getElements(@NonNull Object inputObject) {
		if (inputObject instanceof List) {
			return ((List<?>)inputObject).toArray();
		}
		return new AddComponentDialogEntry[0];
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
	 */
	@Override
	public @Nullable Object getParent(@NonNull Object element) {
		if (element instanceof AddComponentDialogEntry) {
			return ((AddComponentDialogEntry) element).getParent();
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
	 */
	@Override
	public boolean hasChildren(@NonNull Object element) {
		if (element instanceof AddComponentDialogEntry) {
			return ((AddComponentDialogEntry) element).hasTemplates();
		}
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	@Override
	public void dispose() {
		// Nothing to dispose - required by RAP
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	@Override
	public void inputChanged(@NonNull Viewer viewer, @Nullable Object oldInput, @Nullable Object newInput) {
		// Intentionally empty - required by RAP
	}
}