/**
 * Copyright 2020 NXP
 * Created: 03 Aug 2020
 */
package com.nxp.swtools.periphs.gui.view;

import java.util.List;

import org.eclipse.ui.IViewSite;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;

/**
 * Properties for creation of {@link AddComponentDialog}
 * @author Tomas Rudolf - nxf31690
 */
public class AddComponentDialogProperties {
	/** View site that can provide page or shell */
	private @NonNull IViewSite viewSite;
	/** Name of the functional group to which the dialog will add instance */
	private @NonNull String functionalGroupName;
	/** Wrapper to obtain controllers */
	private @NonNull IControllerWrapper controllerWrapper;
	/** Flag that the view of instance should open after creating the instance */
	private boolean openView;
	/** Flag whether the toolchain project only components filter should be visible to the user */
	private boolean toolchainFilterAllowed;
	/** Flag whether the dialog should block the thread after opening */
	private boolean blockOnOpen = true;
	/** List of components that should be offered */
	private @Nullable List<@NonNull ConfigurationComponentTypeId> configCompsTypeIds;
	/** Name of the peripheral for which the selection should be shown */
	private @Nullable String peripheral;

	/**
	 * Constructor
	 * @param viewSite to get shell in which to open the dialog
	 * @param functionalGroupName name of the functional group
	 * @param controllerWrapper wrapper to get controllers
	 * @param openView {@code true} when view of the instance should open after creating the instance, {@code false} otherwise
	 * @param toolchainFilterAllowed {@code true} when the filter for toolchain only components should be shown to the user, {@code false} otherwise
	 */
	public AddComponentDialogProperties(@NonNull IViewSite viewSite, @NonNull String functionalGroupName, @NonNull IControllerWrapper controllerWrapper, boolean openView, boolean toolchainFilterAllowed) {
		this.viewSite = viewSite;
		this.functionalGroupName = functionalGroupName;
		this.controllerWrapper = controllerWrapper;
		this.openView = openView;
		this.toolchainFilterAllowed = toolchainFilterAllowed;
	}

	/**
	 * Sets the list of available components
	 * @param configCompsTypeIds list of component typeids
	 */
	public void setConfigCompsTypeIds(@Nullable List<@NonNull ConfigurationComponentTypeId> configCompsTypeIds) {
		this.configCompsTypeIds = configCompsTypeIds;
	}

	/**
	 * Sets the peripheral which will be used as filter
	 * @param peripheral for which to show components
	 */
	public void setPeripheral(@Nullable String peripheral) {
		this.peripheral = peripheral;
	}

	/**
	 * Sets flag whether to block the thread after opening the dialog or not
	 * @param blockOnOpen {@code true} when the thread should block after opening the dialog, {@code false} otherwise
	 */
	public void setBlockOnOpen(boolean blockOnOpen) {
		this.blockOnOpen = blockOnOpen;
	}

	/**
	 * @return the view site
	 */
	public @NonNull IViewSite getViewSite() {
		return viewSite;
	}

	/**
	 * @return the name of functional group
	 */
	public @NonNull String getFunctionalGroupName() {
		return functionalGroupName;
	}

	/**
	 * @return the controller wrapper
	 */
	public @NonNull IControllerWrapper getControllerWrapper() {
		return controllerWrapper;
	}

	/**
	 * @return the flag whether the view should open
	 */
	public boolean getOpenView() {
		return openView;
	}

	/**
	 * @return flag whether to block thread after opening the dialog
	 */
	public boolean getBlockOnOpen() {
		return blockOnOpen;
	}

	/**
	 * @return flag whether the toolchain project filter should be shown to user
	 */
	public boolean getToolchainFilterAllowed() {
		return toolchainFilterAllowed;
	}

	/**
	 * @return list of components to offer, or {@code null} when specific list was not set
	 */
	public @Nullable List<@NonNull ConfigurationComponentTypeId> getConfigCompsTypeIds() {
		return configCompsTypeIds;
	}

	/**
	 * @return the peripheral for only which to show the components, or {@code null} when no specific peripheral was set
	 */
	public @Nullable String getPeripheral() {
		return peripheral;
	}
}