 /**
 * Copyright 2019-2020 NXP
 * Created: Jan 31, 2019
 */
package com.nxp.swtools.periphs.gui.controller;

import org.eclipse.ui.IViewSite;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.periphs.gui.view.componentsettings.ComponentSettingView;
import com.nxp.swtools.periphs.gui.view.componentsettings.ComponentSettingViewHelper;

/**
 * @author Rares-Mihai Gafton nxf38680
 *
 */
public class PeriphGUIController extends APeriphGUIController {


	/** Whether the controller was disposed */
	private boolean disposed = false;
	
	/**
	 * Constructor
	 */
	private PeriphGUIController() {
		// intentionally empty
	}
	
	/**
	 * Get instance of a Controller. Must be called from UI thread
	 * @return instance of a controller
	 */
	public static PeriphGUIController getInstance() {
		try {
			PeriphGUIController controller = SWTFactoryProxy.INSTANCE.getSingletonInstance(PeriphGUIController.class);
			if (controller.disposed) {
				throw new IllegalStateException("Controller is disposed");  //$NON-NLS-1$
			}
			return controller;
		} catch (InstantiationException | IllegalAccessException e) {
			throw new IllegalStateException("Cannot obtain instance of a controller", e);  //$NON-NLS-1$
		}
	}
	
	/**
	 * Dispose the controller.
	 */
	public void dispose() {
		disposed = true;
	}

	/*
	 * (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.controller.APeriphGUIController#openConfigurationSettingsView(org.eclipse.ui.IViewSite, java.lang.String, java.lang.String, boolean, boolean)
	 */
	@Override
	public boolean openConfigurationSettingsView(IViewSite viewSite, String componentType,
			String componentName, boolean global, boolean activate) {
		return ComponentSettingView.open(viewSite, componentType, componentName, global, activate);
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.controller.APeriphGUIController#openConfigurationSettingsView(org.eclipse.ui.IViewSite, java.lang.String, boolean)
	 */
	@Override
	public boolean openConfigurationSettingsView(IViewSite viewSite, String uuid, boolean activate) {
		return ComponentSettingView.open(viewSite, uuid, activate);
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.periphs.gui.controller.APeriphGUIController#addPermittedOccurrenceOfView(java.lang.String)
	 */
	@Override
	public void addPermittedOccurrenceOfView(String identificationBase) {
		ComponentSettingViewHelper.getInstance().addPermittedOccurrence(identificationBase);
	}

}
