/**
 * Copyright 2017-2019, 2021 NXP
 * Created: Sep 18, 2017
 */
package com.nxp.swtools.periphs.gui;

import java.util.List;

import com.nxp.swtools.codemanager.ICodeGenerator;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsTool;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.snippets.SnippetNode;
import com.nxp.swtools.utils.tools.ITool;

/**
 * Implementation of {@link ITool} for Peripherals tool 
 * @author Marek Trmac
 */
public class PeripheralsTool implements ITool {

	/* (non-Javadoc)
	 * @see com.nxp.swtools.utils.tools.ITool#getToolId()
	 */
	@Override
	public String getToolId() {
		return SwToolsProduct.PRODUCT_ID_PERIPHERALS_TOOL;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.utils.tools.ITool#isProcessorSupported(com.nxp.swtools.provider.configuration.ISharedConfiguration)
	 */
	@Override
	public boolean isProcessorSupported(ISharedConfiguration configuration) {
		return Controller.getInstance().isMcuSupported(configuration.getCommonConfig());
	}
	
	/* (non-Javadoc)
	 * @see com.nxp.swtools.utils.tools.ITool#isUpdated(com.nxp.swtools.provider.configuration.ISharedConfiguration)
	 */
	@Override
	public boolean isUpdated(ISharedConfiguration configuration) {
		return !Controller.getInstance().isCodeDirty();
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.utils.tools.ITool#waitForUpdated(com.nxp.swtools.provider.configuration.ISharedConfiguration)
	 */
	@Override
	public boolean waitUntilUpdated(ISharedConfiguration configuration) {
		final Controller controller = Controller.getInstance();
		controller.refreshIfChangeInOtherTool();
		if (KEPreferences.isCodePreviewEnabled()) {
			return controller.waitUntilRegenerated();
		}
		return true;

	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.utils.tools.ITool#createStorageTool(com.nxp.swtools.provider.configuration.ISharedConfiguration)
	 */
	@Override
	public StorageTool createStorageTool(ISharedConfiguration sharedConfig) {
		assert (sharedConfig.getTools().getPeripherals() == null);
		final StoragePeriphsTool result = new StoragePeriphsTool();
		return result; 
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.utils.tools.ITool#isFunctionalGroupsSupported()
	 */
	@Override
	public boolean isFunctionalGroupSupported() {
		return true;
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.utils.tools.ITool#getCodeGenerator()
	 */
	@Override
	public @Nullable ICodeGenerator getCodeGenerator() {
		return Controller.getInstance();
	}

	/* (non-Javadoc)
	 * @see com.nxp.swtools.utils.tools.ITool#getSnippets()
	 */
	@Override
	public List<SnippetNode> getSnippets() {
		return Controller.getInstance().getSnippets();
	}
}
