/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.gui.utils;

import com.nxp.swtools.common.uct.mcu.IMcu;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.EnumSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.ItemSetting;
import com.nxp.swtools.common.uct.utils.UctLayoutUtils;
import com.nxp.swtools.common.uct.utils.UctUtils;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controls.EnumSettingControl;
import com.nxp.swtools.gtm.controls.SplitPaneStructNode;
import com.nxp.swtools.gtm.gui.GtmSceneCreator;
import com.nxp.swtools.gtm.model.xml.settings.GtmStructSetting;
import java.util.ArrayList;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;

public class GtmLayoutUtils {
    public static void refreshUI(Scene scene) {
        if (scene.getRoot() instanceof SplitPane) {
            SplitPane mainPane = (SplitPane)scene.getRoot();
            for (Node node : mainPane.getItems()) {
                if (!(node instanceof SplitPaneStructNode)) continue;
                ((SplitPaneStructNode)node).refresh();
            }
        }
    }

    public static void updateEnumComboBoxesItems() {
        for (Node node : GtmSceneCreator.getNodes()) {
            EnumSetting enumSetting;
            if (!(node instanceof EnumSettingControl)) continue;
            EnumSettingControl enumSettingControl = (EnumSettingControl)node;
            ComboBox<String> enumCmb = enumSettingControl.getEnumCmb();
            ObservableList<String> enumCmbItems = enumSettingControl.getEnumCmbItems();
            ABaseUIComponentSetting component = UctUtils.getUIComponentSettingById((IMcu)GtmController.getInstance().getGtmMcu(), (String)enumCmb.getId());
            ArrayList<String> itemsToAdd = new ArrayList<String>();
            ArrayList<String> itemsToRemove = new ArrayList<String>();
            if (!(component instanceof EnumSetting) || !GtmLayoutUtils.shouldUpdateCmbItems(enumSetting = (EnumSetting)component, enumCmb)) continue;
            for (ItemSetting item : enumSetting.getItems()) {
                if (item.isVisible() && !enumCmbItems.contains(item.getLabel())) {
                    itemsToAdd.add(item.getLabel());
                    continue;
                }
                if (item.isVisible() || !enumCmbItems.contains(item.getLabel())) continue;
                itemsToRemove.add(item.getLabel());
            }
            enumSettingControl.getEnumCmbItems().removeAll(itemsToRemove);
            enumSettingControl.getEnumCmbItems().addAll(itemsToAdd);
        }
    }

    private static boolean shouldUpdateCmbItems(EnumSetting enumSetting, ComboBox<String> enumCmb) {
        if (enumSetting.getVisibleItems().size() != enumCmb.getItems().size()) {
            return true;
        }
        for (ItemSetting item : enumSetting.getVisibleItems()) {
            if (enumCmb.getItems().contains((Object)item.getLabel())) continue;
            return true;
        }
        return false;
    }

    public static @Nullable Tab getTabWithId(TabPane tabPane, String id) {
        for (Tab tab : tabPane.getTabs()) {
            if (!id.equals(tab.getId())) continue;
            return tab;
        }
        return null;
    }

    public static void resetAllStructSettingsState() {
        for (ABaseUIComponentSetting componentSetting : GtmController.getInstance().getGtmMcu().getAllGuiComponentSettings()) {
            if (!(componentSetting instanceof GtmStructSetting) || componentSetting.getVisibleAttribute().isEmpty() || !componentSetting.getConstraintsRef().isEmpty()) continue;
            componentSetting.setVisibleState(componentSetting.getInitVisibleState());
            Node node = GtmSceneCreator.getNodeById(componentSetting.getId());
            if (node == null) continue;
            UctLayoutUtils.updateNodeState((Node)node, (ABaseUIComponentSetting)componentSetting);
        }
    }
}

