/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.gui;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controls.SplitPaneStructNode;
import com.nxp.swtools.gtm.model.xml.settings.GtmStructSetting;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.SplitPane;

public class GtmSceneCreator {
    private Scene rootScene;
    private SplitPane mainPane = new SplitPane();
    private static List<Node> allUiNodes = new ArrayList<Node>();

    public GtmSceneCreator() {
        this.rootScene = new Scene(this.start());
        this.rootScene.getStylesheets().add((Object)"resources/gtm-default-skin.css");
    }

    public Parent start() {
        return this.mainPane;
    }

    public Scene getRootScene() {
        return this.rootScene;
    }

    public void createLayout() {
        this.dispose();
        this.mainPane.getItems().clear();
        GtmStructSetting parentLayoutContent = GtmController.getInstance().getGtmMcu().getGtmLayoutContent();
        SplitPaneStructNode structSettingNode = new SplitPaneStructNode(parentLayoutContent);
        if (this.mainPane.getHeight() > 2.0) {
            structSettingNode.setPrefHeight(this.mainPane.getHeight());
            structSettingNode.setMinHeight(this.mainPane.getHeight());
        }
        this.mainPane.getItems().add((Object)structSettingNode);
    }

    public static List<Node> getNodes() {
        return allUiNodes;
    }

    public static @Nullable Node getNodeById(String id) {
        for (Node node : allUiNodes) {
            if (!id.equals(node.getId())) continue;
            return node;
        }
        return null;
    }

    public void dispose() {
        for (Node mainItem : this.mainPane.getItems()) {
            if (!(mainItem instanceof SplitPaneStructNode)) continue;
            ((SplitPaneStructNode)mainItem).dispose();
        }
        allUiNodes.clear();
        this.mainPane.getItems().clear();
        GtmController.getInstance().getProblemsManager().clearAllProblems();
    }
}

