/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controls;

import com.nxp.swtools.common.uct.controls.IBaseControl;
import com.nxp.swtools.common.uct.ui.xml.settings.LayoutType;
import com.nxp.swtools.gtm.controls.GridPaneStructNode;
import com.nxp.swtools.gtm.controls.SplitPaneStructNode;
import com.nxp.swtools.gtm.controls.TitledPaneStructNode;
import com.nxp.swtools.gtm.model.xml.settings.GtmStructSetting;
import javafx.scene.layout.Region;
import org.eclipse.ui.services.IDisposable;

public class StructSettingNode
implements IDisposable {
    private GtmStructSetting structSetting;
    private Region region;

    public StructSettingNode(GtmStructSetting structSetting) {
        this.structSetting = structSetting;
        LayoutType layoutType = this.structSetting.getLayoutType();
        switch (layoutType) {
            case SPLIT_PANE: {
                this.region = new SplitPaneStructNode(this.structSetting);
                break;
            }
            case GRID_PANE: {
                this.region = new GridPaneStructNode(this.structSetting);
                break;
            }
            case TITLED_PANE: {
                this.region = new TitledPaneStructNode(this.structSetting);
                break;
            }
            default: {
                this.region = new Region();
            }
        }
        this.region.setVisible(this.structSetting.isVisible());
    }

    public GtmStructSetting getStructSetting() {
        return this.structSetting;
    }

    public Region getRegion() {
        return this.region;
    }

    public void refresh() {
        if (this.region instanceof IBaseControl) {
            ((IBaseControl)this.region).refresh();
        }
    }

    public void dispose() {
        if (this.region instanceof IDisposable) {
            ((IDisposable)this.region).dispose();
        }
    }
}

