/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controls;

import com.nxp.swtools.common.uct.controls.IBaseControl;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.utils.UctLayoutUtils;
import com.nxp.swtools.gtm.controls.StructSettingNode;
import com.nxp.swtools.gtm.gui.GtmSceneCreator;
import com.nxp.swtools.gtm.model.xml.settings.GtmStructSetting;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.AnchorPane;
import org.eclipse.ui.services.IDisposable;

public class SplitPaneStructNode
extends SplitPane
implements IBaseControl,
IDisposable {
    private GtmStructSetting structSetting;

    public SplitPaneStructNode(GtmStructSetting structSetting) {
        this.structSetting = structSetting;
        this.create();
    }

    public void create() {
        this.setId(this.structSetting.getId());
        this.setDividerPositions(new double[]{0.2f, 0.6f});
        AnchorPane.setLeftAnchor((Node)this, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this, (Double)0.0);
        AnchorPane.setTopAnchor((Node)this, (Double)0.0);
        for (GtmStructSetting childStruct : this.structSetting.getStructSettings()) {
            ScrollPane childStructScrollPane = new ScrollPane();
            StructSettingNode structSettingNode = new StructSettingNode(childStruct);
            childStructScrollPane.setContent((Node)structSettingNode.getRegion());
            childStructScrollPane.setFitToWidth(true);
            childStructScrollPane.setFitToHeight(true);
            structSettingNode.getRegion().prefWidthProperty().bind((ObservableValue)this.prefWidthProperty());
            structSettingNode.getRegion().prefHeightProperty().bind((ObservableValue)this.prefHeightProperty());
            this.getItems().add((Object)childStructScrollPane);
            UctLayoutUtils.updateNodeState((Node)childStructScrollPane, (ABaseUIComponentSetting)childStruct);
        }
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.structSetting);
        GtmSceneCreator.getNodes().add((Node)this);
    }

    public void refresh() {
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.structSetting);
        for (Node child : this.getItems()) {
            Node childContent;
            if (!(child instanceof ScrollPane) || !((childContent = ((ScrollPane)child).getContent()) instanceof IBaseControl)) continue;
            ((IBaseControl)childContent).refresh();
        }
    }

    public void dispose() {
        for (Node child : this.getItems()) {
            Node childContent;
            if (!(child instanceof ScrollPane) || !((childContent = ((ScrollPane)child).getContent()) instanceof IDisposable)) continue;
            ((IDisposable)childContent).dispose();
        }
        GtmSceneCreator.getNodes().remove((Object)this);
        this.getItems().clear();
    }
}

