/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controls;

import com.nxp.swtools.common.uct.controller.AUctController;
import com.nxp.swtools.common.uct.controls.IChildControl;
import com.nxp.swtools.common.uct.mcu.IMcu;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.BoolSetting;
import com.nxp.swtools.common.uct.utils.UctLayoutUtils;
import com.nxp.swtools.common.uct.utils.UctUtils;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.gui.GtmSceneCreator;
import com.nxp.swtools.gtm.gui.utils.GtmLayoutUtils;
import com.nxp.swtools.gtml.controller.utils.StorageGtmUtils;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import org.eclipse.ui.services.IDisposable;

public class BoolSettingControl
extends CheckBox
implements IChildControl,
IDisposable {
    private BoolSetting boolSetting;
    protected Parent parent;
    private ChangeListener<Boolean> selectionListener;

    public BoolSettingControl(BoolSetting boolSetting, Parent parent) {
        this.boolSetting = boolSetting;
        this.parent = parent;
        this.selectionListener = this.createSelectionListener();
        this.create();
    }

    public void create() {
        this.setId(this.boolSetting.getId());
        this.setMnemonicParsing(false);
        this.setText(this.boolSetting.getLabel());
        this.setSelected("true".equalsIgnoreCase(this.boolSetting.getCurrentValue()));
        this.getStyleClass().add((Object)"default-c-style");
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.boolSetting);
        UctLayoutUtils.registerListenerForControl((AUctController)GtmController.getInstance(), (IChildControl)this, (int)4);
        this.selectedProperty().addListener(this.selectionListener);
        GtmSceneCreator.getNodes().add((Node)this);
    }

    private ChangeListener<Boolean> createSelectionListener() {
        return (obs, wasOn, isNowOn) -> {
            String currentValue = this.isSelected() ? "true" : "false";
            this.boolSetting.setCurrentValue(currentValue);
            UctUtils.updateComponentsState((IMcu)GtmController.getInstance().getGtmMcu(), (ABaseUIComponentSetting)this.boolSetting);
            GtmLayoutUtils.updateEnumComboBoxesItems();
            Scene scene = this.getScene();
            if (scene != null) {
                GtmLayoutUtils.refreshUI(scene);
            }
            GtmController.getInstance().refreshCodeAndSourceView();
            StorageGtmUtils.updateStorageForComponent((Object)((Object)this), (ABaseUIComponentSetting)this.boolSetting);
        };
    }

    public ChangeListener<Boolean> getSelectionListener() {
        return this.selectionListener;
    }

    public void refresh() {
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.boolSetting);
        boolean currentBoolSettingValue = this.boolSetting.getCurrentValue().equals("true");
        if (this.isSelected() != currentBoolSettingValue) {
            this.setSelected(currentBoolSettingValue);
        }
    }

    public Parent getParentControl() {
        return this.parent;
    }

    public void setParentControl(Parent parent) {
        this.parent = parent;
    }

    public void dispose() {
        this.selectedProperty().removeListener(this.selectionListener);
        UctLayoutUtils.removeListenerForControl((AUctController)GtmController.getInstance(), (IChildControl)this);
        GtmSceneCreator.getNodes().add((Node)this);
        this.getChildren().clear();
    }
}

