/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.internal.registry.ui.tree;

import com.nxp.s32ds.cle.runtime.hardware.registry.CoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.ext.rcp.registry.EntityDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Text;

public class HardwareViewerFilter
extends ViewerFilter {
    private Text txtFilter;
    private ITreeContentProvider hwProvider;
    private String filterText;
    private final Map<Object, Boolean> objects;

    public HardwareViewerFilter(Text control, ITreeContentProvider provider) {
        this.txtFilter = control;
        this.hwProvider = provider;
        this.objects = new HashMap<Object, Boolean>();
    }

    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        String filteringValue = this.getFilteringValue();
        if (!filteringValue.equals(this.filterText)) {
            this.filterText = filteringValue;
            this.objects.clear();
        }
        if (filteringValue.isEmpty()) {
            return elements;
        }
        ArrayList<Object> listResult = new ArrayList<Object>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceDescriptor descriptor;
            Object object = objectArray[n2];
            if (this.checkElement(object, filteringValue)) {
                listResult.add(object);
                this.objects.put(object, true);
            } else if (this.checkChildren(object, filteringValue)) {
                listResult.add(object);
                this.objects.put(object, false);
            } else if (parent instanceof DeviceDescriptor && Arrays.asList(this.hwProvider.getChildren((Object)(descriptor = (DeviceDescriptor)parent))).contains(object) && this.objects.containsKey(descriptor) && this.objects.get(descriptor).booleanValue()) {
                this.objects.put(object, false);
                listResult.add(object);
            }
            ++n2;
        }
        return listResult.toArray(new Object[listResult.size()]);
    }

    private boolean checkElement(Object object, String filteringValue) {
        String lowerCaseDescriptorViewName = "";
        if (object instanceof CoreDescriptor) {
            CoreDescriptor desc = (CoreDescriptor)object;
            lowerCaseDescriptorViewName = desc.getId().toLowerCase();
        } else if (object instanceof EntityDescriptor) {
            EntityDescriptor desc = (EntityDescriptor)object;
            lowerCaseDescriptorViewName = desc.getName().toLowerCase();
        }
        return lowerCaseDescriptorViewName.contains(filteringValue) || this.checkDeviceDescriptor((EntityDescriptor)object, filteringValue);
    }

    private boolean checkChildren(Object object, String filteringValue) {
        if (this.hwProvider.hasChildren(object)) {
            Object[] children;
            Object[] objectArray = children = this.hwProvider.getChildren(object);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (this.checkElement(child, filteringValue)) {
                    return true;
                }
                if (this.checkChildren(child, filteringValue)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean checkDeviceDescriptor(EntityDescriptor element, String filteringValue) {
        if (!(element instanceof DeviceDescriptor)) {
            return false;
        }
        DeviceDescriptor descriptor = (DeviceDescriptor)element;
        String revision = descriptor.getRevision();
        if (revision == null) {
            return false;
        }
        String fullDeviceName = String.valueOf(element.getId()) + "_" + revision;
        return fullDeviceName.toLowerCase().contains(filteringValue);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return true;
    }

    private String getFilteringValue() {
        String result = "";
        if (this.txtFilter != null && !this.txtFilter.isDisposed()) {
            result = this.txtFilter.getText();
        }
        return result.toLowerCase().trim();
    }
}

