/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.view.views.queuelist;

import com.nxp.freertos.gdb.tad.model.freertos.FreeRTOSConfig;
import com.nxp.freertos.gdb.tad.view.TadDoubleViewWeight;
import com.nxp.freertos.gdb.tad.view.TadView;
import com.nxp.freertos.gdb.tad.view.TadViewType;
import com.nxp.freertos.gdb.tad.view.column.TadColumn;
import com.nxp.freertos.gdb.tad.view.column.TadColumnCopyable;
import com.nxp.freertos.gdb.tad.view.column.TadColumnId;
import com.nxp.freertos.gdb.tad.view.column.TadColumnWeight;

public class QueueListView
extends TadView {
    public QueueListView() {
        super(TadViewType.DOUBLE, TadDoubleViewWeight.PARENT);
        this.parentColumns.add(new TadColumn(TadColumnId.ID, "#", "Queue number", TadColumnWeight.SMALL, TadColumnCopyable.READ_ONLY));
        this.parentColumns.add(new TadColumn(TadColumnId.NAME, "Queue Name", "Text name assigned to queue", TadColumnWeight.WIDE, TadColumnCopyable.COPYABLE));
        this.parentColumns.add(new TadColumn(TadColumnId.ADDRESS, "Address", "Address of the queue", TadColumnWeight.NORMAL, TadColumnCopyable.COPYABLE));
        this.parentColumns.add(new TadColumn(TadColumnId.LENGTH, "Length", "Current and maximum length of queue", TadColumnWeight.SMALL, TadColumnCopyable.COPYABLE));
        this.parentColumns.add(new TadColumn(TadColumnId.SIZE, "Item Size", "Size of queue item", TadColumnWeight.NORMAL, TadColumnCopyable.COPYABLE));
        this.parentColumns.add(new TadColumn(TadColumnId.TX_WAITING, "# Tx Waiting", "Number of tasks waiting to send to the queue", TadColumnWeight.SMALL, TadColumnCopyable.COPYABLE));
        this.parentColumns.add(new TadColumn(TadColumnId.RX_WAITING, "# Rx Waiting", "Number of tasks waiting to receive from the queue", TadColumnWeight.SMALL, TadColumnCopyable.COPYABLE));
        this.parentColumns.add(new TadColumn(TadColumnId.TYPE, "Queue Type", "Type of queue (regular queue or synchronization object)", TadColumnWeight.WIDE, TadColumnCopyable.COPYABLE, null, FreeRTOSConfig.USE_TRACE));
        this.childColumns.add(new TadColumn(TadColumnId.ID, "#", "Number of queue item", TadColumnWeight.NARROW, TadColumnCopyable.COPYABLE));
        this.childColumns.add(new TadColumn(TadColumnId.ADDRESS, "Address", "Address of the queue data", TadColumnWeight.SMALL, TadColumnCopyable.COPYABLE));
        this.childColumns.add(new TadColumn(TadColumnId.DATA_BYTES, "Queue Data [DEC]", "Queue data as decimal number", TadColumnWeight.SMALL, TadColumnCopyable.COPYABLE));
        this.childColumns.add(new TadColumn(TadColumnId.DATA_HEX, "Queue Data [HEX]", "Queue data as hexadecimal number", TadColumnWeight.SMALL, TadColumnCopyable.COPYABLE));
        this.childColumns.add(new TadColumn(TadColumnId.DATA_BIN, "Queue Data [BIN]", "Queue data as binary number", TadColumnWeight.NORMAL, TadColumnCopyable.COPYABLE));
        this.childColumns.add(new TadColumn(TadColumnId.DATA_TEXT, "Queue Data [ASCII]", "Queue data as ASCII text", TadColumnWeight.SMALL, TadColumnCopyable.COPYABLE));
    }

    @Override
    protected TadView getTadView() {
        return this;
    }

    public String getTitle() {
        return "Queue List";
    }
}

