/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.variables;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ChangeVariableValueInputDialog
extends TrayDialog {
    private String title;
    private String message;
    private String value = "";
    private IInputValidator validator;
    private Button okButton;
    private Text text;
    private Label errorMessageLabel;

    public ChangeVariableValueInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
        super(parentShell);
        this.title = dialogTitle;
        this.message = dialogMessage;
        this.value = initialValue == null ? "" : initialValue;
        this.validator = validator;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void buttonPressed(int buttonId) {
        this.value = buttonId == 0 ? this.text.getText() : null;
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.text.setFocus();
        if (this.value != null) {
            this.text.setText(this.value);
            this.text.selectAll();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.message != null) {
            Label label = new Label(composite, 64);
            label.setText(this.message);
            GridData data = new GridData(772);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(font);
        }
        this.text = new Text(composite, 2818);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 50;
        gridData.widthHint = 100;
        this.text.setLayoutData((Object)gridData);
        this.text.setFont(font);
        this.text.addModifyListener(e -> {
            if (this.okButton.isEnabled()) {
                return;
            }
            this.errorMessageLabel.setText("");
            this.errorMessageLabel.getParent().update();
            this.okButton.setEnabled(true);
        });
        this.errorMessageLabel = new Label(composite, 0);
        this.errorMessageLabel.setLayoutData((Object)new GridData(768));
        this.errorMessageLabel.setFont(font);
        return composite;
    }

    protected Label getErrorMessageLabel() {
        return this.errorMessageLabel;
    }

    protected Button getOkButton() {
        return this.okButton;
    }

    protected Text getText() {
        return this.text;
    }

    protected IInputValidator getValidator() {
        return this.validator;
    }

    public String getValue() {
        return this.value;
    }

    protected void validateInput() {
        String errorMessage = null;
        if (this.validator != null) {
            errorMessage = this.validator.isValid(this.text.getText());
        }
        this.errorMessageLabel.setText(errorMessage == null ? "" : errorMessage);
        this.okButton.setEnabled(errorMessage == null);
        this.errorMessageLabel.getParent().update();
    }

    protected void okPressed() {
        this.validateInput();
        if (this.okButton.isEnabled()) {
            super.okPressed();
        }
    }

    protected String getDialogSettingsSectionName() {
        return "org.eclipse.debug.ui.CHANGE_VARIABLE_VALUE_DIALOG_SECTION";
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(ChangeVariableValueInputDialog.class)).getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }

    protected void handleShellCloseEvent() {
        this.value = null;
        super.handleShellCloseEvent();
    }
}

