/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.datacollection;

import com.nxp.s32ds.ext.rcp.datacollection.preferences.DataCollectionPreferenceConstants;
import com.nxp.s32ds.ext.rcp.datacollection.storage.StorageService;
import com.nxp.s32ds.ext.rcp.datacollection.transfer.TransferService;
import com.nxp.s32ds.ext.rcp.datacollection.utils.MachineIdUtil;
import com.nxp.s32ds.ext.rcp.internal.datacollection.ArbitrageService;
import com.nxp.s32ds.ext.rcp.internal.datacollection.DataCollectionActivator;
import com.nxp.s32ds.ext.rcp.internal.datacollection.StorageServiceImpl;
import com.nxp.s32ds.ext.rcp.internal.datacollection.TransferServiceImpl;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Platform;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class DataCollectionService
implements EventHandler {
    private HashMap<String, String> head = new LinkedHashMap<String, String>();
    private StorageService storage = new StorageServiceImpl();
    private TransferService transfer = new TransferServiceImpl();
    private ArbitrageService arbitrage = ArbitrageService.getDataCollectionArbitr();
    private String machineId = "";
    private String logLocation = DataCollectionPreferenceConstants.getDefaultLogLocation();
    private String host = "localhost";
    private boolean isEnabled;

    public void handleEvent(Event event) {
        if (Objects.equals("s32ds/data/collection/head", event.getTopic())) {
            this.init();
            this.collectHead(event);
            if (this.isEnabled) {
                this.store(this.head);
            }
            return;
        }
        if (Objects.equals("s32ds/data/collection/configuration", event.getTopic())) {
            this.setConfiguration(event);
            return;
        }
        if (this.isEnabled) {
            this.store(DataCollectionService.collectContext(event));
        }
    }

    private void init() {
        this.logLocation = Platform.getPreferencesService().getString("com.nxp.s32ds.ext.rcp.datacollection.ui", "s32ds.datacollection.log.location", DataCollectionPreferenceConstants.getDefaultLogLocation(), null);
        String enabled = Platform.getPreferencesService().getString("com.nxp.s32ds.ext.rcp.datacollection.ui", "s32ds.datacollection.enable", "none", null);
        this.isEnabled = Boolean.valueOf(enabled);
        this.host = Platform.getPreferencesService().getString("com.nxp.s32ds.ext.rcp.datacollection.ui", "s32ds.datacollection.host", "localhost", null);
        this.arbitrage.reInit(this.logLocation);
        this.storage.setLocation(this.logLocation);
        this.machineId = MachineIdUtil.getMachineId(this.logLocation);
        this.transfer.setLocation(this.logLocation);
        this.transfer.setHost(this.host);
        this.transfer.setTimer(DataCollectionService.getDelayTransferTime());
        this.transfer.setMachineId(this.machineId);
        this.transfer.init();
        this.transfer.setEnable(this.isEnabled);
    }

    private static long getDelayTransferTime() {
        String delayStr = System.getProperty("s32ds.datacollection.system.property.delay.transfer.time");
        if (delayStr != null) {
            try {
                return Long.parseLong(delayStr);
            }
            catch (NumberFormatException ex) {
                DataCollectionActivator.getInstance().logError(ex.getMessage(), ex);
            }
        }
        return 3600L;
    }

    private void setConfiguration(Event event) {
        this.logLocation = (String)event.getProperty("s32ds.datacollection.log.location");
        this.host = (String)event.getProperty("s32ds.datacollection.host");
        this.arbitrage.reInit(this.logLocation);
        this.storage.setLocation(this.logLocation);
        this.transfer.setLocation(this.logLocation);
        this.transfer.setHost(this.host);
        this.isEnabled = Boolean.valueOf((String)event.getProperty("s32ds.datacollection.enable"));
        this.transfer.setEnable(this.isEnabled);
    }

    private void collectHead(Event event) {
        this.head.clear();
        this.head = DataCollectionService.collectContext(event);
        this.collectNl();
        this.collectOs();
        this.collectMachineId();
    }

    private void collectMachineId() {
        if (!this.machineId.isEmpty()) {
            this.head.put("machineId", this.machineId);
        }
    }

    private void collectOs() {
        String osVersion;
        String osArch;
        String osName = System.getProperty("os.name");
        if (osName == null) {
            osName = Platform.getOS();
        }
        if ((osArch = System.getProperty("os.arch")) == null) {
            osArch = Platform.getOSArch();
        }
        if ((osVersion = System.getProperty("os.version")) == null) {
            osVersion = "";
        }
        this.head.put("os", osName);
        this.head.put("osArch", osArch);
        this.head.put("osVersion", osVersion);
    }

    private void collectNl() {
        this.head.put("nl", Platform.getNL());
    }

    private static HashMap<String, String> collectContext(Event event) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        Stream.of(event.getPropertyNames()).forEach(p -> {
            if (event.getProperty(p) instanceof String) {
                parameters.put((String)p, (String)event.getProperty(p));
            }
        });
        return parameters;
    }

    private void store(HashMap<String, String> params) {
        try {
            this.storage.storeRecords(params);
        }
        catch (Exception ex) {
            DataCollectionActivator.getInstance().logError(ex.getMessage(), ex);
        }
    }
}

