/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.validation.core;

import com.nxp.s32ds.ext.ide.internal.validation.core.Messages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class HardwareSettingsProjectMarker {
    public static final String MARKER_ID = "com.nxp.s32ds.ext.ide.validation.core.hardware.settings.project.marker";

    public static IStatus createMarker(IProject project) {
        try {
            IMarker marker = project.createMarker(MARKER_ID);
            if (marker.exists()) {
                marker.setAttribute("severity", 1);
                String msg = NLS.bind((String)Messages.HardwareSettingsProjectMarker_UserErrorMessage, (Object)project.getName());
                marker.setAttribute("message", (Object)msg);
                marker.setAttribute("location", (Object)project.getName());
                marker.setAttribute(Messages.HardwareSettingsProjectMarker_MarkerAttrFileName, (Object)project.getLocation().toString());
                String fixMsg = NLS.bind((String)Messages.HardwareSettingsProjectMarker_UserFixMessage, (Object)project.getName());
                marker.setAttribute(Messages.HardwareSettingsProjectMarker_MarkerAttrFixMessage, (Object)fixMsg);
            }
        }
        catch (CoreException ce) {
            ResourcesPlugin.getPlugin().getLog().log(ce.getStatus());
            return ce.getStatus();
        }
        return Status.OK_STATUS;
    }

    public static IStatus delete(IResource resource) {
        try {
            resource.deleteMarkers(MARKER_ID, true, 2);
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
        return Status.OK_STATUS;
    }

    public static boolean containsMarker(IResource resource) {
        try {
            IMarker[] markers = resource.findMarkers(MARKER_ID, true, 2);
            if (markers != null && markers.length > 0) {
                return true;
            }
        }
        catch (CoreException e) {
            ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
        }
        return false;
    }
}

