/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.core.refactoring;

import com.nxp.s32ds.ext.ide.core.internal.ExtIdeCoreActivator;
import com.nxp.s32ds.ext.ide.core.refactoring.ISourceImporter;
import com.nxp.s32ds.ext.ide.core.refactoring.ProjectSet;
import com.nxp.s32ds.ext.ide.core.refactoring.RefactorContext;
import com.nxp.s32ds.ext.ide.core.refactoring.RefactoringParticipant;
import com.nxp.s32ds.ext.ide.internal.validation.core.Messages;
import com.nxp.s32ds.ext.ide.utils.OSFamily;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class RefactorOperation {
    private static final String EMPTY = "";
    protected List<RefactoringParticipant> participants;
    protected RefactorContext ctx;
    protected ISourceImporter sourceImporter;

    public RefactorOperation(List<RefactoringParticipant> participants, ISourceImporter sourceImporter, RefactorContext ctx) {
        this.participants = participants;
        this.sourceImporter = sourceImporter;
        this.ctx = ctx;
    }

    public List<IProject> perform(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        ArrayList<IProject> projectsPerfomed = new ArrayList<IProject>();
        if (this.ctx != null) {
            for (IProjectDescription iter : this.ctx.getProjectDescriptions()) {
                try {
                    IProject newProject = this.performOnProject(iter, (IProgressMonitor)subMonitor.split(1));
                    newProject.refreshLocal(2, (IProgressMonitor)subMonitor.split(1));
                    projectsPerfomed.add(newProject);
                    RefactorOperation.updateProjectReferences(newProject, (IProgressMonitor)subMonitor.split(1));
                }
                catch (InterruptedException | InvocationTargetException | CoreException ex) {
                    ExtIdeCoreActivator.getInstance().logError(Messages.RefactorOperation_unexpected_error_during_rename, ex);
                }
            }
        }
        return projectsPerfomed;
    }

    private static void updateProjectReferences(IProject newProject, IProgressMonitor monitor) throws CoreException {
        IProject[] referencingProjects = newProject.getReferencedProjects();
        if (referencingProjects.length > 0) {
            IProjectDescription description = newProject.getDescription();
            description.setReferencedProjects(new IProject[0]);
            newProject.setDescription(description, monitor);
        }
    }

    protected IProject performOnProject(IProjectDescription project, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        RefactorOperation.unHide(project);
        IPath newPath = this.calcNewPath(project);
        String newProjectName = this.ctx.getNameMap().get(project.getName());
        IProject tgtProject = RefactorOperation.createProjectWithNewName(newProjectName, project, newPath.toString(), monitor);
        if (this.sourceImporter != null) {
            this.sourceImporter.doImport(tgtProject, project.getLocation().toFile(), monitor);
        }
        RefactorOperation.unHide(tgtProject.getDescription());
        IProject srcProject = RefactorOperation.toProject(project.getName());
        this.invokeParticipants(tgtProject, srcProject, monitor);
        return tgtProject;
    }

    private static IProject createProjectWithNewName(String newProjectName, IProjectDescription originalProject, String path, IProgressMonitor monitor) throws CoreException {
        IProject tgtProject = RefactorOperation.toProject(newProjectName);
        IProjectDescription targetProjectDecsr = RefactorOperation.newProjectDescription(originalProject, newProjectName, path);
        tgtProject.create(targetProjectDecsr, monitor);
        tgtProject.open(128, monitor);
        return tgtProject;
    }

    protected IPath calcNewPath(IProjectDescription project) {
        ProjectSet projectsSet;
        String userProjectName = this.ctx.getUserProjectName();
        String name = userProjectName.equals((projectsSet = this.ctx.getProjectsSet()).getName()) ? project.getName() : project.getName().replaceFirst(Matcher.quoteReplacement(projectsSet.getName()), userProjectName);
        int appearanceCount = 0;
        IPath[] projectsPaths = projectsSet.getProjectPaths();
        appearanceCount = StringUtils.countMatches((CharSequence)projectsPaths[0].toString().substring(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString().length()), (CharSequence)projectsSet.getName());
        String prefix = appearanceCount > 1 ? String.valueOf(userProjectName) + '/' : EMPTY;
        return Path.fromOSString((String)(String.valueOf(prefix) + name));
    }

    protected static IProjectDescription newProjectDescription(IProjectDescription src, String name, String path) {
        IProjectDescription dst = ResourcesPlugin.getWorkspace().newProjectDescription(name);
        dst.setLocation(ResourcesPlugin.getWorkspace().getRoot().getLocation().append(path));
        dst.setBuildSpec(src.getBuildSpec());
        dst.setComment(src.getComment());
        dst.setNatureIds(src.getNatureIds());
        return dst;
    }

    protected void invokeParticipants(IProject target, IProject source, IProgressMonitor monitor) {
        String oldNamePart = this.ctx.getProjectsSet().getName();
        String newNamePart = this.ctx.getUserProjectName();
        for (RefactoringParticipant iter : this.participants) {
            iter.apply(target, source, oldNamePart, newNamePart, monitor);
        }
    }

    protected static void unHide(IProjectDescription project) {
        File f;
        if (OSFamily.WINDOWS.isCurrent() && (f = new File(new File(project.getLocationURI()), ".project")).isHidden()) {
            try {
                Files.setAttribute(f.toPath(), "dos:hidden", false, new LinkOption[0]);
            }
            catch (IOException ex) {
                ExtIdeCoreActivator.getInstance().logWarning(Messages.RefactorOperation_cannot_unset_hidden_attribute, ex);
            }
        }
    }

    protected static IProject toProject(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }
}

