/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.control;

import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkSymbolsValidator;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.ToolChainHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.symbol.SdkSymbol;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.symbol.SdkSymbolsHolder;
import com.nxp.s32ds.cle.cdt.sdk.ui.edit.SdkEditDialogConstants;
import com.nxp.s32ds.cle.runtime.sdk.registry.symbol.SymbolSdkKind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class SymbolsControl {
    private final Image includedImage;
    private SdkSymbolsHolder rootSymbolsHolder;
    private SymbolsTable definedSymbolsTable;
    private SymbolsTable undefinedSymbolsTable;
    private final boolean isEnabled;
    private Map<String, SymbolsHolderWrapper> wrappers;
    private IInputValidator inputValidator = new SymbolsInputValidator();

    public SymbolsControl(Composite parent, boolean isEnabled, Map<String, SymbolsHolderWrapper> wrappers) {
        this.includedImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_REMOVE");
        this.isEnabled = isEnabled;
        this.wrappers = wrappers;
        this.initRootToolChainData();
        Composite holderPanel = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).create())).layoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, false).create())).create((Widget)parent);
        this.definedSymbolsTable = new SymbolsTable(holderPanel, SymbolSdkKind.DEFINED_SYMBOL);
        this.definedSymbolsTable.selectionChanged();
        this.undefinedSymbolsTable = new SymbolsTable(holderPanel, SymbolSdkKind.UNDEFINED_SYMBOL);
        this.undefinedSymbolsTable.selectionChanged();
    }

    Map<String, SymbolsHolderWrapper> getSymbols() {
        return this.wrappers;
    }

    void close() {
        this.definedSymbolsTable.dispose();
        this.undefinedSymbolsTable.dispose();
        if (this.includedImage != null) {
            this.includedImage.dispose();
        }
    }

    private void initRootToolChainData() {
        SymbolsHolderWrapper rootWrapper;
        if (this.wrappers != null && (rootWrapper = (SymbolsHolderWrapper)this.wrappers.values().stream().filter(SymbolsHolderWrapper::isRoot).findFirst().orElse(null)) != null) {
            this.rootSymbolsHolder = rootWrapper.getHolder();
        }
    }

    public static class SymbolsHolderWrapper {
        private SdkSymbolsHolder holder;
        private ToolChainHolder toolChainHolder;
        private ToolChainHolder rootToolChainHolder;
        private boolean isRoot;

        SymbolsHolderWrapper(ToolChainHolder rootToolChainHolder) {
            this.holder = new SdkSymbolsHolder(rootToolChainHolder.getTCId());
            this.toolChainHolder = rootToolChainHolder;
            this.rootToolChainHolder = rootToolChainHolder;
            this.isRoot = true;
        }

        public SymbolsHolderWrapper(SdkSymbolsHolder holder, ToolChainHolder toolChainHolder, boolean isRoot) {
            this.holder = holder;
            this.toolChainHolder = toolChainHolder;
            this.isRoot = isRoot;
        }

        List<SdkSymbol> getSymbolsByType(SymbolSdkKind type) {
            return this.holder.getSymbolsByType(type);
        }

        SdkSymbolsHolder getHolder() {
            return this.holder;
        }

        ToolChainHolder getToolChainHolder() {
            return this.toolChainHolder != null ? this.toolChainHolder : this.rootToolChainHolder;
        }

        boolean isRoot() {
            return this.isRoot;
        }
    }

    private static class SymbolsInputValidator
    implements IInputValidator {
        private SdkSymbolsValidator validator = new SdkSymbolsValidator();

        private SymbolsInputValidator() {
        }

        public String isValid(String symbolString) {
            IStatus validationStatus = this.validator.validate(symbolString);
            if (!validationStatus.isOK()) {
                String errorMessage = null;
                errorMessage = validationStatus.isMultiStatus() ? Arrays.stream(validationStatus.getChildren()).filter(status -> !status.isOK()).map(IStatus::getMessage).findFirst().orElse("") : validationStatus.getMessage();
                return SymbolsInputValidator.adjustErrorMessage(symbolString, errorMessage);
            }
            return null;
        }

        private static String adjustErrorMessage(String symbolString, String errorMessage) {
            String quotedSymbolString;
            int index;
            if (errorMessage != null && (index = errorMessage.indexOf(quotedSymbolString = "\"" + symbolString + "\"")) != -1) {
                StringBuilder sb = new StringBuilder();
                sb.append(errorMessage.substring(0, index++));
                sb.append(errorMessage.substring(index + quotedSymbolString.length()));
                return sb.toString();
            }
            return errorMessage;
        }

        private void setExistingSymbols(List<SdkSymbol> symbols) {
            this.validator.setExistingSymbols(symbols.stream().map(SdkSymbol::getSymbolName).collect(Collectors.toList()));
        }

        private void setIsInitialInput(boolean isInitialInput) {
            this.validator.setIsInitialInput(isInitialInput);
        }
    }

    private class SymbolsTable {
        private static final String COLUMN_SYMBOL_TITLE = "Symbol";
        private static final String COLUMN_TYPE_TITLE = "Type";
        private static final int TABLE_VIEWER_STYLE = 68354;
        private static final int TABLE_MAX_VISIBLE_ROWS = 7;
        private static final int TOOLCHAIN_COLUMN_WIDTH = 60;
        private final Map<String, String> typeAliases = new HashMap<String, String>();
        private SymbolSdkKind symbolType;
        private Toolbar toolbar;
        private TableViewer viewer;

        private SymbolsTable(Composite holderPanel, SymbolSdkKind symbolType) {
            this.initLangAliasesMap();
            this.symbolType = symbolType;
            this.createTableViewer(holderPanel, symbolType);
        }

        private void createTableViewer(Composite holderPanel, SymbolSdkKind symbolType) {
            this.toolbar = new Toolbar(holderPanel, this, symbolType);
            this.viewer = new TableViewer(holderPanel, 68354);
            Table table = this.viewer.getTable();
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            table.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, false).span(2, 1).hint(-1, 7 * table.getItemHeight()).create());
            this.setupTable();
            this.createListeners();
        }

        private void createListeners() {
            this.viewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    if (((SymbolsTable)SymbolsTable.this).SymbolsControl.this.isEnabled) {
                        SymbolsTable.this.toolbar.editSelection();
                    }
                }
            });
            this.viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    switch (e.keyCode) {
                        case 8: 
                        case 127: {
                            if (!((SymbolsTable)SymbolsTable.this).SymbolsControl.this.isEnabled || e.stateMask != 0) break;
                            SymbolsTable.this.toolbar.removePressed();
                            break;
                        }
                    }
                }
            });
            this.viewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SymbolsTable.this.selectionChanged();
                }
            });
        }

        private void setupTable() {
            TableViewerColumn nameColumn = new TableViewerColumn(this.viewer, 0);
            nameColumn.getColumn().setText(COLUMN_SYMBOL_TITLE);
            nameColumn.getColumn().setWidth(250);
            nameColumn.setLabelProvider(new CellLabelProvider(){

                public void update(ViewerCell cell) {
                    cell.setText(((SdkSymbol)cell.getElement()).getSymbolName());
                }
            });
            this.createTypeColumn(this.viewer);
            this.createToolChainColumns(this.viewer);
            this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.viewer.setInput(this.getSymbolsFromWrappers());
        }

        private void createTypeColumn(TableViewer tableViewer) {
            TableViewerColumn typeColumn = new TableViewerColumn(tableViewer, 0);
            typeColumn.getColumn().setText(COLUMN_TYPE_TITLE);
            typeColumn.getColumn().setWidth(60);
            typeColumn.setLabelProvider(new CellLabelProvider(){

                public void update(ViewerCell cell) {
                    cell.setText(SymbolsTable.this.typeAliases.get(((SdkSymbol)cell.getElement()).getLangId()));
                }
            });
        }

        private void createToolChainColumns(TableViewer tableViewer) {
            List<String> toolChainAliases = this.getToolChainAliasesFromWrapper();
            if (toolChainAliases == null || toolChainAliases.isEmpty()) {
                return;
            }
            toolChainAliases.forEach(toolChainAlias -> this.createToolChainColumn(tableViewer, (String)toolChainAlias));
        }

        private void initLangAliasesMap() {
            this.typeAliases.put("", "C/C++");
            this.typeAliases.put("c", "C");
            this.typeAliases.put("cpp", "C++");
            this.typeAliases.put("asm", "ASM");
        }

        private void dispose() {
            this.toolbar.dispose();
        }

        private List<String> getToolChainAliasesFromWrapper() {
            return this.getSymbolHolderWrappers().stream().map(wrapper -> wrapper.getToolChainHolder().getTCAlias()).filter(Objects::nonNull).collect(Collectors.toList());
        }

        private void createToolChainColumn(TableViewer tableViewer, final String toolChainAlias) {
            TableViewerColumn tvc = new TableViewerColumn(tableViewer, 0);
            tvc.getColumn().setText(toolChainAlias);
            tvc.setLabelProvider(new CellLabelProvider(){

                public void update(ViewerCell cell) {
                    if (((SymbolsTable)SymbolsTable.this).SymbolsControl.this.wrappers == null) {
                        return;
                    }
                    SdkSymbol symbol = (SdkSymbol)cell.getElement();
                    SymbolsHolderWrapper symbolsHolderWrapper = ((SymbolsTable)SymbolsTable.this).SymbolsControl.this.wrappers.get(symbol.getHolderToolChainId());
                    String symbolToolChainAlias = symbolsHolderWrapper.getToolChainHolder().getTCAlias();
                    if (symbolsHolderWrapper.isRoot() || symbolToolChainAlias != null && symbolToolChainAlias.equals(toolChainAlias)) {
                        cell.setImage(((SymbolsTable)SymbolsTable.this).SymbolsControl.this.includedImage);
                    }
                }
            });
            tvc.getColumn().pack();
        }

        private void selectionChanged() {
            Table table = this.viewer.getTable();
            int index = table.getSelectionIndex();
            int size = table.getItemCount();
            int selectionCount = table.getSelectionCount();
            if (SymbolsControl.this.isEnabled) {
                this.toolbar.deleteItem.setEnabled(size > 0 && selectionCount != 0);
                this.toolbar.moveUpItem.setEnabled(size > 1 && index > 0 && selectionCount == 1);
                this.toolbar.moveDownItem.setEnabled(size > 1 && index >= 0 && index < size - 1 && selectionCount == 1);
                this.toolbar.editItem.setEnabled(selectionCount == 1);
            }
            this.viewer.refresh();
        }

        private List<SdkSymbol> getSymbolsFromWrappers() {
            return this.getSymbolHolderWrappers().stream().flatMap(wrapper -> wrapper.getSymbolsByType(this.symbolType).stream()).collect(Collectors.toList());
        }

        private Collection<SymbolsHolderWrapper> getSymbolHolderWrappers() {
            return SymbolsControl.this.wrappers != null ? SymbolsControl.this.wrappers.values() : Collections.emptyList();
        }

        private TableViewer getViewer() {
            return this.viewer;
        }
    }

    private class Toolbar {
        private final Image addImage = CDTSharedImages.getImage((String)"icons/elcl16/list-add.gif");
        private final Image deleteImage = CDTSharedImages.getImage((String)"icons/elcl16/list-delete.gif");
        private final Image editImage = CDTSharedImages.getImage((String)"icons/elcl16/list-edit.gif");
        private final Image moveUpImage = CDTSharedImages.getImage((String)"icons/elcl16/list-moveup.gif");
        private final Image moveDownImage = CDTSharedImages.getImage((String)"icons/elcl16/list-movedown.gif");
        private ToolItem addItem;
        private ToolItem deleteItem;
        private ToolItem editItem;
        private ToolItem moveUpItem;
        private ToolItem moveDownItem;
        private final SymbolsTable symbolsTable;
        private final SymbolSdkKind symbolType;

        private Toolbar(Composite holderPanel, SymbolsTable symbolsTable, SymbolSdkKind symbolType) {
            this.symbolsTable = symbolsTable;
            this.symbolType = symbolType;
            this.create(holderPanel);
        }

        private Composite create(Composite holderPanel) {
            Composite titlePanel = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).spacing(0, 0).margins(0, 2).create())).layoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, false).hint(-1, 25).create())).create((Widget)holderPanel);
            this.createLabel(titlePanel);
            if (SymbolsControl.this.isEnabled) {
                Composite buttonPanel = (Composite)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)GridLayoutFactory.swtDefaults().numColumns(5).spacing(0, 0).margins(0, 0).create())).create((Widget)titlePanel);
                this.createItems(buttonPanel);
            }
            return titlePanel;
        }

        private void createLabel(Composite titlePanel) {
            Label label = new Label(titlePanel, 0);
            switch (this.symbolType) {
                case DEFINED_SYMBOL: {
                    label.setText(Messages.SdKEditDialogSymbolsControl_label_defined_symbols);
                    break;
                }
                case UNDEFINED_SYMBOL: {
                    label.setText(Messages.SdKEditDialogSymbolsControl_label_undefined_symbols);
                    break;
                }
                default: {
                    label.setText("?");
                }
            }
        }

        private void createItems(Composite buttonPanel) {
            ToolBar toolBar = new ToolBar(buttonPanel, 8519936);
            this.addItem = new ToolItem(toolBar, 8);
            this.addItem.setImage(this.addImage);
            this.addItem.setToolTipText(Messages.SdKEditDialogSymbolsControl_button_add_tooltip);
            this.addItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Toolbar.this.addPressed();
                }
            });
            this.deleteItem = new ToolItem(toolBar, 8);
            this.deleteItem.setImage(this.deleteImage);
            this.deleteItem.setToolTipText(Messages.SdKEditDialogSymbolsControl_button_delete_tooltip);
            this.deleteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Toolbar.this.removePressed();
                }
            });
            this.editItem = new ToolItem(toolBar, 8);
            this.editItem.setImage(this.editImage);
            this.editItem.setToolTipText(Messages.SdKEditDialogSymbolsControl_button_edit_tooltip);
            this.editItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Toolbar.this.editSelection();
                }
            });
            this.moveUpItem = new ToolItem(toolBar, 8);
            this.moveUpItem.setImage(this.moveUpImage);
            this.moveUpItem.setToolTipText(Messages.SdKEditDialogSymbolsControl_button_moveup_tooltip);
            this.moveUpItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Toolbar.this.upPressed();
                }
            });
            this.moveDownItem = new ToolItem(toolBar, 8);
            this.moveDownItem.setImage(this.moveDownImage);
            this.moveDownItem.setToolTipText(Messages.SdKEditDialogSymbolsControl_button_movedown_tooltip);
            this.moveDownItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Toolbar.this.downPressed();
                }
            });
            GridData grid3 = new GridData(896);
            buttonPanel.setLayoutData((Object)grid3);
            this.enable();
        }

        private void enable() {
            this.addItem.setEnabled(SymbolsControl.this.isEnabled);
            this.editItem.setEnabled(SymbolsControl.this.isEnabled);
            this.deleteItem.setEnabled(SymbolsControl.this.isEnabled);
            this.moveUpItem.setEnabled(SymbolsControl.this.isEnabled);
            this.moveDownItem.setEnabled(SymbolsControl.this.isEnabled);
        }

        private void dispose() {
            if (this.addImage != null) {
                this.addImage.dispose();
            }
            if (this.editImage != null) {
                this.editImage.dispose();
            }
            if (this.deleteImage != null) {
                this.deleteImage.dispose();
            }
            if (this.moveUpImage != null) {
                this.moveUpImage.dispose();
            }
            if (this.moveDownImage != null) {
                this.moveDownImage.dispose();
            }
        }

        private void addPressed() {
            SdkSymbol input = this.getNewInputObject();
            if (input != null) {
                Table table = this.getViewer().getTable();
                int index = table.getSelectionIndex();
                if (index == -1) {
                    index = 0;
                }
                this.addSymbol(index, input);
                table.setSelection(index);
            }
            this.viewerSelectionChanged();
            this.updateViewerInput();
        }

        private void upPressed() {
            Table table = this.getViewer().getTable();
            int index = table.getSelectionIndex();
            if (index <= 0) {
                this.moveUpItem.setEnabled(false);
                return;
            }
            SdkSymbol selectedSymbol = (SdkSymbol)table.getItem(index).getData();
            this.removeSymbol(index);
            int newIndex = index - 1;
            this.addSymbol(newIndex, selectedSymbol);
            this.viewerSelectionChanged();
            this.updateViewerInput();
            table.setSelection(newIndex);
            this.moveUpItem.setEnabled(SymbolsControl.this.isEnabled && newIndex > 0);
        }

        private void downPressed() {
            Table table = this.getViewer().getTable();
            int index = table.getSelectionIndex();
            if (index >= this.getSymbolsFromWrappers().size() - 1) {
                this.moveDownItem.setEnabled(false);
                return;
            }
            SdkSymbol selectedSymbol = (SdkSymbol)table.getItem(index).getData();
            this.removeSymbol(index);
            int newIndex = index + 1;
            this.addSymbol(newIndex, selectedSymbol);
            this.viewerSelectionChanged();
            this.updateViewerInput();
            table.setSelection(newIndex);
            this.moveDownItem.setEnabled(SymbolsControl.this.isEnabled && newIndex < this.getSymbolsFromWrappers().size() - 1);
        }

        private void removePressed() {
            Table table = this.getViewer().getTable();
            if (table.getSelectionCount() == 0 || table.getSelectionIndex() == -1) {
                return;
            }
            int[] indexes = table.getSelectionIndices();
            ArrayList<SdkSymbol> toRemove = new ArrayList<SdkSymbol>();
            int[] nArray = indexes;
            int n = indexes.length;
            int n2 = 0;
            while (n2 < n) {
                int index = nArray[n2];
                toRemove.add((SdkSymbol)table.getItem(index).getData());
                ++n2;
            }
            if (!this.confirmRemove(toRemove)) {
                return;
            }
            for (SdkSymbol symbol2Remove : toRemove) {
                SymbolsControl.this.rootSymbolsHolder.removeSymbol(symbol2Remove, this.symbolType);
            }
            this.viewerSelectionChanged();
            this.updateViewerInput();
        }

        private boolean confirmRemove(List<SdkSymbol> symbolsToRemove) {
            boolean[] isRemoveConfirmed = new boolean[1];
            StringBuilder sb = new StringBuilder();
            symbolsToRemove.stream().forEach(s -> {
                StringBuilder stringBuilder2 = sb.append(s.getSymbolName()).append('\n');
            });
            Shell shell = this.getViewer().getTable().getShell();
            shell.getDisplay().syncExec(() -> {
                boolean bl = MessageDialog.openConfirm((Shell)shell, (String)Messages.SdKEditDialogSymbolsControl_delete_symbols_message_title, (String)NLS.bind((String)Messages.SdKEditDialogSymbolsControl_delete_symbols_message_text, (Object)sb.toString()));
            });
            return isRemoveConfirmed[0];
        }

        private void editSelection() {
            String newSymbol;
            Table table = this.getViewer().getTable();
            int index = table.getSelectionIndex();
            if (index == -1) {
                return;
            }
            SdkSymbol selItem = (SdkSymbol)table.getItem(index).getData();
            if (selItem == null) {
                return;
            }
            SymbolsInputValidator siv = (SymbolsInputValidator)SymbolsControl.this.inputValidator;
            siv.setExistingSymbols(this.getSymbolsFromWrappers());
            siv.setIsInitialInput(true);
            InputDialog dialog = new InputDialog(table.getShell(), Messages.SdKEditDialogSymbolsControl_input_dialog_edit_symbol_title, Messages.SdKEditDialogSymbolsControl_input_dialog_edit_symbol_label, selItem.getSymbolName(), SymbolsControl.this.inputValidator){

                protected Control createDialogArea(Composite parent) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp(super.createDialogArea(parent), SdkEditDialogConstants.SYMBOLS_CONTEXT_HELP_ID);
                    return parent;
                }
            };
            if (dialog.open() == 0 && !(newSymbol = dialog.getValue().trim()).equals(selItem.getSymbolName())) {
                selItem.setSymbolName(newSymbol);
                this.viewerSelectionChanged();
                this.updateViewerInput();
            }
        }

        private SdkSymbol getNewInputObject() {
            Table table = this.getViewer().getTable();
            ((SymbolsInputValidator)SymbolsControl.this.inputValidator).setExistingSymbols(this.getSymbolsFromWrappers());
            InputDialog dialog = new InputDialog(table.getShell(), Messages.SdKEditDialogSymbolsControl_input_dialog_new_symbol_title, Messages.SdKEditDialogSymbolsControl_input_dialog_new_symbol_label, "", SymbolsControl.this.inputValidator){

                protected Control createDialogArea(Composite parent) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp(super.createDialogArea(parent), SdkEditDialogConstants.SYMBOLS_CONTEXT_HELP_ID);
                    return parent;
                }
            };
            if (dialog.open() == 0) {
                return new SdkSymbol(dialog.getValue().trim(), "", SymbolsControl.this.rootSymbolsHolder);
            }
            return null;
        }

        private void addSymbol(int index, SdkSymbol symbol) {
            List<SdkSymbol> symbolsByType = SymbolsControl.this.rootSymbolsHolder.getSymbolsByType(this.symbolType);
            if (symbolsByType.isEmpty()) {
                SymbolsControl.this.rootSymbolsHolder.addSymbol(symbol, this.symbolType);
            } else {
                symbolsByType.add(index, symbol);
            }
        }

        private void removeSymbol(int index) {
            SymbolsControl.this.rootSymbolsHolder.getSymbolsByType(this.symbolType).remove(index);
        }

        private TableViewer getViewer() {
            return this.symbolsTable.viewer;
        }

        private List<SdkSymbol> getSymbolsFromWrappers() {
            return this.symbolsTable.getSymbolsFromWrappers();
        }

        private void viewerSelectionChanged() {
            this.symbolsTable.selectionChanged();
        }

        private void updateViewerInput() {
            this.symbolsTable.getViewer().setInput(this.symbolsTable.getSymbolsFromWrappers());
        }
    }
}

