/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.gui;

import com.nxp.swtools.common.uct.validation.IProblemUIContainer;
import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.efuse.controller.validation.EfuseProblem;
import com.nxp.swtools.efuse.controls.IntegerSettingControl;
import com.nxp.swtools.efuse.gui.EfuseValidatedTextField;
import com.nxp.swtools.efuse.gui.utils.EfuseGuiUtils;
import com.nxp.swtools.efuse.model.utils.EfuseUtils;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseIntegerSetting;
import com.nxp.swtools.validation.engine.IBaseProblem;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;

public class EfuseUIProblem
extends EfuseProblem {
    public EfuseUIProblem(EfuseProblem problem) {
        super(problem.getProblemLevel(), problem.getMessage(), problem.getSource(), problem.getResource(), problem.getTooltip(), problem.getType(), problem.getId(), problem.getProblemSource());
    }

    public void openProblem(IBaseProblem problem) {
        EfuseValidatedTextField problemSourceNode;
        TabPane rootTabPane;
        EfuseProblem eFuseProblem;
        IProblemUIContainer problemSourceContainer;
        this.openTool("eFUSE");
        if (problem instanceof EfuseProblem && (problemSourceContainer = (eFuseProblem = (EfuseProblem)problem).getSourceContainer()) instanceof EfuseValidatedTextField && (rootTabPane = EfuseUIProblem.findRootTabPane(problemSourceNode = (EfuseValidatedTextField)problemSourceContainer)) != null) {
            EfuseUtils.Mode problemSourceTab = EfuseUIProblem.getProblemSourceTab(problemSourceNode);
            String currentSelectedTab = ((Tab)rootTabPane.getSelectionModel().getSelectedItem()).getId();
            if (problemSourceTab.getTabId().equals(currentSelectedTab)) {
                PerspectivesHelper.showView((String)"com.nxp.swtools.efuse.gui.EfuseView");
                Platform.runLater(() -> ((EfuseValidatedTextField)problemSourceNode).requestFocus());
            } else {
                Tab tabToSwitchTo = EfuseGuiUtils.getTabWithId(rootTabPane, problemSourceTab.getTabId());
                if (tabToSwitchTo != null) {
                    Platform.runLater(() -> {
                        PerspectivesHelper.showView((String)"com.nxp.swtools.efuse.gui.EfuseView");
                        rootTabPane.getSelectionModel().select((Object)tabToSwitchTo);
                        problemSourceNode.requestFocus();
                    });
                }
            }
        }
    }

    public static @Nullable TabPane findRootTabPane(EfuseValidatedTextField problemSourceNode) {
        Parent parent = problemSourceNode.getParent();
        while (parent != null && !(parent instanceof TabPane)) {
            parent = parent.getParent();
        }
        if (parent != null) {
            return (TabPane)parent;
        }
        return null;
    }

    private static EfuseUtils.Mode getProblemSourceTab(EfuseValidatedTextField problemSourceNode) {
        IntegerSettingControl parentControl = problemSourceNode.getParentControl();
        EfuseIntegerSetting integerSetting = parentControl.getIntegerSetting();
        if ("value_advanced".equals(integerSetting.getId())) {
            return EfuseUtils.Mode.ADVANCED;
        }
        return EfuseUtils.Mode.STANDARD;
    }
}

