/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.controls;

import com.nxp.swtools.common.uct.controller.AUctController;
import com.nxp.swtools.common.uct.controls.IChildControl;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.ItemSetting;
import com.nxp.swtools.common.uct.utils.UctLayoutUtils;
import com.nxp.swtools.common.uct.utils.UctUtils;
import com.nxp.swtools.common.uct.validation.AUctProblem;
import com.nxp.swtools.common.uct.validation.AValidatedTextField;
import com.nxp.swtools.common.uct.validation.IProblemSource;
import com.nxp.swtools.common.uct.validation.IProblemUIContainer;
import com.nxp.swtools.common.uct.validation.ITextFieldValidator;
import com.nxp.swtools.common.uct.validation.MultipleBaseAddressValidator;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import com.nxp.swtools.efuse.controller.EfuseController;
import com.nxp.swtools.efuse.controller.utils.EfuseControllerUtils;
import com.nxp.swtools.efuse.controller.utils.StorageEfuseUtils;
import com.nxp.swtools.efuse.controller.validation.EfuseProblem;
import com.nxp.swtools.efuse.controller.validation.EfuseProblemsManager;
import com.nxp.swtools.efuse.controls.ArraySettingControl;
import com.nxp.swtools.efuse.controls.EnumSettingControl;
import com.nxp.swtools.efuse.controls.StructSettingNode;
import com.nxp.swtools.efuse.gui.EfuseSceneCreator;
import com.nxp.swtools.efuse.gui.EfuseUIProblem;
import com.nxp.swtools.efuse.gui.EfuseValidatedTextField;
import com.nxp.swtools.efuse.gui.utils.EfuseActions;
import com.nxp.swtools.efuse.gui.utils.EfuseGuiUtils;
import com.nxp.swtools.efuse.gui.utils.Messages;
import com.nxp.swtools.efuse.model.EfuseEntity;
import com.nxp.swtools.efuse.model.FuseField;
import com.nxp.swtools.efuse.model.FuseWord;
import com.nxp.swtools.efuse.model.mcu.IEfuseMcu;
import com.nxp.swtools.efuse.model.utils.EfuseUtils;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseBoolSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseEnumSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseIntegerSetting;
import com.nxp.swtools.validation.engine.GenericProblem;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import org.eclipse.ui.services.IDisposable;

public class IntegerSettingControl
extends HBox
implements IChildControl,
IDisposable {
    private EfuseIntegerSetting integerSetting;
    protected Parent parent;
    private EfuseValidatedTextField integerSettingTxt;

    public IntegerSettingControl(EfuseIntegerSetting integerSetting, Parent parent) {
        this.integerSetting = integerSetting;
        this.parent = parent;
        this.integerSettingTxt = new EfuseValidatedTextField(this);
        this.create();
    }

    public void create() {
        this.setId(this.integerSetting.getId());
        Label integerSettingLbl = new Label(this.integerSetting.getLabel());
        integerSettingLbl.setContentDisplay(ContentDisplay.RIGHT);
        integerSettingLbl.getStyleClass().add((Object)"default-c-style");
        integerSettingLbl.setGraphic((Node)this.integerSettingTxt);
        integerSettingLbl.setPadding(new Insets(20.0));
        this.getChildren().add((Object)integerSettingLbl);
        this.getChildren().add((Object)this.integerSettingTxt);
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.integerSetting);
        this.integerSettingTxt.setDisable(this.integerSetting.isReadOnly());
        this.integerSettingTxt.addValidator((ITextFieldValidator)new MultipleBaseAddressValidator(!this.integerSetting.getSize().isEmpty() ? this.integerSetting.getSizeInBits() : 32));
        this.integerSettingTxt.textProperty().addListener(this.getIntegerTxtFieldListener());
        String initialValue = "0x" + Long.toHexString(UctUtils.getLongValueFromString((String)this.integerSetting.getCurrentValue()));
        String modelValue = this.integerSetting.getCurrentValue();
        if (!NumberFormatValidator.isValidDecimal((String)modelValue) && !NumberFormatValidator.isValidHexadecimal((String)modelValue) && UctUtils.getLongValueFromString((String)modelValue) != 0L) {
            initialValue = modelValue;
        }
        this.integerSettingTxt.setText(initialValue);
        UctLayoutUtils.registerListenerForControl((AUctController)EfuseController.getInstance(), (IChildControl)this, (int)4);
        this.disabledProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(@Nullable ObservableValue<? extends Boolean> observableValue, Boolean wasDisabled, Boolean isDisabled) {
                StorageEfuseUtils.updateStorageComponent((ABaseUIComponentSetting)IntegerSettingControl.this.integerSetting);
            }
        });
        EfuseSceneCreator.getNodes().add((Node)this);
        EfuseSceneCreator.getNodes().add((Node)this.integerSettingTxt);
        EfuseSceneCreator.getNodes().add((Node)integerSettingLbl);
    }

    public void refresh() {
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.integerSetting);
        long currentIntegerSettingTxtValue = UctUtils.getLongValueFromString((String)Objects.requireNonNull(this.integerSettingTxt.getText()));
        long currentIntegerSettingValue = -1L;
        if (NumberFormatValidator.isValidDecimal((String)this.integerSetting.getCurrentValue()) || UctUtils.getLongValueFromString((String)this.integerSetting.getCurrentValue()) == 0L || NumberFormatValidator.isValidHexadecimal((String)this.integerSetting.getCurrentValue())) {
            currentIntegerSettingValue = UctUtils.getLongValueFromString((String)this.integerSetting.getCurrentValue());
            if (currentIntegerSettingTxtValue != currentIntegerSettingValue) {
                this.integerSettingTxt.setText("0x" + Long.toHexString(currentIntegerSettingValue));
            }
        } else {
            this.integerSettingTxt.setText(this.integerSetting.getCurrentValue());
        }
        if (!this.integerSettingTxt.isValid()) {
            if (this.integerSettingTxt.isDisabled()) {
                EfuseController.getInstance().getProblemsManager().clearProblems((IProblemSource)this.integerSetting);
                this.integerSettingTxt.resetStyle();
            } else if (EfuseController.getInstance().getProblemsManager().getProblemListForContainer((IProblemUIContainer)this.integerSettingTxt).isEmpty()) {
                StringBuilder resource = new StringBuilder();
                resource.append(this.integerSetting.getLabel());
                EfuseGuiUtils.setTextFieldError(this.integerSettingTxt, this.integerSetting, resource.toString());
            }
        }
        if (!this.integerSettingTxt.isDisabled() && EfuseUtils.getCurrentMode().equals((Object)EfuseUtils.Mode.ADVANCED)) {
            this.checkSynchronizationBetweenModesForFuseWords();
        }
    }

    public Parent getParentControl() {
        return this.parent;
    }

    public void setParentControl(Parent parent) {
        this.parent = parent;
    }

    private ChangeListener<String> getIntegerTxtFieldListener() {
        ChangeListener integerTextfieldListener = (observable, oldValue, newValue) -> {
            EfuseProblemsManager eFuseProblemsManager = EfuseController.getInstance().getProblemsManager();
            eFuseProblemsManager.clearProblems((IProblemSource)this.integerSetting);
            this.integerSettingTxt.resetStyle();
            this.integerSetting.setCurrentValue(newValue);
            if (!this.integerSettingTxt.getText().isEmpty() && this.integerSettingTxt.isValid() && !this.integerSetting.isDisabled()) {
                EfuseEntity efuseEntity = EfuseControllerUtils.getEfuseEntity((ABaseUIComponentSetting)this.integerSetting);
                if (efuseEntity != null) {
                    FuseField associatedFuseField = efuseEntity.getFuseField();
                    if (associatedFuseField != null) {
                        associatedFuseField.setValueToWrite(Long.decode(newValue).longValue());
                    } else {
                        FuseWord parentFuseWord = efuseEntity.getParentFuseWord();
                        if (parentFuseWord != null) {
                            parentFuseWord.setValueToWrite(Long.decode(newValue).longValue());
                        }
                    }
                }
                if (EfuseUtils.getCurrentMode().equals((Object)EfuseUtils.Mode.ADVANCED) && !this.integerSettingTxt.isDisabled()) {
                    EfuseGuiUtils.synchronizeStandardFuseWithAdvancedModeFuse(this.integerSetting, this.getParentControl());
                    EfuseGuiUtils.refreshEfuseBinaryConfigurationTable();
                    this.checkSynchronizationBetweenModesForFuseWords();
                    Parent parentLoc = this.getParentControl();
                    for (Node node : parentLoc.getChildrenUnmodifiable()) {
                        if (!(node instanceof EnumSettingControl)) continue;
                        EnumSettingControl enumNode = (EnumSettingControl)node;
                        String fuseWordId = enumNode.getEnumSetting().getCurrentValue();
                        StorageEfuseUtils.updateStorageForAdvancedFuseWord((Object)((Object)this), (String)fuseWordId);
                        EfuseGuiUtils.checkAddressLimitProblem(this.integerSettingTxt, this.integerSetting, enumNode.getEnumSetting());
                    }
                }
                if (EfuseUtils.getCurrentMode().equals((Object)EfuseUtils.Mode.STANDARD)) {
                    StorageEfuseUtils.updateStorageComponent((Object)((Object)this), (ABaseUIComponentSetting)this.integerSetting);
                }
                EfuseActions.executeAction(this.integerSetting.getAction());
            } else {
                StringBuilder resource = new StringBuilder();
                resource.append(this.integerSetting.getLabel());
                EfuseGuiUtils.setTextFieldError(this.integerSettingTxt, this.integerSetting, resource.toString());
                if (EfuseUtils.isTextFieldFormatValid((AValidatedTextField)this.integerSettingTxt)) {
                    EfuseEntity efuseEntity = EfuseControllerUtils.getEfuseEntity((ABaseUIComponentSetting)this.integerSetting);
                    if (efuseEntity != null) {
                        FuseField associatedFuseField = efuseEntity.getFuseField();
                        if (associatedFuseField != null) {
                            associatedFuseField.setValueToWrite(Long.decode(newValue).longValue());
                        } else {
                            FuseWord parentFuseWord = efuseEntity.getParentFuseWord();
                            if (parentFuseWord != null) {
                                parentFuseWord.setValueToWrite(Long.decode(newValue).longValue());
                            }
                        }
                    }
                    if (EfuseUtils.getCurrentMode().equals((Object)EfuseUtils.Mode.STANDARD)) {
                        StorageEfuseUtils.updateStorageComponent((Object)((Object)this), (ABaseUIComponentSetting)this.integerSetting);
                    }
                }
            }
        };
        return integerTextfieldListener;
    }

    public void checkSynchronizationBetweenModesForFuseWords() {
        Collection<StructSettingNode> items;
        ArraySettingControl advancedFusesArray = this.findAdvancedFusesArray();
        if (advancedFusesArray != null && (items = advancedFusesArray.getItems()) != null) {
            for (StructSettingNode item : items) {
                for (Node node : item.getRegion().getChildrenUnmodifiable()) {
                    IntegerSettingControl integerNode;
                    if (!(node instanceof IntegerSettingControl) || !"value_advanced".equals((integerNode = (IntegerSettingControl)node).getId())) continue;
                    IntegerSettingControl.checkSynchronizationBetweenModesForTextField(integerNode);
                }
            }
        }
    }

    private static void checkSynchronizationBetweenModesForTextField(IntegerSettingControl textField) {
        EfuseIntegerSetting txtFieldIntegerSetting = textField.getIntegerSetting();
        String value = txtFieldIntegerSetting.getCurrentValue();
        if (!NumberFormatValidator.isValidDecimal((String)value) && !NumberFormatValidator.isValidHexadecimal((String)value)) {
            return;
        }
        EfuseValidatedTextField validatedTextField = textField.getEfuseValidatedTextfield();
        EfuseProblemsManager problemsManager = EfuseController.getInstance().getProblemsManager();
        if (problemsManager.hasSourceProblemOfType((IProblemSource)txtFieldIntegerSetting, AUctProblem.Type.WARNING_SYNCHRONIZATION_LOST)) {
            problemsManager.clearProblems((IProblemSource)txtFieldIntegerSetting, AUctProblem.Type.WARNING_SYNCHRONIZATION_LOST);
            validatedTextField.resetStyle();
        }
        Parent parentLoc = textField.getParentControl();
        for (Node node : parentLoc.getChildrenUnmodifiable()) {
            if (!(node instanceof EnumSettingControl)) continue;
            EnumSettingControl enumNode = (EnumSettingControl)node;
            String fuseWordId = enumNode.getEnumSetting().getCurrentValue();
            IEfuseMcu mcu = EfuseController.getInstance().getEfuseMcu();
            FuseWord fuseWord = EfuseUtils.getFuseWordByID((List)mcu.getAllFuseWords(), (String)fuseWordId);
            if (fuseWord == null) continue;
            List fuseFields = fuseWord.getFuseFields();
            boolean isValueAssociatedWithSetting = false;
            StringBuilder sb = new StringBuilder();
            for (FuseField fuseField : fuseFields) {
                long fuseFieldValue = EfuseUtils.getFuseFieldValueFromFuseWord((FuseField)fuseField, (FuseWord)fuseWord);
                ABaseUIComponentSetting fuseFieldUIComponent = null;
                fuseFieldUIComponent = EfuseUtils.isFuseFieldAssociatedWithMultipleComponents((IEfuseMcu)mcu, (String)fuseField.getXmlSetting().getId()) ? EfuseControllerUtils.getVisibleUIComponentByFuseFieldId((String)fuseField.getXmlSetting().getId()) : EfuseUtils.getComponentSettingById((IEfuseMcu)mcu, (String)fuseField.getXmlSetting().getId());
                if (fuseFieldUIComponent == null || !EfuseControllerUtils.isComponentVisible((ABaseUIComponentSetting)fuseFieldUIComponent) || EfuseControllerUtils.isComponentDisable((ABaseUIComponentSetting)fuseFieldUIComponent)) continue;
                if (fuseFieldUIComponent instanceof EfuseEnumSetting) {
                    EfuseEnumSetting enumSetting = (EfuseEnumSetting)fuseFieldUIComponent;
                    String enumValue = "0x" + Long.toHexString(fuseFieldValue);
                    List enumItems = EfuseControllerUtils.getEnumSettingItems((EfuseEnumSetting)enumSetting);
                    for (ItemSetting item : enumItems) {
                        if (!Long.valueOf(item.getValueToWrite()).equals(Long.decode(enumValue))) continue;
                        isValueAssociatedWithSetting = true;
                        break;
                    }
                    if (!isValueAssociatedWithSetting) {
                        sb.append(enumSetting.getLabel());
                        sb.append(";");
                        continue;
                    }
                    isValueAssociatedWithSetting = false;
                    continue;
                }
                if (!(fuseFieldUIComponent instanceof EfuseBoolSetting)) continue;
                EfuseBoolSetting boolSetting = (EfuseBoolSetting)fuseFieldUIComponent;
                if (fuseFieldValue >= 0L && fuseFieldValue <= 1L) continue;
                sb.append(boolSetting.getLabel());
                sb.append(";");
            }
            if (sb.length() <= 0 || !EfuseController.getInstance().getProblemsManager().getProblemListForSource((IProblemSource)txtFieldIntegerSetting).isEmpty()) continue;
            String message = MessageFormat.format(Messages.WarningMsg_LostSync, enumNode.getEnumCmb().getValue(), sb.toString());
            String source = String.valueOf((String)enumNode.getEnumCmb().getValue()) + "." + txtFieldIntegerSetting.getLabel() + ":" + validatedTextField.getText();
            String resource = String.valueOf((String)enumNode.getEnumCmb().getValue()) + "." + txtFieldIntegerSetting.getLabel();
            EfuseProblem problem = new EfuseProblem(1, message, source, resource, "", AUctProblem.Type.WARNING_SYNCHRONIZATION_LOST, UUID.randomUUID(), (IProblemSource)txtFieldIntegerSetting);
            EfuseUIProblem uiProblem = new EfuseUIProblem(problem);
            uiProblem.setSourceContainer((IProblemUIContainer)validatedTextField);
            EfuseController.getInstance().getProblemsManager().addProblem((GenericProblem)uiProblem);
            validatedTextField.setTextFieldWarningStyle();
        }
    }

    private @Nullable ArraySettingControl findAdvancedFusesArray() {
        Parent parentLoc = this.getParentControl();
        while (parentLoc != null && !(parentLoc instanceof ArraySettingControl)) {
            parentLoc = parentLoc.getParent();
        }
        if (parentLoc != null && "fuse_array".equals(parentLoc.getId())) {
            return (ArraySettingControl)parentLoc;
        }
        return null;
    }

    public EfuseIntegerSetting getIntegerSetting() {
        return this.integerSetting;
    }

    public EfuseValidatedTextField getEfuseValidatedTextfield() {
        return this.integerSettingTxt;
    }

    public void dispose() {
        EfuseController.getInstance().getProblemsManager().clearProblems((IProblemSource)this.integerSetting);
        UctLayoutUtils.removeListenerForControl((AUctController)EfuseController.getInstance(), (IChildControl)this);
        EfuseSceneCreator.getNodes().remove((Object)this);
        EfuseSceneCreator.getNodes().remove((Object)this.integerSettingTxt);
        this.getChildren().clear();
    }
}

