/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.controls;

import com.nxp.swtools.common.uct.controller.AUctController;
import com.nxp.swtools.common.uct.controls.IChildControl;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.utils.UctLayoutUtils;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.efuse.controller.EfuseController;
import com.nxp.swtools.efuse.controller.utils.EfuseControllerUtils;
import com.nxp.swtools.efuse.controller.utils.StorageEfuseUtils;
import com.nxp.swtools.efuse.gui.EfuseSceneCreator;
import com.nxp.swtools.efuse.gui.utils.EfuseActions;
import com.nxp.swtools.efuse.gui.utils.EfuseGuiUtils;
import com.nxp.swtools.efuse.model.EfuseEntity;
import com.nxp.swtools.efuse.model.FuseField;
import com.nxp.swtools.efuse.model.utils.EfuseUtils;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseBoolSetting;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import org.eclipse.ui.services.IDisposable;

public class BoolSettingControl
extends CheckBox
implements IChildControl,
IDisposable {
    private EfuseBoolSetting boolSetting;
    protected Parent parent;

    public BoolSettingControl(EfuseBoolSetting boolSetting, Parent parent) {
        this.boolSetting = boolSetting;
        this.parent = parent;
        this.create();
    }

    public void create() {
        this.setId(this.boolSetting.getId());
        this.setMnemonicParsing(false);
        this.setText(this.boolSetting.getLabel());
        this.setSelected("true".equalsIgnoreCase(this.boolSetting.getCurrentValue()));
        this.getStyleClass().add((Object)"default-c-style");
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.boolSetting);
        UctLayoutUtils.registerListenerForControl((AUctController)EfuseController.getInstance(), (IChildControl)this, (int)4);
        this.selectedProperty().addListener((obs, wasOn, isNowOn) -> {
            FuseField associatedFuseField;
            String currentValue = this.isSelected() ? "true" : "false";
            this.boolSetting.setCurrentValue(currentValue);
            EfuseEntity boolEfuseEntity = EfuseControllerUtils.getEfuseEntity((ABaseUIComponentSetting)this.boolSetting);
            if (boolEfuseEntity != null && (associatedFuseField = boolEfuseEntity.getFuseField()) != null) {
                associatedFuseField.setValueToWrite(this.isSelected() ? 1L : 0L);
            }
            EfuseActions.executeAction(this.boolSetting.getAction());
            EfuseActions.executeSyncAction(this.boolSetting.getAction(), currentValue);
            EfuseControllerUtils.updateComponentsState((ABaseUIComponentSetting)this.boolSetting);
            EfuseGuiUtils.updateEnumComboBoxesItems();
            Scene scene = this.getScene();
            if (scene != null) {
                EfuseGuiUtils.refreshUI(scene);
            }
            EfuseGuiUtils.createEfuseBinaryConfigurationTable();
            if (EfuseUtils.getCurrentMode().equals((Object)EfuseUtils.Mode.STANDARD)) {
                StorageEfuseUtils.updateStorageComponent((Object)((Object)this), (ABaseUIComponentSetting)this.boolSetting);
            }
        });
        this.disabledProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(@Nullable ObservableValue<? extends Boolean> observableValue, Boolean wasDisabled, Boolean isDisabled) {
                StorageEfuseUtils.updateStorageComponent((ABaseUIComponentSetting)BoolSettingControl.this.boolSetting);
            }
        });
        EfuseSceneCreator.getNodes().add((Node)this);
    }

    public void refresh() {
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.boolSetting);
        boolean currentBoolSettingValue = this.boolSetting.getCurrentValue().equals("true");
        if (this.isSelected() != currentBoolSettingValue) {
            this.setSelected(currentBoolSettingValue);
        }
    }

    public Parent getParentControl() {
        return this.parent;
    }

    public void setParentControl(Parent parent) {
        this.parent = parent;
    }

    public void dispose() {
        UctLayoutUtils.removeListenerForControl((AUctController)EfuseController.getInstance(), (IChildControl)this);
        EfuseSceneCreator.getNodes().add((Node)this);
        this.getChildren().clear();
    }
}

