/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.model.mcu;

import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.efuse.model.EfuseEntity;
import com.nxp.swtools.efuse.model.FuseField;
import com.nxp.swtools.efuse.model.FuseWord;
import com.nxp.swtools.efuse.model.mcu.EfuseMcu;
import com.nxp.swtools.efuse.model.mcu.IEfuseMcu;
import com.nxp.swtools.efuse.ui.xml.settings.ArraySetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseBitsSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseBoolSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseEnumSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseIntegerSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseStructSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseTextSetting;
import com.nxp.swtools.efuse.xml.settings.EfuseTabSetting;
import com.nxp.swtools.efuse.xml.settings.EfuseXmlConfiguration;
import com.nxp.swtools.efuse.xml.settings.FieldSetting;
import com.nxp.swtools.efuse.xml.settings.FuseFieldsTable;
import com.nxp.swtools.efuse.xml.settings.FuseSetting;
import com.nxp.swtools.efuse.xml.settings.FuseWordsTable;
import com.nxp.swtools.expert.processordb.ExternalMcuDataHelper;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.utils.resources.DataDirectoryUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class McuFactory {
    private static final Logger LOGGER = LogManager.getLogger(McuFactory.class);

    public static @Nullable IEfuseMcu create(ISupportedDerivativesForSwTools supportedDerivatives, ICommonConfig commonConfig) {
        File elfTemplateAppFile;
        IMcuIdentification mcuSelection = commonConfig.getMcuIdentification();
        String sdkVersion = mcuSelection.getSdkVersion();
        String mcuName = mcuSelection.getMcu();
        SWToolsPlatform.CoresInfoLoader coresInfo = SWToolsPlatform.getCoresInfo((String)mcuName, (String)sdkVersion, (ISupportedDerivativesForSwTools)supportedDerivatives);
        ArrayList<ProcessorCore> cores = coresInfo == null ? new ArrayList<ProcessorCore>() : coresInfo.cores;
        IProcessorMasterToolInfo masterToolInfo = supportedDerivatives.getProcessorMasterToolInfo(mcuName, sdkVersion);
        assert (masterToolInfo != null);
        String eFuseXmlModelFile = DataDirectoryUtils.getDbFile((IMcuIdentification)mcuSelection, (String)"efuse_model");
        if (eFuseXmlModelFile.isEmpty()) {
            if (SWToolsProperties.isVerificationOn()) {
                LOGGER.severe("Cannot load eFUSE configuration for: " + mcuSelection);
            }
            return null;
        }
        String dataDir = ExternalMcuDataHelper.getInstance().getExternalMcuDataDir(mcuName, sdkVersion, "eFUSE");
        String eFuseXmlFilePath = String.valueOf(dataDir) + File.separator + eFuseXmlModelFile + File.separator + mcuName + ".xml";
        EfuseXmlConfiguration eFuseConfig = McuFactory.getEfuseXmlConfig(eFuseXmlFilePath);
        if (eFuseConfig == null) {
            if (SWToolsProperties.isVerificationOn()) {
                LOGGER.severe("Cannot read the xml file for: " + mcuSelection);
            }
            return null;
        }
        EfuseMcu mcu = new EfuseMcu(mcuSelection, cores, masterToolInfo, eFuseConfig);
        mcu.getAllFuseWords().addAll(McuFactory.getAllFuseWords(eFuseConfig));
        mcu.getAllEfuseEntities().addAll(McuFactory.getAllEfuseEntities(eFuseConfig));
        mcu.getAllGuiComponentSettings().addAll(McuFactory.getAllUIComponents(mcu.getAllEfuseEntities()));
        File templateAppFile = new File(String.valueOf(dataDir) + File.separator + eFuseXmlModelFile + File.separator + "templateApplication.bin");
        if (templateAppFile.exists()) {
            McuFactory.readTemplateBinaryContentFromFile(templateAppFile, mcu);
        }
        if ((elfTemplateAppFile = new File(String.valueOf(dataDir) + File.separator + eFuseXmlModelFile + File.separator + "templateApplication.elf")).exists()) {
            McuFactory.readElfTemplateBinaryContentFromFile(elfTemplateAppFile, mcu);
        }
        return mcu;
    }

    private static void readTemplateBinaryContentFromFile(File templateAppFile, IEfuseMcu selectedMcu) {
        try {
            byte[] data = Files.readAllBytes(Paths.get(templateAppFile.getPath(), new String[0]));
            ByteBuffer templateBinaryContent = ByteBuffer.allocate(data.length);
            templateBinaryContent.put(data);
            selectedMcu.setTemplateAppBinaryContent(templateBinaryContent);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error while reading from file ", e);
        }
    }

    private static void readElfTemplateBinaryContentFromFile(File templateAppFile, IEfuseMcu selectedMcu) {
        try {
            byte[] data = Files.readAllBytes(Paths.get(templateAppFile.getPath(), new String[0]));
            ByteBuffer templateBinaryContent = ByteBuffer.allocate(data.length);
            templateBinaryContent.put(data);
            selectedMcu.setElfTemplateAppBinaryContent(templateBinaryContent);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error while reading from file ", e);
        }
    }

    private static @Nullable EfuseXmlConfiguration getEfuseXmlConfig(String filePath) {
        File eFuseConfigFile = new File(filePath);
        if (!eFuseConfigFile.exists()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream eFuseConfInStr = UtilsDecryption.getFileInputStream((File)eFuseConfigFile);){
                EfuseXmlConfiguration eFuseConfig = EfuseXmlConfiguration.loadEfuseXmlConfig(eFuseConfInStr);
                if (eFuseConfig != null) {
                    return eFuseConfig;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.severe("Cannot read the eFUSE config file." + e.getMessage());
        }
        return null;
    }

    private static List<FuseWord> getAllFuseWords(EfuseXmlConfiguration eFuseConfig) {
        ArrayList<FuseWord> fuses = new ArrayList<FuseWord>();
        FuseWordsTable xmlFusesTable = eFuseConfig.getFusesList();
        for (FuseSetting fuseSetting : xmlFusesTable.getFusesList()) {
            FuseWord newFuseWord = new FuseWord(fuseSetting);
            McuFactory.setFieldsList(newFuseWord);
            fuses.add(newFuseWord);
        }
        return fuses;
    }

    private static void setFieldsList(FuseWord fuseWord) {
        FuseSetting fuseSetting = fuseWord.getXmlSetting();
        FuseFieldsTable fieldsTable = fuseSetting.getFuseFields();
        if (fieldsTable != null) {
            for (FieldSetting fieldSetting : fieldsTable.getFieldsList()) {
                FuseField field = new FuseField(fieldSetting, fuseWord);
                fuseWord.getFuseFields().add(field);
            }
        }
    }

    private static List<EfuseEntity> getAllEfuseEntities(EfuseXmlConfiguration eFuseConfig) {
        ArrayList<EfuseEntity> allEfuseEntities = new ArrayList<EfuseEntity>();
        for (EfuseTabSetting tabSetting : eFuseConfig.getLayoutComponents().getTabSettings()) {
            EfuseStructSetting tabContent = tabSetting.getEfuseTabContent();
            McuFactory.addToListAllScalarSettingFromStruct(tabContent, allEfuseEntities);
        }
        return allEfuseEntities;
    }

    private static List<ABaseUIComponentSetting> getAllUIComponents(List<EfuseEntity> allEfuseEntities) {
        ArrayList<ABaseUIComponentSetting> allUIComponents = new ArrayList<ABaseUIComponentSetting>();
        for (EfuseEntity efuseEntity : allEfuseEntities) {
            allUIComponents.add(efuseEntity.getUIComponentSetting());
        }
        return allUIComponents;
    }

    private static void addToListAllScalarSettingFromStruct(EfuseStructSetting structSetting, List<EfuseEntity> list) {
        McuFactory.initCurrentValuesForAllScalarComponents(structSetting);
        list.addAll(McuFactory.getEfuseEntitiesForStructSetting(structSetting));
        for (EfuseStructSetting childStruct : structSetting.getStructSettings()) {
            McuFactory.addToListAllScalarSettingFromStruct(childStruct, list);
        }
    }

    private static List<EfuseEntity> getEfuseEntitiesForStructSetting(EfuseStructSetting structSetting) {
        ArrayList<EfuseEntity> structSettingEfuseEntities = new ArrayList<EfuseEntity>();
        for (EfuseStructSetting childStruct : structSetting.getStructSettings()) {
            EfuseEntity structEfuseEntity = new EfuseEntity(childStruct, childStruct.getParentFuseWordID(), childStruct.getFuseFieldID(), childStruct.isEccField());
            structSettingEfuseEntities.add(structEfuseEntity);
        }
        for (EfuseBoolSetting boolSetting : structSetting.getBoolSettings()) {
            EfuseEntity boolEfuseEntity = new EfuseEntity((ABaseUIComponentSetting)boolSetting, boolSetting.getParentFuseWordID(), boolSetting.getFuseFieldID(), boolSetting.isEccField());
            structSettingEfuseEntities.add(boolEfuseEntity);
        }
        for (EfuseEnumSetting enumSetting : structSetting.getEnumSettings()) {
            EfuseEntity enumEfuseEntity = new EfuseEntity((ABaseUIComponentSetting)enumSetting, enumSetting.getParentFuseWordID(), enumSetting.getFuseFieldID(), enumSetting.isEccField());
            structSettingEfuseEntities.add(enumEfuseEntity);
        }
        for (EfuseIntegerSetting integerSetting : structSetting.getIntegerSettings()) {
            EfuseEntity integerEfuseEntity = new EfuseEntity((ABaseUIComponentSetting)integerSetting, integerSetting.getParentFuseWordID(), integerSetting.getFuseFieldID(), integerSetting.isEccField());
            structSettingEfuseEntities.add(integerEfuseEntity);
        }
        for (EfuseBitsSetting bitsSetting : structSetting.getBitsSettings()) {
            EfuseEntity bitsEfuseEntity = new EfuseEntity((ABaseUIComponentSetting)bitsSetting, bitsSetting.getParentFuseWordID(), bitsSetting.getFuseFieldID(), bitsSetting.isEccField());
            structSettingEfuseEntities.add(bitsEfuseEntity);
        }
        for (ArraySetting arraySetting : structSetting.getArraySettings()) {
            EfuseEntity arrayEfuseEntity = new EfuseEntity(arraySetting, arraySetting.getParentFuseWordID(), arraySetting.getFuseFieldID(), arraySetting.isEccField());
            structSettingEfuseEntities.add(arrayEfuseEntity);
        }
        for (EfuseTextSetting textSetting : structSetting.getTextSettings()) {
            EfuseEntity textEfuseEntity = new EfuseEntity((ABaseUIComponentSetting)textSetting, textSetting.getParentFuseWordID(), textSetting.getFuseFieldID(), textSetting.isEccField());
            structSettingEfuseEntities.add(textEfuseEntity);
        }
        return structSettingEfuseEntities;
    }

    private static void initCurrentValuesForAllScalarComponents(EfuseStructSetting structSetting) {
        for (EfuseBoolSetting boolSetting : structSetting.getBoolSettings()) {
            boolSetting.setCurrentValue(boolSetting.getInitValue());
        }
        for (EfuseEnumSetting enumSetting : structSetting.getEnumSettings()) {
            enumSetting.setCurrentValue(enumSetting.getInitValue());
        }
        for (EfuseIntegerSetting integerSetting : structSetting.getIntegerSettings()) {
            integerSetting.setCurrentValue(integerSetting.getInitValue());
        }
    }
}

