/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.load.variable;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.variable.Variable;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.variable.VariableScopes;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VariablesHolder {
    public static final String GLOBAL_VARIABLES_HOLDER_ELEMENT = "sdks";
    public static final String SDK_LOACAL_VARIABLES_HOLDER_ELEMENT = "sdk";
    public static final String VARIABLES_ELEMENT = "variables";
    private VariableScopes scope;
    private Map<String, Variable> variables = new LinkedHashMap<String, Variable>();

    public VariablesHolder() {
    }

    public VariablesHolder(Element element) {
        this.initialize(element);
    }

    public Map<String, Variable> getVariables() {
        return this.variables;
    }

    public void addVariable(Variable variable) {
        this.variables.put(variable.getName(), variable);
    }

    public boolean isLocal() {
        return this.scope.isSdkLocal();
    }

    public boolean isGlobal() {
        return this.scope.isGlobal();
    }

    public boolean containsVariable(Variable variable) {
        return Objects.nonNull(variable) && this.variables.containsKey(variable.getName());
    }

    public boolean isEmpty() {
        return this.variables.isEmpty();
    }

    public String getVariableValue(String variableName) {
        Variable variable;
        if (this.variables != null && (variable = this.variables.get(variableName)) != null) {
            return variable.getValue();
        }
        return "";
    }

    public void convertToXml(Document document, Element parentElement) {
        if (!this.variables.isEmpty()) {
            Element variablesElement = document.createElement(VARIABLES_ELEMENT);
            this.variables.entrySet().forEach(e -> ((Variable)e.getValue()).convertToXml(document, variablesElement));
            parentElement.appendChild(variablesElement);
        }
    }

    public static VariablesHolder emptyHolder() {
        return new VariablesHolder();
    }

    private void initialize(Element element) {
        switch (element.getNodeName()) {
            case "sdks": {
                this.scope = VariableScopes.GLOBAL;
                break;
            }
            case "sdk": {
                this.scope = VariableScopes.SDK_LOCAL;
                break;
            }
            default: {
                this.scope = VariableScopes.UNDEFINED;
            }
        }
        if (!this.scope.isUndefined()) {
            NodeList variablesNodes = element.getElementsByTagName(VARIABLES_ELEMENT);
            int i = 0;
            while (i < variablesNodes.getLength()) {
                if (element.equals(variablesNodes.item(i).getParentNode())) {
                    Element variablesElement = (Element)variablesNodes.item(i);
                    NodeList variableNodes = variablesElement.getElementsByTagName("variable");
                    int j = 0;
                    while (j < variableNodes.getLength()) {
                        Variable variable = new Variable((Element)variableNodes.item(j), this.scope);
                        this.variables.put(variable.getName(), variable);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }
}

