/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.condition;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.nxp.s32ds.cle.cdt.project.configuration.core.ProjectConfigurationUtils;
import com.nxp.s32ds.cle.cdt.sdk.condition.ConditionCheck;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConditionCheckMulticoreProject
implements ConditionCheck {
    public static final String CONDITION_CHECK_MULTICORE_PROJECT_ATTRIBUTE = "multicoreProject";
    private boolean isMulticoreProject;

    ConditionCheckMulticoreProject(Element conditionCheckElement) {
        this.isMulticoreProject = Boolean.parseBoolean(conditionCheckElement.getAttribute(CONDITION_CHECK_MULTICORE_PROJECT_ATTRIBUTE));
    }

    public boolean check(Object checkCondition) {
        if (checkCondition instanceof IConfiguration) {
            IConfiguration configuration = (IConfiguration)checkCondition;
            boolean isBootableProject = new ProjectContextSettings(configuration.getOwner().getProject()).isBootableCore();
            boolean isMultiCore = false;
            if (!isBootableProject) {
                isMultiCore = true;
            } else {
                boolean bl = isMultiCore = !ProjectConfigurationUtils.getMultiCoreProjects((IConfiguration)configuration).isEmpty();
            }
            return this.isMulticoreProject ? isMultiCore : !isMultiCore;
        }
        return false;
    }

    public void convertToXml(Document document, Element conditionElement) {
        Element checkElement = document.createElement("check");
        checkElement.setAttribute(CONDITION_CHECK_MULTICORE_PROJECT_ATTRIBUTE, String.join((CharSequence)",", String.valueOf(this.isMulticoreProject)));
        conditionElement.appendChild(checkElement);
    }
}

