/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.validators;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SdkManifestModuleValidator
implements IValidator<Element> {
    private String sdkId;

    public SdkManifestModuleValidator(String sdkId) {
        this.sdkId = sdkId;
    }

    public IStatus validate(Element modulesElement) {
        Map<String, List<String>> modulesProperties = this.getModulesProperties(modulesElement);
        List<String> refferSdkIds = new LinkedList<String>();
        List<String> moduleIds = new ArrayList<String>();
        MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, null, null);
        for (Map.Entry<String, List<String>> entry : modulesProperties.entrySet()) {
            if (entry.getKey().equals("name")) {
                this.validateModuleAttributesNotEmpty(entry.getValue(), Messages.SdkModuleValidator_module_name_empty, result);
                continue;
            }
            if (entry.getKey().equals("id")) {
                moduleIds = entry.getValue();
                this.validateModuleAttributesNotEmpty(moduleIds, Messages.SdkModuleValidator_module_id_empty, result);
                continue;
            }
            if (!entry.getKey().equals("sdkId")) continue;
            refferSdkIds = entry.getValue();
            this.validateModuleAttributesNotEmpty(refferSdkIds, Messages.SdkModuleValidator_module_sdk_id_empty, result);
        }
        if (result.isOK()) {
            this.validateSdkIdAttribute(refferSdkIds, moduleIds, result);
        }
        return result;
    }

    private void validateModuleAttributesNotEmpty(List<String> moduleProperties, String errorMessage, MultiStatus status) {
        moduleProperties.stream().filter(moduleProperty -> !this.validateAttributeNotEmpty((String)moduleProperty).isOK()).forEach(k -> status.add(ValidationStatus.error((String)errorMessage)));
    }

    private void validateSdkIdAttribute(List<String> refferSdkIds, List<String> moduleIds, MultiStatus result) {
        int i = 0;
        while (i < refferSdkIds.size()) {
            if (refferSdkIds.get(i).equals(this.sdkId)) {
                result.add(ValidationStatus.error((String)NLS.bind((String)Messages.SdkModuleValidator_module_refers_to_holder_sdk, (Object)moduleIds.get(i), (Object)this.sdkId)));
            }
            if (SdkDescriptors.getSdkDescriptor((String)refferSdkIds.get(i)) == null) {
                result.add(ValidationStatus.error((String)NLS.bind((String)Messages.SdkModuleValidator_module_sdk_id_not_exist, (Object)moduleIds.get(i), (Object)refferSdkIds.get(i))));
            }
            ++i;
        }
    }

    private Map<String, List<String>> getModulesProperties(Element modulesElement) {
        HashMap<String, List<String>> modulesProperties = new HashMap<String, List<String>>();
        NodeList modulesNodeList = modulesElement.getElementsByTagName("module");
        int i = 0;
        while (i < modulesNodeList.getLength()) {
            Element moduleElement = (Element)modulesNodeList.item(i);
            modulesProperties.computeIfAbsent("name", k -> new ArrayList()).add(moduleElement.getAttribute("name"));
            modulesProperties.computeIfAbsent("id", k -> new ArrayList()).add(moduleElement.getAttribute("id"));
            modulesProperties.computeIfAbsent("sdkId", k -> new ArrayList()).add(moduleElement.getAttribute("sdkId"));
            ++i;
        }
        return modulesProperties;
    }

    private IStatus validateAttributeNotEmpty(String attributeValue) {
        if (attributeValue == null || attributeValue.isEmpty()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }
}

