/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.validators;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import java.util.Objects;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;

public class SdkEnvironmentNameValidator
implements IValidator<String> {
    private static final String ENVIRONMENT_NAME_PATTERN = "^[a-zA-Z0-9_.]*$";
    private static final int ENVIRONMENT_NAME_MAX_LENGTH = 250;

    public IStatus validate(String environmentName) {
        MultiStatus validationStatuses = SdkCoreActivator.getInstance().createMultiStatus();
        if (Objects.toString(environmentName, "").isEmpty()) {
            validationStatuses.add(ValidationStatus.error((String)Messages.SdkEnvironmentValidator_error_name_is_empty));
        } else {
            if (environmentName.length() > 250) {
                validationStatuses.add(ValidationStatus.error((String)NLS.bind((String)Messages.SdkEnvironmentValidator_error_name_length, (Object)250)));
            }
            if (!Character.isLetter(environmentName.charAt(0))) {
                validationStatuses.add(ValidationStatus.error((String)Messages.SdkEnvironmentValidator_error_name_start_symbol));
            }
            if (!environmentName.matches(ENVIRONMENT_NAME_PATTERN)) {
                validationStatuses.add(ValidationStatus.error((String)Messages.SdkEnvironmentValidator_error_name_characters));
            }
        }
        return validationStatuses;
    }
}

