/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.resource;

import com.nxp.s32ds.cle.cdt.sdk.core.filtering.ProjectCompatibleSdksFilter;
import com.nxp.s32ds.cle.cdt.sdk.core.module.SdkModulesHelper;
import com.nxp.s32ds.cle.cdt.sdk.core.resource.ResourceApplicabilityChecker;
import com.nxp.s32ds.cle.cdt.sdk.core.resource.ResourceAvailabilityChecker;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilter;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkResourcesFilter;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.ide.sdk.core.resource.SdkProjectResourcesUtils;
import com.nxp.s32ds.cle.ide.sdk.core.resource.processors.OpenSdkResourceProcessor;
import com.nxp.s32ds.cle.ide.sdk.core.resource.processors.RemoveSdkResourceProcessor;
import com.nxp.s32ds.cle.ide.sdk.core.resource.processors.SdkResourceProcessor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkCore;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.module.ModuleSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.resource.ResourceSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.toolchain.ToolChainSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.environment.EnvironmentSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.module.ModuleSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.BinaryResourceSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkGroup;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkKind;
import com.nxp.s32ds.cle.runtime.sdk.registry.toolchain.ToolChainSdkDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class ResourcesHandler {
    private ResourcesHandler() {
    }

    public static Collection<String> getResourcePaths(SdkDescriptor sdkDescriptor, SdkFilter filter, IConfiguration configuration, ResourceSdkGroup resourceType, String langId) {
        try {
            switch (resourceType) {
                case BINARY_RESOURCES: 
                case HEADER_RESOURCES: {
                    return ResourcesHandler.getResourcePathStrings(sdkDescriptor, "", filter, configuration, resourceType, langId, true).keySet();
                }
                case INCLUDE_FILE_RESOURCES: 
                case LINKER_RESOURCES: {
                    return ResourcesHandler.getResourcePathStrings(sdkDescriptor, "", filter, configuration, resourceType, langId, false).keySet();
                }
            }
            return Collections.emptyList();
        }
        catch (CoreException coreException) {
            SdkCoreActivator.getInstance().logError(NLS.bind((String)"Unable to resolve resource path string for SDK {0}", (Object)sdkDescriptor.getId()));
            return Collections.emptyList();
        }
    }

    private static Map<String, Boolean> getResourcePathStrings(SdkDescriptor sdk, String holderSdkTargetFolder, SdkFilter filter, IConfiguration configuration, ResourceSdkGroup type, String langId, boolean isFolderPath) throws CoreException {
        LinkedHashMap<String, Boolean> result = new LinkedHashMap<String, Boolean>();
        String sdkId = sdk.getId();
        IProject project = configuration.getOwner().getProject();
        String sdkTargetFolderName = SdkProjectResourcesUtils.getSdkTargetFolderName((SdkDescriptor)sdk, (IProject)project);
        List<SdkDescriptor> refModuleSdks = SdkModulesHelper.getRefModulesSdksDescriptors(sdkId, filter);
        if (!refModuleSdks.isEmpty()) {
            for (SdkDescriptor refModuleSdk : refModuleSdks) {
                result.putAll(ResourcesHandler.getResourcePathStrings(refModuleSdk, sdkTargetFolderName, filter, configuration, type, langId, isFolderPath));
            }
            return result;
        }
        List<ResourceSdkDescriptor> resources = ResourcesHandler.getResourcesPathsList(sdkId, filter, configuration, type, langId);
        Map<EnvironmentSdkDescriptor, Set<ResourceSdkDescriptor>> resourcesMap = SdkModulesHelper.getResourcesGrouppedByEnvironment(sdkId, resources);
        for (Map.Entry<EnvironmentSdkDescriptor, Set<ResourceSdkDescriptor>> e : resourcesMap.entrySet()) {
            EnvironmentSdkDescriptor environment = e.getKey();
            for (ResourceSdkDescriptor resource : e.getValue()) {
                IPath relPath = ResourcesHandler.getResourceRelativePath(sdk, resource, holderSdkTargetFolder, isFolderPath, project, sdkTargetFolderName);
                String pathPrefix = !resource.isCopy() ? environment.getName() : "ProjDirPath";
                String pathString = SdkProjectResourcesUtils.generateResourcePathString((IPath)relPath, (String)pathPrefix).replace('\\', '/');
                result.put(pathString, ResourceSdkGroup.BINARY_RESOURCES == type && ((BinaryResourceSdkDescriptor)resource).hasPrefix());
            }
        }
        return result;
    }

    private static IPath getResourceRelativePath(SdkDescriptor sdk, ResourceSdkDescriptor resource, String holderSdkTargetFolder, boolean isPathToFolder, IProject project, String sdkTargetFolderName) {
        IPath sdkBasePath = EnvironmentSdkCore.getResolvedSdkPath((String)sdk.getId());
        IPath resourcePath = Path.fromOSString((String)resource.getPath());
        IPath parentPath = resourcePath.toFile().isDirectory() ? resourcePath : (isPathToFolder ? resourcePath.removeLastSegments(1) : resourcePath);
        IPath relativePath = parentPath.makeRelativeTo(sdkBasePath);
        if (resource.isCopy()) {
            String copyToProjectPath = resource.getCopyToProjectPath();
            if (Objects.toString(copyToProjectPath, "").isEmpty()) {
                StringBuilder sb = new StringBuilder();
                if (!holderSdkTargetFolder.isEmpty()) {
                    sb.append(holderSdkTargetFolder);
                    sb.append('/');
                }
                sb.append(SdkProjectResourcesUtils.getSdkTargetFolderName((SdkDescriptor)sdk, (IProject)project));
                sb.append('/');
                sb.append(relativePath);
                relativePath = Path.fromOSString((String)sb.toString());
            } else {
                relativePath = isPathToFolder ? Path.fromOSString((String)copyToProjectPath) : Path.fromOSString((String)(String.valueOf(copyToProjectPath) + '/' + relativePath.lastSegment()));
            }
        }
        return relativePath;
    }

    public static Map<String, Set<ResourceSdkDescriptor>> getResourcesPaths(String sdkId, SdkFilter filter, IConfiguration configuration, ResourceSdkGroup resourceType, String langId) {
        Map<String, Set<ResourceSdkDescriptor>> result = ResourcesHandler.getFileResourcesPathsList(sdkId, filter, configuration, resourceType, langId);
        List<SdkDescriptor> refSdksDescriptors = SdkModulesHelper.getRefModulesSdksDescriptors(sdkId, filter);
        refSdksDescriptors.forEach(refSdkDescriptor -> {
            String refSdkId = refSdkDescriptor.getId();
            result.putAll(ResourcesHandler.getFileResourcesPathsList(refSdkId, filter, configuration, resourceType, langId));
        });
        return result;
    }

    public static List<IResource> getTargetResources(IProject project, SdkDescriptor sdkDescriptor, IConfiguration configuration, SdkResourcesFilter resourcesFilter) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        result.addAll(ResourcesHandler.collectTargetResources(project, sdkDescriptor, null, configuration, resourcesFilter, ResourceSdkGroup.HEADER_RESOURCES));
        result.addAll(ResourcesHandler.collectTargetResources(project, sdkDescriptor, null, configuration, resourcesFilter, ResourceSdkGroup.LINKER_RESOURCES));
        result.addAll(ResourcesHandler.collectTargetResources(project, sdkDescriptor, null, configuration, resourcesFilter, ResourceSdkGroup.UNSPECIFIED_RESOURCES));
        result.addAll(ResourcesHandler.collectTargetResources(project, sdkDescriptor, null, configuration, resourcesFilter, ResourceSdkGroup.SOURCE_RESOURCES));
        return result;
    }

    private static List<ResourceSdkDescriptor> getResourcesPathsList(String sdkId, SdkFilter filter, IConfiguration configuration, ResourceSdkGroup resourceType, String langId) {
        ArrayList<ResourceSdkDescriptor> result = new ArrayList<ResourceSdkDescriptor>();
        String toolChainId = configuration.getToolChain().getBaseId();
        ResourcesHandler.getToolChainResources(sdkId, toolChainId, resourceType).stream().filter(resource -> ResourcesHandler.isResourceAccepted(resource, resourceType, configuration, langId)).forEach(result::add);
        List<SdkDescriptor> refSdksDescriptors = SdkModulesHelper.getRefModulesSdksDescriptors(sdkId, filter);
        refSdksDescriptors.forEach(refSdkDescriptor -> {
            String refSdkId = refSdkDescriptor.getId();
            result.addAll(ResourcesHandler.getResourcesPathsList(refSdkId, filter, configuration, resourceType, langId));
        });
        return result;
    }

    private static Map<String, Set<ResourceSdkDescriptor>> getFileResourcesPathsList(String sdkId, SdkFilter filter, IConfiguration configuration, ResourceSdkGroup resourceType, String langId) {
        LinkedHashMap<String, Set<ResourceSdkDescriptor>> result = new LinkedHashMap<String, Set<ResourceSdkDescriptor>>();
        String toolChainId = configuration.getToolChain().getBaseId();
        List<ResourceSdkDescriptor> resources = ResourcesHandler.getToolChainResources(sdkId, toolChainId, resourceType, false);
        result.computeIfAbsent(sdkId, s -> new LinkedHashSet()).addAll(resources.stream().filter(resource -> ResourceAvailabilityChecker.isResourceAvailable(resource) && ResourceApplicabilityChecker.isApplicable(resource, configuration) && resource.getLangId().equals(langId)).collect(Collectors.toList()));
        List<SdkDescriptor> refSdksDescriptors = SdkModulesHelper.getRefModulesSdksDescriptors(sdkId, filter);
        refSdksDescriptors.forEach(refSdkDescriptor -> {
            String refSdkId = refSdkDescriptor.getId();
            result.putAll(ResourcesHandler.getFileResourcesPathsList(refSdkId, filter, configuration, resourceType, langId));
        });
        return result;
    }

    public static boolean openTargetResources(SdkDescriptor sdk, IProject project, String toolChainId) {
        Map<EnvironmentSdkDescriptor, Set<ResourceSdkDescriptor>> pathsToOpen;
        EnvironmentSdkDescriptor sdkEnvironmentDescriptor;
        String sdkId;
        block9: {
            List<ResourceSdkDescriptor> resourcesToOpen;
            block8: {
                block7: {
                    if (sdk == null) {
                        return false;
                    }
                    sdkId = sdk.getId();
                    resourcesToOpen = ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndToolChainId((String)sdkId, (String)toolChainId, (boolean)true).stream().filter(ResourceSdkDescriptor::isToOpen).collect(Collectors.toList());
                    if (!resourcesToOpen.isEmpty()) break block7;
                    return false;
                }
                sdkEnvironmentDescriptor = EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorBySdkId((String)sdkId);
                if (sdkEnvironmentDescriptor != null) break block8;
                return false;
            }
            pathsToOpen = SdkModulesHelper.getResourcesGrouppedByEnvironment(sdkId, resourcesToOpen);
            if (pathsToOpen != null && !pathsToOpen.isEmpty()) break block9;
            return false;
        }
        try {
            OpenSdkResourceProcessor openProcessor = new OpenSdkResourceProcessor();
            pathsToOpen.getOrDefault(sdkEnvironmentDescriptor, Collections.emptySet()).forEach(arg_0 -> ResourcesHandler.lambda$8(sdk, project, (SdkResourceProcessor)openProcessor, arg_0));
            ProjectCompatibleSdksFilter sdkFilter = new ProjectCompatibleSdksFilter(project);
            for (SdkDescriptor refSdk : SdkModulesHelper.getRefModulesSdksDescriptors(sdkId, (SdkFilter)sdkFilter)) {
                EnvironmentSdkDescriptor refSdkEnvironmentDescriptor = EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorBySdkId((String)refSdk.getId());
                if (refSdkEnvironmentDescriptor == null) continue;
                pathsToOpen.getOrDefault(refSdkEnvironmentDescriptor, Collections.emptySet()).forEach(arg_0 -> ResourcesHandler.lambda$9(refSdk, project, sdk, (SdkResourceProcessor)openProcessor, arg_0));
            }
            return true;
        }
        catch (CoreException ce) {
            SdkCoreActivator.getInstance().logError(NLS.bind((String)"Unable to open SDK {0} resources from project {1} due to error.", (Object)sdkId, (Object)project.getName()), ce);
            return false;
        }
    }

    public static void removeResourcesFromProject(SdkDescriptor sdk, IProject project, String toolChainId) {
        try {
            IFolder projectSdkFolder = SdkProjectResourcesUtils.getSdkTargetFolder((SdkDescriptor)sdk, (IProject)project);
            if (projectSdkFolder.isVirtual()) {
                return;
            }
            List resourcesToRemove = ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndToolChainId((String)sdk.getId(), (String)toolChainId, (boolean)true);
            if (resourcesToRemove.isEmpty()) {
                return;
            }
            EnvironmentSdkDescriptor sdkEnvironmentDescriptor = EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorBySdkId((String)sdk.getId());
            if (sdkEnvironmentDescriptor == null) {
                return;
            }
            Map<EnvironmentSdkDescriptor, Set<ResourceSdkDescriptor>> pathsToRemove = SdkModulesHelper.getResourcesGrouppedByEnvironment(sdk.getId(), resourcesToRemove);
            if (pathsToRemove == null || pathsToRemove.isEmpty()) {
                return;
            }
            RemoveSdkResourceProcessor removeProcessor = new RemoveSdkResourceProcessor();
            pathsToRemove.getOrDefault(sdkEnvironmentDescriptor, Collections.emptySet()).forEach(arg_0 -> ResourcesHandler.lambda$10(sdk, project, (SdkResourceProcessor)removeProcessor, arg_0));
            List modules = ModuleSdkDescriptors.getModuleSdkDescriptorsBySdkId((String)sdk.getId());
            for (ModuleSdkDescriptor module : modules) {
                EnvironmentSdkDescriptor refSdkEnvironmentDescriptor;
                SdkDescriptor moduleSdkDescriptor = SdkDescriptors.getSdkDescriptor((String)module.getSdkId());
                if (moduleSdkDescriptor == null || (refSdkEnvironmentDescriptor = EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorBySdkId((String)moduleSdkDescriptor.getId())) == null) continue;
                pathsToRemove.getOrDefault(refSdkEnvironmentDescriptor, Collections.emptySet()).forEach(arg_0 -> ResourcesHandler.lambda$11(moduleSdkDescriptor, project, sdk, (SdkResourceProcessor)removeProcessor, arg_0));
            }
        }
        catch (CoreException ce) {
            SdkCoreActivator.getInstance().logError(NLS.bind((String)"Unable to remove SDK {0} resources from project {1} due to error.", (Object)sdk.getId(), (Object)project.getName()), ce);
        }
    }

    private static void openResource(IResource f, SdkResourceProcessor openProcessor) {
        if (f instanceof IFile) {
            openProcessor.file((IFile)f, null);
        }
    }

    public static boolean isResourceAccepted(ResourceSdkDescriptor resource, ResourceSdkGroup resourceType, IConfiguration configuration) {
        return resourceType == ResourceSdkGroup.of((ResourceSdkKind)resource.getKind()) && ResourcesHandler.isFileResource(resource) && ResourceAvailabilityChecker.isResourceAvailable(resource) && ResourceApplicabilityChecker.isApplicable(resource, configuration);
    }

    private static boolean isResourceAccepted(ResourceSdkDescriptor resource, ResourceSdkGroup resourceType, IConfiguration configuration, String langId) {
        return resourceType == ResourceSdkGroup.of((ResourceSdkKind)resource.getKind()) && ResourceAvailabilityChecker.isResourceAvailable(resource) && ResourceApplicabilityChecker.isApplicable(resource, configuration) && resource.getLangId().equals(langId);
    }

    private static boolean isFileResource(ResourceSdkDescriptor resource) {
        return !Path.fromOSString((String)resource.getPath()).toFile().isDirectory();
    }

    private static List<ResourceSdkDescriptor> getToolChainResources(String sdkId, String configToolChainId, ResourceSdkGroup resourceType) {
        List toolChainsHolders = ToolChainSdkDescriptors.getToolChainSdkDescriptorsBySdkId((String)sdkId);
        if (toolChainsHolders == null || toolChainsHolders.isEmpty()) {
            return Collections.emptyList();
        }
        return toolChainsHolders.stream().filter(toolChainHolder -> ResourcesHandler.isToolChainCompatible(configToolChainId, toolChainHolder)).flatMap(toolChainHolder -> ResourcesHandler.getResources(sdkId, toolChainHolder.getToolChainId(), resourceType).stream()).collect(Collectors.toList());
    }

    private static List<ResourceSdkDescriptor> getToolChainResources(String sdkId, String configToolChainId, ResourceSdkGroup resourceType, boolean isFolderResources) {
        List toolChainsHolders = ToolChainSdkDescriptors.getToolChainSdkDescriptorsBySdkId((String)sdkId);
        if (toolChainsHolders == null || toolChainsHolders.isEmpty()) {
            return Collections.emptyList();
        }
        return toolChainsHolders.stream().filter(toolChainHolder -> ResourcesHandler.isToolChainCompatible(configToolChainId, toolChainHolder)).flatMap(toolChainHolder -> ResourcesHandler.getResources(sdkId, toolChainHolder.getToolChainId(), resourceType, isFolderResources).stream()).collect(Collectors.toList());
    }

    private static List<ResourceSdkDescriptor> getResources(String sdkId, String toolChainId, ResourceSdkGroup resourceGroup) {
        ArrayList<ResourceSdkDescriptor> resources = new ArrayList<ResourceSdkDescriptor>();
        for (ResourceSdkDescriptor resource : ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndToolChainId((String)sdkId, (String)toolChainId)) {
            if (resourceGroup != ResourceSdkGroup.of((ResourceSdkKind)resource.getKind())) continue;
            resources.add(resource);
        }
        return resources;
    }

    private static List<ResourceSdkDescriptor> getResources(String sdkId, String toolChainId, ResourceSdkGroup resourceGroup, boolean isFolderResources) {
        ArrayList<ResourceSdkDescriptor> resources = new ArrayList<ResourceSdkDescriptor>();
        for (ResourceSdkDescriptor resource : ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndToolChainId((String)sdkId, (String)toolChainId)) {
            boolean isFolderResource;
            if (resourceGroup != ResourceSdkGroup.of((ResourceSdkKind)resource.getKind()) || isFolderResources != (isFolderResource = Path.fromOSString((String)resource.getPath()).toFile().isDirectory())) continue;
            resources.add(resource);
        }
        return resources;
    }

    private static boolean isToolChainCompatible(String configurationToolChainId, ToolChainSdkDescriptor toolChain) {
        String holderToolChainId = toolChain.getToolChainId();
        return Objects.toString(configurationToolChainId, "").isEmpty() || Objects.toString(holderToolChainId, "").isEmpty() || configurationToolChainId.equals(holderToolChainId);
    }

    public static Map<String, Boolean> getBinaryFilesPaths(SdkDescriptor sdkDescriptor, SdkFilter filter, IConfiguration configuration, String langId) {
        try {
            return ResourcesHandler.getResourcePathStrings(sdkDescriptor, "", filter, configuration, ResourceSdkGroup.BINARY_RESOURCES, langId, false);
        }
        catch (CoreException coreException) {
            SdkCoreActivator.getInstance().logError(NLS.bind((String)"Unable to resolve resource path string for SDK {0}", (Object)sdkDescriptor.getId()));
            return Collections.emptyMap();
        }
    }

    private static List<IResource> collectTargetResources(IProject project, SdkDescriptor sdk, SdkDescriptor holderSdk, IConfiguration configuration, SdkResourcesFilter filter, ResourceSdkGroup type) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        List<SdkDescriptor> refSdkDescriptors = SdkModulesHelper.getRefModulesSdksDescriptors(sdk.getId());
        if (!refSdkDescriptors.isEmpty()) {
            for (SdkDescriptor refSdkDescriptor : refSdkDescriptors) {
                result.addAll(ResourcesHandler.collectTargetResources(project, refSdkDescriptor, sdk, configuration, filter, type));
            }
            return result;
        }
        result.addAll(ResourcesHandler.collectResources(project, sdk, holderSdk, configuration, filter, type, true));
        result.addAll(ResourcesHandler.collectResources(project, sdk, holderSdk, configuration, filter, type, false));
        return result;
    }

    private static List<IResource> collectResources(IProject project, SdkDescriptor sdk, SdkDescriptor holderSdk, IConfiguration configuration, SdkResourcesFilter filter, ResourceSdkGroup type, boolean isRootToolChain) {
        ToolChainSdkDescriptor toolChain;
        String sdkId = sdk.getId();
        String toolChainId = isRootToolChain ? ((toolChain = ToolChainSdkDescriptors.getRootToolChainSdkDescriptor((String)sdkId)) != null ? toolChain.getToolChainId() : "") : ((toolChain = configuration.getToolChain()) != null ? toolChain.getBaseId() : null);
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndToolChainId((String)sdkId, (String)toolChainId).stream().filter(resource -> ResourcesHandler.isResourceAccepted(resource, type, configuration) && filter.accept(resource)).map(resource -> SdkProjectResourcesUtils.getTargetResource((ResourceSdkDescriptor)resource, (SdkDescriptor)sdk, (IProject)project, (SdkDescriptor)holderSdk)).collect(Collectors.toList());
    }

    private static void removeResource(IResource f, SdkResourceProcessor removeProcessor) {
        if (f instanceof IFolder) {
            removeProcessor.folder((IFolder)f);
        } else if (f instanceof IFile) {
            removeProcessor.file((IFile)f, f.getFullPath());
        }
    }

    private static /* synthetic */ void lambda$8(SdkDescriptor sdkDescriptor, IProject iProject, SdkResourceProcessor sdkResourceProcessor, ResourceSdkDescriptor resourceToOpen) {
        ResourcesHandler.openResource(SdkProjectResourcesUtils.getTargetResource((ResourceSdkDescriptor)resourceToOpen, (SdkDescriptor)sdkDescriptor, (IProject)iProject), sdkResourceProcessor);
    }

    private static /* synthetic */ void lambda$9(SdkDescriptor sdkDescriptor, IProject iProject, SdkDescriptor sdkDescriptor2, SdkResourceProcessor sdkResourceProcessor, ResourceSdkDescriptor resourceToOpen) {
        ResourcesHandler.openResource(SdkProjectResourcesUtils.getTargetResource((ResourceSdkDescriptor)resourceToOpen, (SdkDescriptor)sdkDescriptor, (IProject)iProject, (SdkDescriptor)sdkDescriptor2), sdkResourceProcessor);
    }

    private static /* synthetic */ void lambda$10(SdkDescriptor sdkDescriptor, IProject iProject, SdkResourceProcessor sdkResourceProcessor, ResourceSdkDescriptor path) {
        ResourcesHandler.removeResource(SdkProjectResourcesUtils.getTargetResource((ResourceSdkDescriptor)path, (SdkDescriptor)sdkDescriptor, (IProject)iProject), sdkResourceProcessor);
    }

    private static /* synthetic */ void lambda$11(SdkDescriptor sdkDescriptor, IProject iProject, SdkDescriptor sdkDescriptor2, SdkResourceProcessor sdkResourceProcessor, ResourceSdkDescriptor resourceToRemove) {
        ResourcesHandler.removeResource(SdkProjectResourcesUtils.getTargetResource((ResourceSdkDescriptor)resourceToRemove, (SdkDescriptor)sdkDescriptor, (IProject)iProject, (SdkDescriptor)sdkDescriptor2), sdkResourceProcessor);
    }
}

