/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.load;

import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHolder;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachProcessor;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.checkers.SdkAttachConflictingProjectFilesCheckHandler;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.checkers.SdkAttachConflictingProjectFilesChecker;
import com.nxp.s32ds.cle.cdt.sdk.core.filtering.ExternalSdksFilter;
import com.nxp.s32ds.cle.cdt.sdk.core.load.LoadSdkException;
import com.nxp.s32ds.cle.cdt.sdk.core.load.parsers.SdkDescriptorParser;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkEnvironmentUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkManifestValidator;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdksValidator;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.attach.SdkAttachProjectResourcesOverrideData;
import com.nxp.s32ds.cle.ide.sdk.core.utils.SdkPreferencesHelper;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkDescriptorsRegitsrationHelper;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.ext.rcp.registry.EntityDescriptor;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandler;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Element;

public class ExternalSdkLoader {
    private static Map<String, String> sdksDescriptors = new HashMap<String, String>();

    private ExternalSdkLoader() {
    }

    public static List<SdkDescriptor> loadExternalSdks() {
        String sdkDescriptorsXml = SdkPreferencesHelper.getPersistedSdksXml((SdkType)SdkType.EXTERNAL);
        if (sdkDescriptorsXml != null && !sdkDescriptorsXml.isEmpty()) {
            return ExternalSdkLoader.loadSdkFromDescriptorsXml(sdkDescriptorsXml, null, true);
        }
        return Collections.emptyList();
    }

    public static List<SdkDescriptor> loadSdkFromDescriptorFile(String sdkDescriptorFilePath, boolean isPersistToPrefs, boolean isLoadedByUser) {
        return ExternalSdkLoader.loadSdkFromDescriptorFile(sdkDescriptorFilePath, isPersistToPrefs, isLoadedByUser, (IProgressMonitor)new NullProgressMonitor());
    }

    public static List<SdkDescriptor> loadSdkFromDescriptorFile(String sdkDescriptorFilePath, boolean isPersistToPrefs, boolean isLoadedByUser, IProgressMonitor progressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)ProgressCounter.TotalWork.getValue());
        String resolvedPathToSdkManifest = null;
        try {
            resolvedPathToSdkManifest = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(sdkDescriptorFilePath, true);
            List<SdkDescriptor> loadedSdks = ExternalSdkLoader.loadSdks(resolvedPathToSdkManifest, isPersistToPrefs, isLoadedByUser, (IProgressMonitor)subMonitor.split(ProgressCounter.LoadSDKs.getValue()));
            loadedSdks.forEach(loadedSdk -> ExternalSdkLoader.registerLoadedSdks(loadedSdk, sdkDescriptorFilePath));
            subMonitor.done();
            return loadedSdks;
        }
        catch (CoreException ce) {
            ExternalSdkLoader.handleSdkLoadingErrors(ExternalSdkLoader.reportSdkLoadingError(sdkDescriptorFilePath, (Exception)((Object)ce)), ExternalSdkLoader.getLoadSdkStatusHandler());
            return Collections.emptyList();
        }
    }

    public static List<SdkDescriptor> loadSdkFromDescriptorFile(String sdkDescriptorFilePath, boolean isPersistToPrefs) {
        return ExternalSdkLoader.loadSdkFromDescriptorFile(sdkDescriptorFilePath, isPersistToPrefs, false);
    }

    public static Map<String, String> getSdksDescriptors() {
        return sdksDescriptors;
    }

    public static void unregisterSdkDescriptor(SdkDescriptor sdk) {
        sdksDescriptors.remove(sdk.getId());
    }

    public static void updatePersistedExternalSdks() {
        try {
            IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode("com.nxp.s32ds.cle.runtime.sdk");
            String sdkDescriptorsXml = SdkManagementUtils.getSdksString(new ExternalSdksFilter(true));
            prefs.put("com.nxp.s32ds.cle.runtime.sdk.external.sdks", sdkDescriptorsXml);
            prefs.flush();
        }
        catch (BackingStoreException bse) {
            SdkCoreActivator.getInstance().logError("Unable to update SDKs persitent data", bse);
        }
    }

    public static IStatus reloadSdkFromDescriptorFile(SdkDescriptor sdkDescriptor, String sdkDescriptorFilePath, boolean isPersistToPrefs) {
        return ExternalSdkLoader.reloadSdkFromDescriptorFile(sdkDescriptor, sdkDescriptorFilePath, isPersistToPrefs, null);
    }

    public static IStatus reloadSdkFromDescriptorFile(SdkDescriptor sdkDescriptor, String sdkDescriptorFilePath, boolean isPersistToPrefs, SdkAttachConflictingProjectFilesCheckHandler handler) {
        String sdkId = sdkDescriptor.getId();
        boolean isLoadedByUser = sdkDescriptor.isLoadedByUser();
        HashMap<IProject, List<IConfiguration>> attachData = new HashMap<IProject, List<IConfiguration>>();
        List<IProject> projects = SdkAttachDataHolder.getProjectsSdkAttachedTo(sdkDescriptor);
        projects.forEach(project -> {
            List<IConfiguration> list = attachData.put((IProject)project, SdkAttachDataHolder.getProjectConfigurationsSdkAttachedTo(project, sdkDescriptor.getId()));
        });
        RcpStatusHandler errorHandler = ExternalSdkLoader.getLoadSdkStatusHandler();
        String resolvedPathToSdkManifest = null;
        MultiStatus validationStatuses = SdkCoreActivator.getInstance().createMultiStatus(0, NLS.bind((String)Messages.ExternalSdkLoader_error_sdk_reload_message_title, (Object)sdkDescriptor.getName(), (Object)sdkDescriptor.getVersion()));
        try {
            String sdkDescriptorXmlToCheck;
            resolvedPathToSdkManifest = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(sdkDescriptorFilePath, true);
            IStatus sdkDescriptorStatus = ExternalSdkLoader.validateSdkDescriptorFile(resolvedPathToSdkManifest, validationStatuses);
            if (!sdkDescriptorStatus.isOK()) {
                return sdkDescriptorStatus;
            }
            SdkDescriptorParser parser = new SdkDescriptorParser();
            String sdkDescriptorXml = ExternalSdkLoader.loadDescriptor(resolvedPathToSdkManifest);
            Map<String, Element> elements = parser.getElementsFromFragmentedManifest(sdkDescriptorXml, resolvedPathToSdkManifest);
            String string = sdkDescriptorXmlToCheck = ExternalSdkLoader.checkIfSdkIsFragmented(elements, sdkId) ? ExternalSdkLoader.convertToXML(elements.get(sdkId)) : sdkDescriptorXml;
            if (ExternalSdkLoader.isSdkIdModified(parser, sdkDescriptorXmlToCheck, sdkId)) {
                String message = NLS.bind((String)Messages.ExternalSdkLoader_error_sdk_reload_sdk_id_changed, (Object)sdkDescriptor.getName(), (Object)sdkDescriptor.getVersion());
                return ExternalSdkLoader.handleSdkLoadingErrors(validationStatuses, message, sdkDescriptorFilePath, errorHandler);
            }
            validationStatuses.addAll(new SdkManifestValidator(sdkDescriptor.getId()).validate(sdkDescriptorXmlToCheck));
            if (validationStatuses.isOK()) {
                ExternalSdkLoader.detachOldSdk(sdkDescriptor, attachData);
                List<SdkDescriptor> loadedSdks = parser.reloadSdksFromDescriptor(sdkDescriptorXml, sdkDescriptor, resolvedPathToSdkManifest, SdkType.EXTERNAL, isLoadedByUser);
                if (loadedSdks.isEmpty()) {
                    ExternalSdkLoader.handleSdkLoadingErrors((IStatus)validationStatuses, errorHandler);
                    return ExternalSdkLoader.reportSdkLoadingError(sdkDescriptorFilePath, null);
                }
                SdkDescriptor sdkToReload = loadedSdks.stream().filter(loadedSdk -> sdkDescriptor.getId().equals(loadedSdk.getId())).findFirst().orElse(null);
                if (sdkToReload == null) {
                    String message = NLS.bind((String)Messages.ExternalSdkLoader_load_sdk_error, (Object)sdkDescriptorFilePath);
                    return ExternalSdkLoader.handleSdkLoadingErrors(validationStatuses, message, sdkDescriptorFilePath, errorHandler);
                }
                ExternalSdkLoader.attachModifiedSdk(sdkToReload, attachData, handler);
                if (isPersistToPrefs) {
                    ExternalSdkLoader.updatePersistedExternalSdks();
                }
                IStatus status = SdkCoreActivator.getInstance().createStatus(0, NLS.bind((String)Messages.ExternalSdkLoader_success_sdk_reload, (Object)sdkToReload.getName(), (Object)sdkToReload.getVersion()));
                SdkCoreActivator.getInstance().log(status);
                return status;
            }
            ExternalSdkLoader.handleSdkLoadingErrors((IStatus)validationStatuses, errorHandler);
            return ExternalSdkLoader.reportSdkLoadingError(sdkDescriptorFilePath, null);
        }
        catch (IOException | CoreException e) {
            return ExternalSdkLoader.handleSdkLoadingErrors(validationStatuses, e.getMessage(), sdkDescriptorFilePath, errorHandler);
        }
    }

    private static String convertToXML(Element element) {
        String xmlString = "";
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                TransformerFactory factory = TransformerFactory.newInstance();
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                Transformer transformer = factory.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.transform(new DOMSource(element.getOwnerDocument()), new StreamResult(baos));
                xmlString = baos.toString(StandardCharsets.UTF_8.toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | TransformerException e) {
            SdkCoreActivator.getInstance().logError("Unable transform fragment element to XML.", e);
        }
        return xmlString;
    }

    private static boolean checkIfSdkIsFragmented(Map<String, Element> elements, String sdkId) {
        return elements != null && elements.entrySet().stream().anyMatch(si -> sdkId.equals(si.getKey()));
    }

    private static void detachOldSdk(SdkDescriptor oldSdkDescriptor, Map<IProject, List<IConfiguration>> attachData) {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            for (IProject project : attachData.keySet()) {
                progressService.run(false, false, progressMonitor -> {
                    IStatus iStatus = SdkAttachProcessor.detachSdkFromProject(oldSdkDescriptor, project, progressMonitor);
                });
            }
            SdkEnvironmentUtils.removeEnvironment(oldSdkDescriptor.getId());
        }
        catch (InterruptedException | InvocationTargetException exception) {
            Thread.currentThread().interrupt();
        }
    }

    private static void attachModifiedSdk(SdkDescriptor newSdkDescriptor, Map<IProject, List<IConfiguration>> attachData, SdkAttachConflictingProjectFilesCheckHandler handler) {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            SdkEnvironmentUtils.createEnvironment(newSdkDescriptor);
            for (Map.Entry<IProject, List<IConfiguration>> e : attachData.entrySet()) {
                SdkAttachProjectResourcesOverrideData overrideData;
                SdkAttachConflictingProjectFilesChecker conflictingProjectFilesChecker = new SdkAttachConflictingProjectFilesChecker(handler, e.getKey());
                if (!conflictingProjectFilesChecker.checkConflictingProjectFiles(newSdkDescriptor, overrideData = new SdkAttachProjectResourcesOverrideData()).isOK()) continue;
                progressService.run(false, false, progressMonitor -> {
                    IStatus iStatus = SdkAttachProcessor.attachSdkToProjectConfigurations(newSdkDescriptor, (Collection)e.getValue(), overrideData, true, progressMonitor);
                });
            }
        }
        catch (InterruptedException | InvocationTargetException exception) {
            Thread.currentThread().interrupt();
        }
    }

    private static List<SdkDescriptor> loadSdkFromDescriptorsXml(String sdkDescriptorXml, String descriptorPath, boolean isLoadedByUser) {
        return ExternalSdkLoader.loadSdkFromDescriptorsXml(sdkDescriptorXml, descriptorPath, isLoadedByUser, (IProgressMonitor)new NullProgressMonitor());
    }

    private static List<SdkDescriptor> loadSdkFromDescriptorsXml(String sdkDescriptorXml, String descriptorPath, boolean isLoadedByUser, IProgressMonitor progressMonitor) {
        MultiStatus validationStatuses = SdkCoreActivator.getInstance().createMultiStatus(0, Messages.SdkDescriptorParser_error_load_sdks);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)ProgressCounter.TotalWork.getValue());
        try {
            List<SdkDescriptor> loadedSdks = new SdkDescriptorParser().loadSdksFromDescriptor(sdkDescriptorXml, descriptorPath, SdkType.EXTERNAL, isLoadedByUser, (IProgressMonitor)subMonitor.split(ProgressCounter.LoadSDKsFromDescriptor.getValue()));
            if (isLoadedByUser) {
                ExternalSdkLoader.validateLoadedSdks(loadedSdks);
            }
            subMonitor.worked(ProgressCounter.ValidateStatus.getValue());
            loadedSdks.forEach(validSdk -> ExternalSdkLoader.registerSdk(validSdk, descriptorPath, isLoadedByUser));
            subMonitor.done();
            return loadedSdks;
        }
        catch (LoadSdkException sle) {
            ExternalSdkLoader.handleSdkLoadingErrors(validationStatuses, sle.getMessage(), descriptorPath, ExternalSdkLoader.getLoadSdkStatusHandler());
            subMonitor.done();
            return Collections.emptyList();
        }
    }

    private static List<SdkDescriptor> loadSdks(String resolvedPath, boolean isPersistToPrefs, boolean isLoadedByUser, IProgressMonitor progressMonitor) {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)ProgressCounter.TotalWork.getValue());
            String descriptorXml = ExternalSdkLoader.loadDescriptor(resolvedPath);
            subMonitor.worked(ProgressCounter.LoadDescriptor.getValue());
            if (descriptorXml != null) {
                List<SdkDescriptor> loadedSdks = ExternalSdkLoader.loadSdkFromDescriptorsXml(descriptorXml, resolvedPath, isLoadedByUser, (IProgressMonitor)subMonitor.split(ProgressCounter.LoadSDKs.getValue()));
                if (!loadedSdks.isEmpty() && isPersistToPrefs) {
                    ExternalSdkLoader.updatePersistedExternalSdks();
                }
                subMonitor.done();
                return loadedSdks;
            }
        }
        catch (IOException ioe) {
            ExternalSdkLoader.handleSdkLoadingErrors(ExternalSdkLoader.reportSdkLoadingError(resolvedPath, ioe), ExternalSdkLoader.getLoadSdkStatusHandler());
        }
        return Collections.emptyList();
    }

    private static String loadDescriptor(String resolvedPath) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader br = Files.newBufferedReader(Paths.get(resolvedPath, new String[0]));){
            StringBuilder sb = new StringBuilder();
            br.lines().forEach(sb::append);
            return sb.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void registerSdk(SdkDescriptor sdk, String descriptorPath, boolean isLoadedByUser) {
        if (sdk == null) {
            return;
        }
        if (descriptorPath == null) {
            descriptorPath = sdk.getDescriptorPath();
        }
        ExternalSdkLoader.registerLoadedSdks(sdk, descriptorPath);
    }

    private static void registerLoadedSdks(SdkDescriptor loadedSdk, String sdkDescriptorFilePath) {
        if (loadedSdk != null && sdkDescriptorFilePath != null && !sdkDescriptorFilePath.isEmpty()) {
            sdksDescriptors.put(loadedSdk.getId(), sdkDescriptorFilePath);
        }
    }

    private static IStatus validateSdkDescriptorFile(String sdkManifestPath, MultiStatus validationStatuses) {
        File file = new File(sdkManifestPath);
        if (!file.exists()) {
            String message = NLS.bind((String)Messages.ExternalSdkLoader_error_sdk_reload_file_not_exist, (Object)sdkManifestPath);
            return ExternalSdkLoader.handleSdkLoadingErrors(validationStatuses, message, sdkManifestPath, ExternalSdkLoader.getLoadSdkStatusHandler());
        }
        if (!file.canRead()) {
            String message = NLS.bind((String)Messages.ExternalSdkLoader_error_sdk_reload_file_not_readable, (Object)sdkManifestPath);
            return ExternalSdkLoader.handleSdkLoadingErrors(validationStatuses, message, sdkManifestPath, ExternalSdkLoader.getLoadSdkStatusHandler());
        }
        return Status.OK_STATUS;
    }

    private static IStatus handleSdkLoadingErrors(MultiStatus validationStatuses, String message, String sdkDescriptorFilePath, RcpStatusHandler errorStatusHandler) {
        validationStatuses.add(SdkCoreActivator.getInstance().createError(message));
        ExternalSdkLoader.handleSdkLoadingErrors((IStatus)validationStatuses, errorStatusHandler);
        return ExternalSdkLoader.reportSdkLoadingError(sdkDescriptorFilePath, null);
    }

    private static void handleSdkLoadingErrors(IStatus validationStatuses, RcpStatusHandler errorHandler) {
        try {
            errorHandler.handleStatus(validationStatuses, null);
        }
        catch (CoreException ce) {
            SdkCoreActivator.getInstance().logError("Unable to handle error status: " + validationStatuses, ce);
        }
    }

    private static IStatus reportSdkLoadingError(String sdkDescriptorFilePath, Exception e) {
        IStatus status = SdkCoreActivator.getInstance().createError(NLS.bind((String)Messages.ExternalSdkLoader_load_sdk_error, (Object)sdkDescriptorFilePath), e);
        SdkCoreActivator.getInstance().log(status);
        return status;
    }

    private static void validateLoadedSdks(List<SdkDescriptor> loadedSdks) {
        Map loadedSdkDescriptors = loadedSdks.stream().map(loadedSdk -> SdkDescriptors.getSdkDescriptor((String)loadedSdk.getId())).filter(Objects::nonNull).collect(Collectors.toMap(EntityDescriptor::getId, Function.identity()));
        Map<String, IStatus> invalidSdks = new SdksValidator().validate(loadedSdkDescriptors.values());
        if (!invalidSdks.isEmpty()) {
            RcpStatusHandler loadSdkStatusHandler = ExternalSdkLoader.getLoadSdkStatusHandler();
            for (Map.Entry<String, IStatus> e : invalidSdks.entrySet()) {
                ExternalSdkLoader.handleSdkLoadingErrors(e.getValue(), loadSdkStatusHandler);
                String invalidSdkId = e.getKey();
                loadedSdks.removeIf(loadedSdk -> loadedSdk.getId().equals(invalidSdkId));
                SdkDescriptorsRegitsrationHelper.unregisterSdkDescriptors((String)invalidSdkId);
            }
        }
    }

    private static RcpStatusHandler getLoadSdkStatusHandler() {
        return new RcpStatusHandler(){

            public Object handleStatus(IStatus status, Object source) throws CoreException {
                if (!status.isOK() && status.isMultiStatus() && ((MultiStatus)status).getChildren().length > 0) {
                    StatusManager.getManager().handle(status, 4);
                }
                SdkCoreActivator.getInstance().log(status);
                return source;
            }
        };
    }

    private static boolean isSdkIdModified(SdkDescriptorParser parser, String sdkDescriptorXml, String sdkId) throws LoadSdkException {
        List<String> sdkIds = parser.loadSdkIdsFromHeaders(sdkDescriptorXml);
        return !sdkIds.contains(sdkId);
    }

    private static enum ProgressCounter {
        TotalWork(100),
        LoadSDKs(75),
        LoadDescriptor(5),
        LoadSDKsFromDescriptor(50),
        ValidateStatus(20);

        private final int value;

        private ProgressCounter(int work) {
            this.value = work;
        }

        public int getValue() {
            return this.value;
        }
    }
}

