/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.filtering;

import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilteringParameters;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.hardware.HardwareSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.lang.LangSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.platform.PlatformSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.toolchain.ToolChainSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.lang.LangSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.toolchain.ToolChainSdkDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;

public class SdkFilteringOptions {
    private Map<String, Set<String>> hardwareDescriptorsIds;
    private String langId;
    private Map<String, String> platformDescriptorsIds;
    private List<String> toolChainsIds;

    public SdkFilteringOptions(String sdkId) {
        this.hardwareDescriptorsIds = HardwareSdkDescriptors.getHardwareSdkDescriptorsIds((String)sdkId);
        LangSdkDescriptor langSdkDescriptor = LangSdkDescriptors.getLangSdkDescriptorBySdkId((String)sdkId);
        this.langId = langSdkDescriptor != null ? langSdkDescriptor.getLangId() : "";
        this.platformDescriptorsIds = PlatformSdkDescriptors.getPlatformSdkDescriptorsIds((String)sdkId);
        this.toolChainsIds = ToolChainSdkDescriptors.getToolChainSdkDescriptorsBySdkId((String)sdkId).stream().map(ToolChainSdkDescriptor::getToolChainId).collect(Collectors.toList());
    }

    public SdkFilteringOptions(SdkFilteringParameters filteringParameters) {
        this.hardwareDescriptorsIds = new HashMap<String, Set<String>>();
        this.hardwareDescriptorsIds.put("com.nxp.s32ds.cle.runtime.hardware.registry.device.id", Collections.singleton(filteringParameters.getDeviceId()));
        this.hardwareDescriptorsIds.put("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id", Collections.singleton(filteringParameters.getDeviceCoreId()));
        this.hardwareDescriptorsIds.put("com.nxp.s32ds.cle.runtime.hardware.registry.core.id", Collections.singleton(filteringParameters.getCoreId()));
        this.langId = filteringParameters.getLangId();
        this.platformDescriptorsIds = Collections.singletonMap("com.nxp.s32ds.cle.runtime.sdk.registry.platform.target", filteringParameters.getTargetPlatform());
        this.toolChainsIds = filteringParameters.getToolChains().stream().map(IBuildObject::getBaseId).collect(Collectors.toList());
    }

    public SdkFilteringOptions(Map<String, Set<String>> hardwareIds, String langId, Map<String, String> platformIds, List<String> toolChainsIds) {
        this.hardwareDescriptorsIds = hardwareIds;
        this.langId = langId;
        this.platformDescriptorsIds = platformIds;
        this.toolChainsIds = toolChainsIds;
    }

    public Collection<String> getDevicesIds() {
        return this.hardwareDescriptorsIds.get("com.nxp.s32ds.cle.runtime.hardware.registry.device.id");
    }

    public Collection<String> getDeviceCoresIds() {
        return this.hardwareDescriptorsIds.get("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
    }

    public Collection<String> getCoresIds() {
        return this.hardwareDescriptorsIds.get("com.nxp.s32ds.cle.runtime.hardware.registry.core.id");
    }

    public String getLangId() {
        return this.langId;
    }

    public String getTargetPlatform() {
        return this.platformDescriptorsIds.get("com.nxp.s32ds.cle.runtime.sdk.registry.platform.target");
    }

    public String getTargetHost() {
        return this.platformDescriptorsIds.get("com.nxp.s32ds.cle.runtime.sdk.registry.platform.host");
    }

    public Collection<String> getToolChainsIds() {
        return this.toolChainsIds;
    }

    public boolean isEmpty() {
        return this.hardwareDescriptorsIds.values().stream().flatMap(Collection::stream).count() == 0L && this.langId.isEmpty() && this.platformDescriptorsIds.values().stream().map(String::trim).filter(v -> !v.isEmpty()).count() == 0L && this.toolChainsIds.isEmpty();
    }
}

