/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.attach;

import com.nxp.s32ds.cle.cdt.project.configuration.core.ProjectConfigurationUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHolder;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachStatuses;
import com.nxp.s32ds.cle.cdt.sdk.core.checkers.SdkAvailabilityChecker;
import com.nxp.s32ds.cle.cdt.sdk.core.checkers.SdkProjectCompatibilityChecker;
import com.nxp.s32ds.cle.cdt.sdk.core.module.SdkModulesHelper;
import com.nxp.s32ds.cle.ide.sdk.ProjectSdkDescriptor;
import com.nxp.s32ds.cle.ide.sdk.core.ProjectSdkDescriptors;
import com.nxp.s32ds.cle.ide.sdk.core.resource.SdkProjectResourcesUtils;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.module.ModuleSdkDescriptors;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SdkAttachStatusesResolver {
    private SdkAttachStatusesResolver() {
    }

    public static Map<String, List<IStatus>> resolveAttachStatuses(IProject project, List<SdkDescriptor> sdks) {
        HashMap<String, List<IStatus>> result = new HashMap<String, List<IStatus>>();
        List cfgs = ProjectConfigurationUtils.getProjectConfigurations((IProject)project);
        for (SdkDescriptor sdk : sdks) {
            result.put(sdk.getId(), cfgs.stream().map(configuration -> SdkAttachStatusesResolver.resolveAttachStatus(sdk, project, configuration)).collect(Collectors.toList()));
        }
        return result;
    }

    public static IStatus resolveAttachStatus(SdkDescriptor sdkDescriptor, IProject project, IConfiguration configuration) {
        String sdkId = sdkDescriptor.getId();
        IStatus result = SdkAvailabilityChecker.checkAvailability(sdkId);
        if (result.isOK()) {
            result = SdkProjectCompatibilityChecker.checkPlatform(project, sdkId);
        }
        if (result.isOK()) {
            result = SdkAttachStatusesResolver.checkProjectLocalSdkProject(sdkId, project);
        }
        if (result.isOK()) {
            result = SdkProjectCompatibilityChecker.checkPlatformHost(project, sdkId);
        }
        if (result.isOK()) {
            result = SdkProjectCompatibilityChecker.checkCore(sdkId, project);
        }
        if (result.isOK()) {
            result = SdkProjectCompatibilityChecker.checkLanguage(sdkId, project);
        }
        if (result.isOK()) {
            result = SdkProjectCompatibilityChecker.checkToolChainsCompatibility(sdkDescriptor, configuration.getToolChain());
        }
        if (result.isOK()) {
            result = SdkAttachStatusesResolver.checkTargetFolderName(SdkProjectResourcesUtils.getSdkTargetFolderName((SdkDescriptor)sdkDescriptor, (IProject)project), project);
        }
        if (result.isOK()) {
            result = SdkAttachStatusesResolver.checkModulesAttachStatuses(sdkId, project, configuration);
        }
        if (result.isOK()) {
            return SdkAttachStatusesResolver.getAttachStatus(sdkId, project, configuration);
        }
        return result;
    }

    private static IStatus getAttachStatus(String sdkId, IProject project, IConfiguration configuration) {
        return SdkAttachDataHolder.isSdkAttachedToProjectConfiguration(project.getName(), configuration.getName(), sdkId) ? SdkAttachStatuses.OK_SDK_ATTACHED : SdkAttachStatuses.OK_SDK_NOT_ATTACHED;
    }

    private static IStatus checkProjectLocalSdkProject(String sdkId, IProject project) {
        List projectLocalSdks;
        if (project != null && !(projectLocalSdks = ProjectSdkDescriptors.getProjectSdkDescriptorsBySdkId((String)sdkId)).isEmpty() && !((ProjectSdkDescriptor)projectLocalSdks.get(0)).getProjectName().equals(project.getName())) {
            return SdkAttachStatuses.ERROR_SDK_PROJECT;
        }
        return Status.OK_STATUS;
    }

    private static IStatus checkTargetFolderName(String sdkTargetFolderName, IProject project) {
        if (project != null) {
            int segmentCount;
            IPath sdkFolderPath = project.getFolder(sdkTargetFolderName).getFullPath();
            int i = segmentCount = sdkFolderPath.segmentCount();
            while (i > 1) {
                IPath path = sdkFolderPath.uptoSegment(i);
                IResource resourceVariant = ((Resource)project).findExistingResourceVariant(path);
                if (resourceVariant != null) {
                    if (1 == resourceVariant.getType()) {
                        return SdkAttachStatuses.ERROR_PROJECT_ROOT_FILE_CONFLICT;
                    }
                    if (!resourceVariant.getFullPath().equals((Object)path)) {
                        return SdkAttachStatuses.ERROR_PROJECT_FOLDER_EXIST;
                    }
                }
                --i;
            }
        }
        return Status.OK_STATUS;
    }

    private static IStatus checkModulesAttachStatuses(String sdkId, IProject project, IConfiguration config) {
        if (!ModuleSdkDescriptors.getModuleSdkDescriptorsBySdkId((String)sdkId).isEmpty()) {
            List<SdkDescriptor> refModulesSdks = SdkModulesHelper.getRefModulesSdksDescriptors(sdkId);
            if (refModulesSdks.isEmpty()) {
                return SdkAttachStatuses.ERROR_NO_MODULES_TO_ATTACH;
            }
            return refModulesSdks.stream().map(refSdk -> SdkAttachStatusesResolver.resolveAttachStatus(refSdk, project, config)).filter(IStatus::isOK).findFirst().orElse(SdkAttachStatuses.ERROR_NO_MODULES_TO_ATTACH);
        }
        return Status.OK_STATUS;
    }
}

