/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.attach;

import com.nxp.s32ds.cle.cdt.project.configuration.core.ProjectConfigurationUtils;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.status.UpdateStatus;
import com.nxp.s32ds.cle.cdt.sdk.core.action.SdkActionsHandler;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHelper;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHolder;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachHelper;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachStatuses;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachStatusesResolver;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkProjectConfigurationUpdater;
import com.nxp.s32ds.cle.cdt.sdk.core.checkers.SdkAvailabilityChecker;
import com.nxp.s32ds.cle.cdt.sdk.core.checkers.files.AbstractSdkProjectFilesChecker;
import com.nxp.s32ds.cle.cdt.sdk.core.module.SdkModulesHelper;
import com.nxp.s32ds.cle.cdt.sdk.core.resource.ResourcesHandler;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.attach.SdkAttachProjectResourcesOverrideData;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.attach.SdkAttachResourcesProcessor;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.attach.SdkAttachSourcePathsProcessor;
import com.nxp.s32ds.cle.ide.sdk.core.MissedSdkMarker;
import com.nxp.s32ds.cle.ide.sdk.core.resource.SdkProjectResourcesUtils;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class SdkAttachProcessor {
    private SdkAttachProcessor() {
    }

    public static IStatus attachSdkToProjectConfigurations(SdkDescriptor sdkDescriptor, Collection<IConfiguration> configurations, boolean notifySdkAttached, IProgressMonitor monitor) {
        return SdkAttachProcessor.attachSdkToProjectConfigurations(sdkDescriptor, configurations, new SdkAttachProjectResourcesOverrideData(), notifySdkAttached, monitor, true, false);
    }

    public static IStatus attachSdkToProjectConfigurations(SdkDescriptor sdkDescriptor, Collection<IConfiguration> configurations, SdkAttachProjectResourcesOverrideData overrideData, boolean notifySdkAttached, IProgressMonitor monitor) {
        return SdkAttachProcessor.attachSdkToProjectConfigurations(sdkDescriptor, configurations, overrideData, notifySdkAttached, monitor, true, false);
    }

    public static IStatus attachSdkToProjectConfigurations(String sdkId, Collection<IConfiguration> configurations, IProject project, boolean notifySdkAttach) {
        SdkDescriptor sdkDescriptor = SdkDescriptors.getSdkDescriptor((String)sdkId);
        IStatus status = SdkProjectResourcesUtils.cleanupProjectStructure((SdkDescriptor)sdkDescriptor, (IProject)project);
        if (!status.isOK()) {
            return status;
        }
        return SdkAttachProcessor.attachSdkToProjectConfigurations(sdkDescriptor, configurations, new SdkAttachProjectResourcesOverrideData(), notifySdkAttach, null, true, true);
    }

    public static IStatus detachSdkFromProject(SdkDescriptor sdkDescriptor, IProject project, IProgressMonitor monitor) {
        List<IConfiguration> configurations = SdkAttachDataHolder.getProjectConfigurationsSdkAttachedTo(project, sdkDescriptor.getId());
        IStatus status = SdkAttachProcessor.detachSdkFromProjectConfigurations(sdkDescriptor, configurations, monitor).isOK() ? SdkCoreActivator.getInstance().createStatus(0, Messages.SdkAttachHandler_detach_finished_ok_message) : SdkCoreActivator.getInstance().createError(Messages.SdkAttachHandler_detach_finished_error_message);
        SdkAttachHelper.notifySDKDetached(sdkDescriptor, project);
        return status;
    }

    public static void detachSdkFromAllProjects(SdkDescriptor sdkDescriptor) {
        SdkAttachDataHolder.getProjectsSdkAttachedTo(sdkDescriptor).forEach(project -> {
            IStatus iStatus = SdkAttachProcessor.detachSdkFromProjectConfigurations(sdkDescriptor, SdkAttachDataHolder.getProjectConfigurationsSdkAttachedTo(project, sdkDescriptor.getId()), null);
        });
    }

    public static IStatus detachSdkFromProjectConfigurations(SdkDescriptor sdkDescriptor, Collection<IConfiguration> configs, IProgressMonitor monitor) {
        return SdkAttachProcessor.detachSdkFromProjectConfigurations(sdkDescriptor, configs, monitor, true);
    }

    public static MultiStatus detachUnresolvedSdk(SdkDescriptor sdkDescriptor, IProject project) {
        MultiStatus mts = SdkCoreActivator.getInstance().createMultiStatus();
        String sdkId = sdkDescriptor.getId();
        List<IConfiguration> configurations = SdkAttachDataHolder.getProjectConfigurationsSdkAttachedTo(project, sdkDescriptor.getId());
        if (SdkAttachStatuses.ERROR_SDK_MISSED.equals(SdkAvailabilityChecker.checkAvailability(sdkId))) {
            for (IConfiguration configuration : configurations) {
                mts.add(SdkAttachDataHolder.detachSdkFromProjectConfiguration(sdkId, configuration.getName(), project));
                mts.addAll(SdkProjectConfigurationUpdater.cleanupOptions(configuration, sdkDescriptor));
                mts.add(SdkAttachSourcePathsProcessor.removeMissingSdkSourceEntries(project, configuration, sdkId));
            }
            SdkAttachDataHolder.removeSdkAttachPreferences(project, sdkDescriptor.getId());
        } else {
            mts.add(SdkAttachProcessor.detachSdkFromProject(sdkDescriptor, project, null));
            for (IConfiguration configuration : configurations) {
                mts.addAll(SdkProjectConfigurationUpdater.cleanupOptions(configuration, sdkDescriptor));
                SdkModulesHelper.getRefModulesSdksDescriptors(sdkId).forEach(refSdkDescriptor -> mts.addAll(SdkProjectConfigurationUpdater.cleanupOptions(configuration, refSdkDescriptor)));
            }
        }
        if (mts.isOK()) {
            MissedSdkMarker.delete((IProject)project);
            SdkAttachHelper.notifySDKDetached(sdkDescriptor, project);
        }
        return mts;
    }

    public static void reAttachSdkToProject(SdkDescriptor sdkDescriptor, IProject project) {
        if (!SdkAttachDataHolder.isSdkAttachedToProject(sdkDescriptor, project)) {
            return;
        }
        List configurations = ProjectConfigurationUtils.getProjectConfigurations((IProject)project);
        if (configurations == null || configurations.isEmpty()) {
            return;
        }
        List attachedConfigurationsNames = SdkAttachDataHolder.getProjectConfigurationsSdkAttachedTo(project, sdkDescriptor.getId()).stream().map(IBuildObject::getName).collect(Collectors.toList());
        SdkAttachProcessor.detachSdkFromProject(sdkDescriptor, project, null);
        List<IConfiguration> configurationsToAttach = configurations.stream().filter(configuration -> attachedConfigurationsNames.contains(configuration.getName())).collect(Collectors.toList());
        SdkAttachProcessor.attachSdkToProjectConfigurations(sdkDescriptor, configurationsToAttach, true, null);
    }

    public static IStatus attachSdksToProject(Collection<String> sdksIds, IProject project) {
        if (sdksIds.isEmpty()) {
            return Status.CANCEL_STATUS;
        }
        List sdksToAttach = sdksIds.stream().map(SdkDescriptors::getSdkDescriptor).filter(Objects::nonNull).collect(Collectors.toList());
        if (sdksToAttach.isEmpty()) {
            return Status.CANCEL_STATUS;
        }
        List configurations = ProjectConfigurationUtils.getProjectConfigurations((IProject)project);
        if (configurations.isEmpty()) {
            return Status.CANCEL_STATUS;
        }
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.run(false, false, progressMonitor -> SdkAttachProcessor.attachSdksToProjectConfigurations(sdksToAttach, configurations, project, true, progressMonitor));
        }
        catch (InterruptedException | InvocationTargetException exception) {
            Thread.currentThread().interrupt();
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public static IStatus attachSdksToProjectConfigurations(Map<SdkDescriptor, Collection<IConfiguration>> sdksToConfigs, IProject project, boolean notifySdkAttached, IProgressMonitor monitor, boolean isBatchMode) {
        MultiStatus resultStatus = SdkCoreActivator.getInstance().createMultiStatus();
        if (sdksToConfigs.size() == 1) {
            SdkDescriptor sdkDescriptor = sdksToConfigs.keySet().iterator().next();
            resultStatus.add(SdkAttachProcessor.attachSdkToProjectConfigurations(sdkDescriptor, sdksToConfigs.get(sdkDescriptor), new SdkAttachProjectResourcesOverrideData(), notifySdkAttached, monitor, true, isBatchMode));
        } else {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.SdkAttachHandler_task_attach_multiple, (Object)project.getName()), (int)100).setWorkRemaining(sdksToConfigs.size());
            for (Map.Entry<SdkDescriptor, Collection<IConfiguration>> e : sdksToConfigs.entrySet()) {
                resultStatus.add(SdkAttachProcessor.attachSdkToProjectConfigurations(e.getKey(), e.getValue(), new SdkAttachProjectResourcesOverrideData(), notifySdkAttached, (IProgressMonitor)subMonitor.split(1), false, isBatchMode));
            }
        }
        return resultStatus;
    }

    public static IStatus detachSdksFromProjectConfigurations(Map<SdkDescriptor, Collection<IConfiguration>> sdksToConfigs, IProject project, IProgressMonitor monitor) {
        MultiStatus resultStatus = SdkCoreActivator.getInstance().createMultiStatus();
        if (sdksToConfigs.size() == 1) {
            SdkDescriptor sdkDescriptor = sdksToConfigs.keySet().iterator().next();
            resultStatus.add(SdkAttachProcessor.detachSdkFromProjectConfigurations(sdkDescriptor, sdksToConfigs.get(sdkDescriptor), monitor, true));
        } else {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.SdkAttachHandler_task_detach_multiple, (Object)project.getName()), (int)100).setWorkRemaining(sdksToConfigs.size());
            for (Map.Entry<SdkDescriptor, Collection<IConfiguration>> e : sdksToConfigs.entrySet()) {
                resultStatus.add(SdkAttachProcessor.detachSdkFromProjectConfigurations(e.getKey(), e.getValue(), (IProgressMonitor)subMonitor.split(1), false));
            }
        }
        return resultStatus;
    }

    private static IStatus attachSdkToProjectConfigurations(SdkDescriptor sdkDescriptor, Collection<IConfiguration> configurations, SdkAttachProjectResourcesOverrideData overrideData, boolean notifySdkAttached, IProgressMonitor monitor, boolean asSeparateTask, boolean isBatchMode) {
        Map<String, Set<ResourceSdkDescriptor>> conflictingFiles;
        IStatus attachParametersValidationStatus = SdkAttachProcessor.validateAttachParameters(sdkDescriptor, configurations);
        if (!attachParametersValidationStatus.isOK()) {
            return attachParametersValidationStatus;
        }
        IProject project = configurations.iterator().next().getOwner().getProject();
        if (configurations.stream().noneMatch(cofnfiguration -> SdkAttachStatuses.OK_SDK_NOT_ATTACHED == SdkAttachStatusesResolver.resolveAttachStatus(sdkDescriptor, project, cofnfiguration))) {
            return Status.CANCEL_STATUS;
        }
        String sdkIdentifier = SdkManagementUtils.getSdkBriefInfo(sdkDescriptor);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        if (asSeparateTask) {
            subMonitor.beginTask(NLS.bind((String)Messages.SdkAttachHandler_task_attach, (Object)sdkIdentifier, (Object)project.getName()), configurations.size() + 3);
        }
        if (isBatchMode && !(conflictingFiles = AbstractSdkProjectFilesChecker.getConflictingFiles(sdkDescriptor, project)).isEmpty()) {
            overrideData.setConflictingFiles(conflictingFiles);
            overrideData.setFilesToOverride(conflictingFiles);
            overrideData.setBackupFiles(true);
        }
        subMonitor.subTask(Messages.SdkAttachHandler_task_perform_pre_attach_actions);
        MultiStatus result = SdkCoreActivator.getInstance().createMultiStatus();
        SdkAttachProcessor.performPreAttachOperations(sdkDescriptor, configurations, project, result);
        subMonitor.worked(1);
        subMonitor.subTask(Messages.SdkAttachHandler_task_attach_to_configurations);
        for (IConfiguration cfg : configurations) {
            subMonitor.subTask(NLS.bind((String)Messages.SdkAttachHandler_task_attach_to_configuration, (Object)sdkIdentifier, (Object)cfg.getName()));
            SdkAttachProcessor.performAttach(sdkDescriptor, cfg, project, overrideData, result);
            subMonitor.worked(1);
        }
        subMonitor.subTask(Messages.SdkAttachHandler_task_perform_post_attach_actions);
        SdkAttachProcessor.performPostAttachOperations(sdkDescriptor, configurations, project, result);
        subMonitor.worked(1);
        subMonitor.subTask(Messages.SdkAttachHandler_task_persist_attach_data);
        SdkAttachDataHolder.updateProjectAttachData(sdkDescriptor, project, result);
        subMonitor.worked(1);
        subMonitor.subTask(Messages.SdkAttachHandler_task_perform_final_attach_operations);
        SdkAttachProcessor.performFinalAttachOperations(sdkDescriptor, project, notifySdkAttached);
        subMonitor.worked(1);
        return Status.OK_STATUS;
    }

    private static void performPreAttachOperations(SdkDescriptor sdkDescriptor, Iterable<IConfiguration> confgurations, IProject project, MultiStatus result) {
        result.addAll(SdkActionsHandler.INSTANCE.executeAttachActions(sdkDescriptor.getId(), project, confgurations, true));
    }

    private static void performAttach(SdkDescriptor sdkDescriptor, IConfiguration configuration, IProject project, SdkAttachProjectResourcesOverrideData overrideData, MultiStatus result) {
        if (SdkAttachStatuses.OK_SDK_NOT_ATTACHED == SdkAttachStatusesResolver.resolveAttachStatus(sdkDescriptor, project, configuration)) {
            SdkAttachProcessor.attachSdkToProjectConfiguration(sdkDescriptor, configuration);
            SdkAttachProcessor.addOptions(sdkDescriptor, configuration, result);
            if (new SdkAttachResourcesProcessor(sdkDescriptor, configuration, overrideData).process().isOK()) {
                SdkAttachSourcePathsProcessor.updateProjectSourceEntries(project, sdkDescriptor, configuration, result);
            }
            overrideData.setBackupFiles(false);
        }
    }

    private static void attachSdkToProjectConfiguration(SdkDescriptor sdkDescriptor, IConfiguration configuration) {
        if (sdkDescriptor == null || configuration == null) {
            return;
        }
        IProject project = configuration.getOwner().getProject();
        String configurationName = configuration.getName();
        SdkAttachDataHolder.attachSdkToProjectConfiguration(sdkDescriptor.getId(), configurationName, project);
        SdkModulesHelper.getRefModulesSdksDescriptors(sdkDescriptor.getId()).stream().filter(refSdk -> SdkAttachStatusesResolver.resolveAttachStatus(refSdk, project, configuration).isOK()).forEach(refSdk -> SdkAttachDataHolder.attachSdkToProjectConfiguration(refSdk.getId(), configurationName, project));
    }

    private static void attachSdksToProjectConfigurations(Collection<SdkDescriptor> sdksList, List<IConfiguration> configs, IProject project, boolean notifySdkAttach, IProgressMonitor progressMonitor) {
        LinkedHashMap<SdkDescriptor, Collection<IConfiguration>> sdksToConfigurations = new LinkedHashMap<SdkDescriptor, Collection<IConfiguration>>();
        for (SdkDescriptor sdkToAttach : sdksList) {
            sdksToConfigurations.put(sdkToAttach, configs.stream().filter(c -> SdkAttachStatusesResolver.resolveAttachStatus(sdkToAttach, project, c).isOK()).collect(Collectors.toList()));
        }
        SdkAttachProcessor.attachSdksToProjectConfigurations(sdksToConfigurations, project, notifySdkAttach, progressMonitor, true);
    }

    private static void addOptions(SdkDescriptor sdkDescriptor, IConfiguration config, MultiStatus result) {
        result.addAll(SdkProjectConfigurationUpdater.updateOptions(config, sdkDescriptor, false));
    }

    private static void performPostAttachOperations(SdkDescriptor sdkDescriptor, Iterable<IConfiguration> cfgs, IProject project, MultiStatus result) {
        result.addAll(SdkActionsHandler.INSTANCE.executeAttachActions(sdkDescriptor.getId(), project, cfgs, false));
    }

    private static void performFinalAttachOperations(SdkDescriptor sdkDescriptor, IProject project, boolean notifySdkAttached) {
        SdkAttachProcessor.reindexProject(project);
        if (notifySdkAttached) {
            SdkAttachHelper.notifySDKAttached(sdkDescriptor, project);
        }
        SdkAttachHelper.collectAttachedSdkData(sdkDescriptor, project);
        Display.getDefault().asyncExec(() -> {
            boolean bl = SdkManagementUtils.openResources(sdkDescriptor, project);
        });
    }

    private static void reindexProject(IProject project) {
        ICProject cProject = CoreModel.getDefault().getCModel().getCProject(project.getName());
        CCorePlugin.getIndexManager().reindex(cProject);
    }

    private static IStatus detachSdkFromProjectConfigurations(SdkDescriptor sdkDescriptor, Collection<IConfiguration> configs, IProgressMonitor monitor, boolean asSeparateTask) {
        IStatus detachParametersValidationStatus;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!(detachParametersValidationStatus = SdkAttachProcessor.validateAttachParameters(sdkDescriptor, configs)).isOK()) {
            return detachParametersValidationStatus;
        }
        IProject project = configs.iterator().next().getOwner().getProject();
        String sdkIdentifier = NLS.bind((String)"{0} v {1}", (Object)sdkDescriptor.getName(), (Object)sdkDescriptor.getVersion());
        if (asSeparateTask) {
            monitor.beginTask(NLS.bind((String)Messages.SdkAttachHandler_task_detach, (Object)sdkIdentifier, (Object)project.getName()), configs.size() + 5);
        }
        monitor.subTask(Messages.SdkAttachHandler_task_check_detach_preconditions);
        List<SdkDescriptor> sdksAttachedToProject = SdkAttachDataHelper.getSdksAttachedToProject(project, false);
        if (sdksAttachedToProject.stream().noneMatch(attachedSdk -> sdkDescriptor.getId().equals(attachedSdk.getId()))) {
            monitor.done();
            return Status.CANCEL_STATUS;
        }
        monitor.worked(1);
        monitor.subTask(Messages.SdkAttachHandler_task_detach_from_configurations);
        List<IConfiguration> configsSdkAttachedTo = SdkAttachDataHolder.getProjectConfigurationsSdkAttachedTo(project, sdkDescriptor.getId());
        int cnt = 0;
        MultiStatus result = SdkCoreActivator.getInstance().createMultiStatus();
        for (IConfiguration config : configs) {
            monitor.subTask(Messages.SdkAttachHandler_task_perform_pre_detach_actions);
            SdkActionsHandler.INSTANCE.executeDetachActions(sdkDescriptor.getId(), project, config, true);
            monitor.worked(1);
            monitor.subTask(NLS.bind((String)Messages.SdkAttachHandler_task_detach_from_configuration, (Object)sdkIdentifier, (Object)config.getName()));
            SdkAttachProcessor.removeResources(sdkDescriptor, config);
            SdkAttachProcessor.restoreOptions(sdkDescriptor, config, result);
            SdkAttachSourcePathsProcessor.removeSdkSourceEntries(sdkDescriptor, config);
            monitor.subTask(Messages.SdkAttachHandler_task_perform_post_detach_actions);
            SdkActionsHandler.INSTANCE.executeDetachActions(sdkDescriptor.getId(), project, config, false);
            monitor.worked(1);
            monitor.subTask(Messages.SdkAttachHandler_task_persist_attach_data);
            SdkAttachDataHolder.updateProjectSdkAttachData(sdkDescriptor, project, config);
            SdkAttachProcessor.detachSdkFromProjectConfiguration(sdkDescriptor, config);
            configsSdkAttachedTo.removeIf(conf -> conf.getName().equals(config.getName()));
            ++cnt;
            monitor.worked(1);
        }
        monitor.subTask(Messages.SdkAttachHandler_task_perform_final_detach_operations);
        if (cnt > 0 && configsSdkAttachedTo.isEmpty()) {
            SdkAttachSourcePathsProcessor.removeSdkSourceEntries(project, sdkDescriptor);
            SdkProjectResourcesUtils.removeSdkFolderFromProject((SdkDescriptor)sdkDescriptor, (IProject)project);
            SdkAttachDataHolder.removeSdkAttachPreferences(project, sdkDescriptor.getId());
            SdkAttachHelper.notifySDKDetached(sdkDescriptor, project);
        }
        monitor.worked(1);
        monitor.done();
        return Status.OK_STATUS;
    }

    private static void detachSdkFromProjectConfiguration(SdkDescriptor sdkDescriptor, IConfiguration configuration) {
        if (sdkDescriptor == null || configuration == null) {
            return;
        }
        IProject project = configuration.getOwner().getProject();
        String configurationName = configuration.getName();
        SdkAttachDataHolder.detachSdkFromProjectConfiguration(sdkDescriptor.getId(), configurationName, project);
        SdkModulesHelper.getRefModulesSdksDescriptors(sdkDescriptor.getId()).forEach(refSdk -> {
            IStatus iStatus = SdkAttachDataHolder.detachSdkFromProjectConfiguration(refSdk.getId(), configurationName, project);
        });
    }

    private static void removeResources(SdkDescriptor sdkDescriptor, IConfiguration configuration) {
        IProject project = configuration.getOwner().getProject();
        String toolChainId = configuration.getToolChain().getBaseId();
        ResourcesHandler.removeResourcesFromProject(sdkDescriptor, project, toolChainId);
    }

    private static void restoreOptions(SdkDescriptor sdkDescriptor, IConfiguration configuration, MultiStatus result) {
        Set<UpdateStatus> updateStatuses = SdkAttachDataHelper.getAttachUpdateStatuses(sdkDescriptor.getId(), configuration);
        result.addAll(SdkProjectConfigurationUpdater.restoreOptions(configuration, sdkDescriptor, updateStatuses));
    }

    private static IStatus validateAttachParameters(SdkDescriptor sdk, Iterable<IConfiguration> configs) {
        if (sdk == null || configs == null) {
            IStatus status = SdkCoreActivator.getInstance().createError(Messages.SdkAttachHandler_illegal_attach_params);
            SdkCoreActivator.getInstance().log(status);
            return status;
        }
        if (!configs.iterator().hasNext()) {
            IStatus status = SdkCoreActivator.getInstance().createWarning(Messages.SdkAttachHandler_no_configs_to_attach);
            SdkCoreActivator.getInstance().log(status);
            return status;
        }
        IProject project = configs.iterator().next().getOwner().getProject();
        if (project == null) {
            IStatus status = SdkCoreActivator.getInstance().createError(Messages.SdkAttachHandler_illegal_attach_params_null_project);
            SdkCoreActivator.getInstance().log(status);
            return status;
        }
        return Status.OK_STATUS;
    }
}

