/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.configuration.internal.core.updaters;

import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.ProjectConfigurationCoreActivator;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;

public class ProjectConfigurationInfo {
    public final IProject project;
    public final ICProjectDescription projectDescription;
    public final IConfiguration configuration;

    private ProjectConfigurationInfo(IProject project, ICProjectDescription projectDescription, IConfiguration configuration) {
        this.project = project;
        this.projectDescription = projectDescription;
        this.configuration = configuration;
    }

    public static ProjectConfigurationInfo create(IConfiguration configuration) throws CoreException {
        IProject project = configuration.getOwner().getProject();
        ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(project);
        ICConfigurationDescription configDescription = projectDescription.getConfigurationByName(configuration.getName());
        if (configDescription == null) {
            throw new CoreException(ProjectConfigurationCoreActivator.getInstance().createError(NLS.bind((String)Messages.cannot_find_configuration_description_for_0, (Object)configuration.getName())));
        }
        IConfiguration config = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)configDescription);
        return new ProjectConfigurationInfo(project, projectDescription, config);
    }
}

