/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.jface.viewers;

import com.nxp.s32ds.ext.rcp.jface.viewers.ContainerFilteredTree;
import com.nxp.s32ds.ext.rcp.jface.viewers.Messages;
import com.nxp.s32ds.ext.rcp.utils.epl.viewers.ContainerFilteredCheckboxTreeViewer;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ContainerFilteredTreeComposite
extends Composite {
    protected static final IStatus OK_STATUS = ContainerFilteredTreeComposite.createStatus(0, "");
    protected static final int TREE_COMPOSITE_WIDTH_HINT = 60;
    protected static final int TREE_COMPOSITE_HEIGHT_HINT = 18;
    protected final ILabelProvider labelProvider;
    protected final ITreeContentProvider contentProvider;
    protected final String title;
    protected Label label;
    protected ContainerFilteredTree filteredTree;
    protected Button selectAllButton;
    protected Button deselectAllButton;
    protected Object input;
    protected IStructuredSelection initialSelection;
    private boolean initiallyCheckAll = true;
    private String noElementsSelectedMessage = Messages.ContainerFilteredTreeComposite_no_elements_selected;
    private String emptyTreeMessage = Messages.ContainerFilteredTreeComposite_no_elements_provided;
    private String deselectAllButtonText = Messages.ContainerFilteredTreeComposite_deselect_all;
    private String selectAllButtonText = Messages.ContainerFilteredTreeComposite_select_all;
    private final ListenerList<CheckStateChangedListener> listenerList = new ListenerList();

    public ContainerFilteredTreeComposite(Composite parent, int style, String title, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        this(parent, style, title, labelProvider, contentProvider, true);
        this.createControl();
    }

    protected ContainerFilteredTreeComposite(Composite parent, int style, String title, ILabelProvider labelProvider, ITreeContentProvider contentProvider, boolean fake) {
        super(parent, style);
        this.title = title;
        this.labelProvider = labelProvider;
        this.contentProvider = contentProvider;
    }

    public void addCheckStateChangedListener(CheckStateChangedListener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removeCheckStateChangedListener(CheckStateChangedListener listener) {
        this.listenerList.remove((Object)listener);
    }

    protected void fireCheckStateChanged() {
        for (final CheckStateChangedListener listener : this.listenerList) {
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    listener.checkStateChanged();
                }
            });
        }
    }

    protected void createControl() {
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        if (this.title != null && !this.title.isEmpty()) {
            this.label = new Label((Composite)this, 0);
            this.label.setText(this.title);
        }
        this.createTreeControl(this);
        Composite composite = new Composite((Composite)this, 0);
        layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(0x1000008, 1, false, false));
        this.createSelectionButtonsControl(composite);
    }

    public void setDeselectAllButtonText(String deselectAllButtonText) {
        this.deselectAllButtonText = deselectAllButtonText;
    }

    protected String getDeselectAllButtonText() {
        return this.deselectAllButtonText;
    }

    public void setSelectAllButtonText(String selectAllButtonText) {
        this.selectAllButtonText = selectAllButtonText;
    }

    protected String getSelectAllButtonText() {
        return this.selectAllButtonText;
    }

    public boolean isInitiallyCheckAll() {
        return this.initiallyCheckAll;
    }

    public void setInitiallyCheckAll(boolean initiallyCheckAll) {
        this.initiallyCheckAll = initiallyCheckAll;
    }

    public void setNoElementsSelectedMessage(String noElementsSelectedMessage) {
        this.noElementsSelectedMessage = noElementsSelectedMessage;
    }

    public String getNoElementsSelectedMessage() {
        return this.noElementsSelectedMessage;
    }

    public void setEmptyTreeMessage(String emptyTreeMessage) {
        this.emptyTreeMessage = emptyTreeMessage;
    }

    public String getEmptyTreeMessage() {
        return this.emptyTreeMessage;
    }

    public IStructuredSelection getInitialSelection() {
        return this.initialSelection;
    }

    public void setInitialSelection(IStructuredSelection selection) {
        this.initialSelection = selection;
    }

    public Object[] getCheckedElements() {
        return this.filteredTree.getViewer().getCheckedElements();
    }

    public void setCheckedElements(Object[] elements) {
        this.filteredTree.getViewer().setCheckedElements(elements);
    }

    public void setAllChecked(boolean state) {
        this.filteredTree.getViewer().setAllChecked(state);
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.filteredTree.getViewer().addCheckStateListener(listener);
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.filteredTree.getViewer().removeCheckStateListener(listener);
    }

    protected int getTreeCompositeHeightHint() {
        return 18;
    }

    protected int getTreeCompositeWidthHint() {
        return 60;
    }

    public void setInput(Object object) {
        if (this.input == object) {
            return;
        }
        this.input = object;
        ContainerFilteredCheckboxTreeViewer viewer = this.filteredTree.getViewer();
        viewer.setInput(this.input);
        if (this.getInitialSelection() != null) {
            viewer.setCheckedElements(this.getInitialSelection().toArray());
            viewer.refresh();
        } else if (this.isInitiallyCheckAll()) {
            viewer.setAllChecked(true);
        }
        this.setEnabled(!this.isTreeEmpty(this.input));
        this.fireCheckStateChanged();
    }

    public void setEnabled(boolean enabled) {
        if (this.label != null) {
            this.label.setEnabled(enabled);
        }
        this.filteredTree.setEnabled(enabled);
        this.selectAllButton.setEnabled(enabled);
        this.deselectAllButton.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public IStatus validate() {
        if (this.isTreeEmpty(this.input)) {
            return ContainerFilteredTreeComposite.createStatus(4, this.getEmptyTreeMessage());
        }
        Object[] checkedElements = this.getCheckedElements();
        if (checkedElements == null || checkedElements.length == 0) {
            return ContainerFilteredTreeComposite.createStatus(4, this.getNoElementsSelectedMessage());
        }
        return OK_STATUS;
    }

    protected void createTreeControl(Composite parent) {
        this.filteredTree = this.doCreateTreeViewer(parent, 2048);
        ContainerFilteredCheckboxTreeViewer viewer = this.filteredTree.getViewer();
        if (this.contentProvider != null) {
            viewer.setContentProvider((IContentProvider)this.contentProvider);
        }
        if (this.labelProvider != null) {
            viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        }
        viewer.addCheckStateListener(e -> this.fireCheckStateChanged());
        GridData data = new GridData(1808);
        FontMetrics fontMetrics = this.getFontMetrics((Control)this);
        data.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)this.getTreeCompositeWidthHint());
        data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)this.getTreeCompositeHeightHint());
        this.filteredTree.setLayoutData(data);
    }

    protected ContainerFilteredTree doCreateTreeViewer(Composite parent, int style) {
        return new ContainerFilteredTree(parent, style);
    }

    protected void createSelectionButtonsControl(Composite parent) {
        GridData data = new GridData(1808);
        this.selectAllButton = new Button(parent, 8);
        this.selectAllButton.setText(this.getSelectAllButtonText());
        this.selectAllButton.addListener(13, e -> {
            this.filteredTree.getViewer().setAllChecked(true);
            this.fireCheckStateChanged();
        });
        this.selectAllButton.setLayoutData((Object)data);
        this.deselectAllButton = new Button(parent, 8);
        this.deselectAllButton.setText(this.getDeselectAllButtonText());
        this.deselectAllButton.addListener(13, e -> {
            this.filteredTree.getViewer().setAllChecked(false);
            this.fireCheckStateChanged();
        });
        this.deselectAllButton.setLayoutData((Object)data);
    }

    protected boolean isTreeEmpty(Object input) {
        Object[] elements = this.contentProvider.getElements(input);
        return elements == null || elements.length == 0;
    }

    protected FontMetrics getFontMetrics(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return fontMetrics;
    }

    protected static IStatus createStatus(int severity, String message) {
        return new Status(severity, "com.nxp.s32ds.ext.rcp.jface", message);
    }

    public static interface CheckStateChangedListener {
        public void checkStateChanged();
    }
}

