/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.jface.viewers;

import com.nxp.s32ds.ext.rcp.jface.internal.RcpJFaceActivator;
import com.nxp.s32ds.ext.rcp.utils.epl.viewers.ContainerFilteredCheckboxTreeViewer;
import java.lang.reflect.Method;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class ContainerFilteredTree
extends FilteredTree {
    private static boolean callNative = true;
    private ContainerFilteredCheckboxTreeViewer.StrucureChangedListener strucureChangedListener;
    private ContainerFilteredCheckboxTreeViewer viewer;

    public ContainerFilteredTree(Composite parent, int treeStyle) {
        this(parent, treeStyle, new PatternFilter(), true, true);
    }

    public ContainerFilteredTree(Composite parent, int treeStyle, PatternFilter filter, boolean useNewLook) {
        this(parent, treeStyle, filter, useNewLook, true);
    }

    public ContainerFilteredTree(Composite parent, int treeStyle, PatternFilter filter, boolean useNewLook, boolean useFastHashLookup) {
        super(parent, treeStyle, filter, useNewLook, useFastHashLookup);
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        this.viewer = new ContainerFilteredCheckboxTreeViewer(parent, style);
        this.strucureChangedListener = v -> this.clearCaches();
        this.viewer.addStrucureChangedListener(this.strucureChangedListener);
        return this.viewer;
    }

    public void setEnabled(boolean enabled) {
        this.filterText.setEnabled(enabled);
        this.getViewer().getTree().setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public ContainerFilteredCheckboxTreeViewer getViewer() {
        return this.viewer;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.strucureChangedListener != null) {
            this.getViewer().removeStrucureChangedListener(this.strucureChangedListener);
        }
        super.dispose();
    }

    private void clearCaches() {
        if (!callNative) {
            return;
        }
        String methodName = "clearCaches";
        PatternFilter patternFilter = this.getPatternFilter();
        Class<?> _class = patternFilter.getClass();
        try {
            Method clearCachesMethod = _class.getDeclaredMethod(methodName, new Class[0]);
            clearCachesMethod.setAccessible(true);
            clearCachesMethod.invoke((Object)patternFilter, new Object[0]);
        }
        catch (Exception e) {
            callNative = false;
            RcpJFaceActivator.getInstance().logError(NLS.bind((String)"Cannot call method ''{0}'' in {1} class", (Object)methodName, (Object)_class.getName()), e);
        }
    }
}

