/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.jface;

import com.nxp.s32ds.ext.rcp.jface.ConfirmationDialog;
import com.nxp.s32ds.ext.rcp.jface.DialogWidgetsUtil;
import com.nxp.s32ds.ext.rcp.jface.KeyValueValidator;
import com.nxp.s32ds.ext.rcp.jface.internal.Messages;
import com.nxp.s32ds.ext.rcp.jface.internal.RcpJFaceActivator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class KeyValueDialog
extends StatusDialog {
    private Text nameField;
    private Text valueField;
    private String name;
    private String value;
    private String continueMessage = Messages.KeyValueDialog_continue_anyway;
    private final ModifyListener listener;
    private KeyValueValidator<String, String> defineValidator;

    public KeyValueDialog(Shell parent, String title, KeyValueValidator<String, String> defineValidator) {
        super(parent);
        this.setTitle(title);
        this.defineValidator = defineValidator;
        this.listener = e -> this.validate();
    }

    public void setContinueMessage(String continueMessage) {
        this.continueMessage = continueMessage;
    }

    protected Control createDialogArea(Composite parent) {
        parent = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        DialogWidgetsUtil.createLabel(composite, Messages.KeyValueDialog_name, gridData);
        this.nameField = new Text(composite, 2048);
        if (this.name != null) {
            this.nameField.setText(this.name);
        }
        gridData = new GridData();
        gridData.widthHint = 600;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.nameField.setLayoutData((Object)gridData);
        this.nameField.addModifyListener(this.listener);
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        DialogWidgetsUtil.createLabel(composite, Messages.KeyValueDialog_value, gridData);
        this.valueField = new Text(composite, 2048);
        if (this.value != null) {
            this.valueField.setText(this.value);
        }
        gridData = new GridData();
        gridData.widthHint = 600;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.valueField.setLayoutData((Object)gridData);
        this.valueField.addModifyListener(this.listener);
        this.validate();
        return composite;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    private void validate() {
        IStatus validationStatus;
        this.name = this.nameField.getText().trim();
        this.value = this.valueField.getText().trim();
        if (this.name.trim().isEmpty()) {
            this.updateStatus(RcpJFaceActivator.getInstance().createError(Messages.KeyValueDialog_name_is_empty));
            return;
        }
        if (this.value.trim().isEmpty()) {
            this.updateStatus(RcpJFaceActivator.getInstance().createError(Messages.KeyValueDialog_value_is_empty));
            return;
        }
        if (this.defineValidator != null && !(validationStatus = this.defineValidator.validate(this.name, this.value)).isOK()) {
            this.updateStatus(validationStatus);
            return;
        }
        this.updateStatus(RcpJFaceActivator.OK_STATUS_EMPTY_MSSAGE);
    }

    protected void okPressed() {
        IStatus status = this.getStatus();
        if (!status.isOK() && !ConfirmationDialog.confirmContinuation(status, this.continueMessage)) {
            return;
        }
        super.okPressed();
    }
}

