/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controller.validation;

import com.nxp.swtools.common.uct.validation.IProblemSource;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controller.Messages;
import com.nxp.swtools.gtm.controller.validation.GtmProblem;
import com.nxp.swtools.gtm.controller.validation.GtmProblemsManager;
import com.nxp.swtools.gtm.model.xml.settings.GtmIntegerSetting;
import com.nxp.swtools.validation.engine.GenericProblem;
import java.beans.PropertyChangeListener;
import java.util.Objects;

public class GtmValidationHandler {
    private PropertyChangeListener valueChangeListener = evt -> {
        Objects.requireNonNull(evt);
        if ("value".equalsIgnoreCase(evt.getPropertyName())) {
            assert (evt.getSource() instanceof GtmIntegerSetting) : Messages.ValidationAssertFailed;
            this.validateValue((GtmIntegerSetting)evt.getSource());
        }
    };

    public void validateValue(GtmIntegerSetting integerSetting) {
        GtmProblem limitValueProblem;
        GtmProblem emptyValueProblem;
        GtmProblemsManager problemsManager = GtmController.getInstance().getProblemsManager();
        problemsManager.clearProblems((IProblemSource)integerSetting);
        integerSetting.setValueValid(true);
        GtmProblem invalidValueProblem = problemsManager.getInvalidFieldValueProblem(integerSetting);
        if (invalidValueProblem != null) {
            problemsManager.addProblem((GenericProblem)invalidValueProblem);
            integerSetting.setValueValid(false);
        }
        if ((emptyValueProblem = problemsManager.getEmptyValueProblem(integerSetting)) != null) {
            problemsManager.addProblem((GenericProblem)emptyValueProblem);
            integerSetting.setValueValid(false);
        }
        if ((limitValueProblem = problemsManager.getLimitValueProblem(integerSetting)) != null) {
            problemsManager.addProblem((GenericProblem)limitValueProblem);
            integerSetting.setValueValid(false);
        }
    }

    public PropertyChangeListener getValueChangeListener() {
        return this.valueChangeListener;
    }
}

