/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controller.validation;

import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.utils.UctUtils;
import com.nxp.swtools.common.uct.validation.AUctProblem;
import com.nxp.swtools.common.uct.validation.AUctProblemsManager;
import com.nxp.swtools.common.uct.validation.IProblemSource;
import com.nxp.swtools.common.uct.xml.settings.LimitValues;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controller.Messages;
import com.nxp.swtools.gtm.controller.validation.GtmProblem;
import com.nxp.swtools.gtm.model.utils.GtmExpressions;
import com.nxp.swtools.gtm.model.utils.GtmUtils;
import com.nxp.swtools.gtm.model.xml.settings.GtmIntegerSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmStructSetting;
import java.util.UUID;

public class GtmProblemsManager
extends AUctProblemsManager<GtmProblem> {
    public boolean hasGtmToolErrors() {
        for (GtmProblem problem : this.getProblemsList()) {
            if (!problem.isError()) continue;
            return true;
        }
        return false;
    }

    public @Nullable GtmProblem getInvalidFieldValueProblem(GtmIntegerSetting integerSetting) {
        String value = integerSetting.getCurrentValue();
        if (!(value.isEmpty() || NumberFormatValidator.isValidDecimal((String)value) || NumberFormatValidator.isValidHexadecimal((String)value))) {
            UUID id = UUID.randomUUID();
            String fieldValue = "GTM: " + Messages.Msg_FieldValue + " " + value;
            GtmProblem problem = new GtmProblem(2, com.nxp.swtools.common.uct.utils.Messages.HexadecimalInvalidValue, fieldValue, integerSetting.getLabel(), com.nxp.swtools.common.uct.utils.Messages.HexadecimalInvalidValue, AUctProblem.Type.INVALID_VALUE, id, (IProblemSource)integerSetting);
            return !this.hasSourceProblemOfType(problem.getProblemSource(), problem.getType()) ? problem : null;
        }
        return null;
    }

    public @Nullable GtmProblem getEmptyValueProblem(GtmIntegerSetting integerSetting) {
        String value = integerSetting.getCurrentValue();
        if (value.isEmpty()) {
            UUID id = UUID.randomUUID();
            String fieldValue = "GTM: " + Messages.EmptyFieldValue + " " + value;
            GtmProblem problem = new GtmProblem(2, Messages.EmptyFieldValue, fieldValue, integerSetting.getLabel(), Messages.EmptyFieldValue, AUctProblem.Type.EMPTY_VALUE, id, (IProblemSource)integerSetting);
            return !this.hasSourceProblemOfType(problem.getProblemSource(), problem.getType()) ? problem : null;
        }
        return null;
    }

    public @Nullable GtmProblem getLimitValueProblem(GtmIntegerSetting integerSetting) {
        String value = integerSetting.getCurrentValue();
        if (!value.isEmpty() && (NumberFormatValidator.isValidDecimal((String)value) || NumberFormatValidator.isValidHexadecimal((String)value))) {
            String[] stringArray = integerSetting.getConstraintsReferences();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                GtmStructSetting parentStruct;
                String constraintRef = stringArray[n2];
                LimitValues limitConstraint = GtmController.getInstance().getGtmXmlConfig().getConstraints().getLimitValuesById(constraintRef);
                if (limitConstraint != null && (parentStruct = GtmUtils.getParentStructSettingContainingChild((GtmStructSetting)GtmController.getInstance().getGtmXmlConfig().getLayoutComponents().getParentLayoutContent(), (ABaseUIComponentSetting)integerSetting)) != null) {
                    long minValue = GtmExpressions.getLongValueFromExpression((String)limitConstraint.getMinValue(), (GtmStructSetting)parentStruct);
                    long maxValue = GtmExpressions.getLongValueFromExpression((String)limitConstraint.getMaxValue(), (GtmStructSetting)parentStruct);
                    if (!UctUtils.isValueInRange((long)UctUtils.getLongValueFromString((String)value), (String)UtilsText.safeString((String)String.valueOf(minValue)), (String)UtilsText.safeString((String)String.valueOf(maxValue)))) {
                        UUID id = UUID.randomUUID();
                        String fieldValue = "GTM: " + Messages.Msg_FieldValue + " " + value;
                        GtmProblem problem = new GtmProblem(2, Messages.LimitValueProblem, fieldValue, integerSetting.getLabel(), Messages.LimitValueProblem, AUctProblem.Type.OUT_OF_RANGE_VALUE, id, (IProblemSource)integerSetting);
                        return !this.hasSourceProblemOfType(problem.getProblemSource(), problem.getType()) ? problem : null;
                    }
                }
                ++n2;
            }
        }
        return null;
    }
}

