/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controller.generation;

import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controller.Messages;
import com.nxp.swtools.gtm.model.mcu.GtmEmptyMcu;
import com.nxp.swtools.provider.configuration.sources.ISourceFile;
import com.nxp.swtools.provider.configuration.sources.ISourceFileGenerationStatus;
import com.nxp.swtools.provider.configuration.sources.ISourceFileProvider;
import com.nxp.swtools.provider.configuration.sources.SourceFileProviderFactory;
import com.nxp.swtools.utils.scripting.ScriptResult;
import com.nxp.swtools.utils.wizards.exportWizard.AExportWizard;
import java.util.Collection;

public class GtmSourceCodeGeneration
implements ISourceFileProvider {
    public ISourceFileGenerationStatus getGeneratedFiles(String coreId, Collection<ISourceFile> generatedFiles) {
        GtmController gtmController = GtmController.getInstance();
        if (!(gtmController.getGtmMcu() instanceof GtmEmptyMcu)) {
            return GtmSourceCodeGeneration.generateSourceFiles(generatedFiles, gtmController);
        }
        return SourceFileProviderFactory.buildGenerationStatus((ISourceFileGenerationStatus.GenerationStatus)ISourceFileGenerationStatus.GenerationStatus.WARNING, (String)Messages.Controller_McuNotSelectedMessage);
    }

    private static ISourceFileGenerationStatus generateSourceFiles(Collection<ISourceFile> generatedFiles, GtmController controller) {
        controller.requestRegenerateCode();
        ScriptResult scriptResult = controller.getGeneratedCode();
        AExportWizard.GenerationResult generationResult = AExportWizard.GenerationResult.fromScriptResult((ScriptResult)scriptResult);
        if (!generationResult.wasSuccessful) {
            return SourceFileProviderFactory.buildGenerationStatus((ISourceFileGenerationStatus.GenerationStatus)ISourceFileGenerationStatus.GenerationStatus.FATAL, (String)generationResult.failReason);
        }
        Collection sourceFiles = generationResult.getGeneratedSourceFiles();
        if (sourceFiles != null) {
            generatedFiles.addAll(sourceFiles);
        }
        return SourceFileProviderFactory.buildGenerationOKStatus();
    }
}

