/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controller;

import com.nxp.swtools.codemanager.ICodeGenerator;
import com.nxp.swtools.common.uct.controller.AUctController;
import com.nxp.swtools.common.uct.mcu.IMcu;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.BoolSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.EnumSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.IntegerSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.ItemSetting;
import com.nxp.swtools.common.uct.utils.UctUtils;
import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.gtm.controller.Messages;
import com.nxp.swtools.gtm.controller.generation.GtmSourceCodeRefreshHandler;
import com.nxp.swtools.gtm.controller.scripting.GtmScriptProfile;
import com.nxp.swtools.gtm.controller.validation.GtmProblemsManager;
import com.nxp.swtools.gtm.controller.validation.GtmValidationHandler;
import com.nxp.swtools.gtm.model.mcu.GtmEmptyMcu;
import com.nxp.swtools.gtm.model.mcu.IGtmMcu;
import com.nxp.swtools.gtm.model.mcu.McuFactory;
import com.nxp.swtools.gtm.model.utils.GtmUtils;
import com.nxp.swtools.gtm.model.xml.settings.GtmIntegerSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmStructSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmXmlConfiguration;
import com.nxp.swtools.gtml.controller.utils.StorageGtmUtils;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.IConfigChangeContext;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.ISharedConfigurationListener;
import com.nxp.swtools.provider.configuration.SharedConfigurationAdapter;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.helper.CommonConfigImpl;
import com.nxp.swtools.provider.configuration.sources.ISourceFile;
import com.nxp.swtools.provider.configuration.storage.IStorageConfigurationPreferencesRead;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.gtm.StorageGtmConfiguration;
import com.nxp.swtools.provider.configuration.storage.gtm.StorageGtmContainer;
import com.nxp.swtools.provider.configuration.storage.gtm.StorageGtmSetting;
import com.nxp.swtools.provider.configuration.storage.gtm.StorageGtmTool;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.resources.DataDirectoryUtils;
import com.nxp.swtools.utils.scripting.CodeGenerator;
import com.nxp.swtools.utils.scripting.JavaScriptHelper;
import com.nxp.swtools.utils.scripting.ScriptFileProvider;
import com.nxp.swtools.utils.scripting.ScriptResult;
import com.nxp.swtools.utils.scripting.api.IProfileProvider;
import com.nxp.swtools.utils.scripting.api.IScriptFileProvider;
import com.nxp.swtools.utils.scripting.api.IScriptProfile;
import com.nxp.swtools.utils.view.IViewRefreshManager;
import com.nxp.swtools.utils.wizards.exportWizard.AExportWizard;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.CompiledScript;
import org.eclipse.swt.widgets.Display;

public class GtmController
extends AUctController
implements ICodeGenerator {
    private static final Logger LOGGER = LogManager.getLogger(GtmController.class);
    @Nullable
    private ISharedConfigurationListener sharedConfigListener;
    private IGtmMcu gtmMcu;
    private GtmXmlConfiguration gtmXmlConfig;
    @Nullable
    private Display display = SWToolsProperties.isHeadlessOn() ? null : Display.getCurrent();
    @Nullable
    private GtmSourceCodeRefreshHandler codeRefreshManagerHandler = null;
    private GtmValidationHandler validationHandler;

    private GtmController() {
        this.gtmMcu = this.getMcuFromSharedConfig(this.getSharedConfig());
        this.setMcu((IMcu)this.gtmMcu);
        this.gtmXmlConfig = this.gtmMcu.getGtmXmlConfig();
        this.problemsManager = new GtmProblemsManager();
        this.storeTool();
        this.validationHandler = new GtmValidationHandler();
        this.reloadFromSharedConfig(this.getSharedConfig(), ConfigChangeReason.UNKNOWN);
        this.sharedConfigListener = new SharedConfigurationAdapter(){

            public void configurationReloaded(ISharedConfiguration sharedConfig, ConfigChangeReason reason) {
                GtmController.this.reloadFromSharedConfig(sharedConfig, reason);
            }

            public void commonConfigurationChanged(ISharedConfiguration sharedConfiguration) {
                IMcu currentMcu = GtmController.this.getMcu();
                if (currentMcu != null && !sharedConfiguration.getCommonConfig().getMcuIdentification().equals(currentMcu.getMcuIdentification())) {
                    this.configurationReloaded(GtmController.this.getSharedConfig(), ConfigChangeReason.UNKNOWN);
                }
            }

            public void configurationChanged(ISharedConfiguration sharedConfiguration, IConfigChangeContext changeContext) {
                CommonConfigImpl commonConfigImpl;
                ProcessorCore selectedCore;
                Object source = changeContext.getSource();
                if (source instanceof StorageGtmTool) {
                    if (((StorageGtmTool)source).isEnabled() != GtmController.this.isToolEnabled().get()) {
                        this.configurationReloaded(sharedConfiguration, ConfigChangeReason.UNKNOWN);
                    }
                } else if (source instanceof CommonConfigImpl && (selectedCore = (commonConfigImpl = (CommonConfigImpl)source).getSelectedCore()) != null) {
                    GtmController.this.handleSettingChange(4, GtmController.this.getSharedConfig(), null, null);
                }
            }
        };
        this.getSharedConfig().addListener(Objects.requireNonNull(this.sharedConfigListener));
    }

    public static GtmController getInstance() {
        try {
            GtmController controller = (GtmController)((Object)SWTFactoryProxy.INSTANCE.getSingletonInstance(GtmController.class));
            if (controller.isDisposed().get()) {
                throw new IllegalStateException("GTM Controller is disposed");
            }
            return controller;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Cannot obtain user-singleton instance of: " + GtmController.class.getSimpleName(), e);
        }
    }

    public void regenerateCode() {
        ScriptResult scriptResult;
        if (this.isToolEnabled().get() && GtmController.isMcuSupported((IMcu)this.gtmMcu) && !(scriptResult = this.getCodeScriptResult()).containsAnyError()) {
            this.setGeneratedCode(scriptResult);
        }
    }

    public void requestRegenerateCode() {
        this.regenerateCode();
    }

    public void forceCodeRegeneration() {
        this.regenerateCode();
    }

    protected IGtmMcu getMcuFromSharedConfig(ISharedConfiguration sharedConfiguration) {
        ICommonConfig commonConfig = sharedConfiguration.getCommonConfig();
        GtmEmptyMcu selectedMcu = null;
        if (!commonConfig.getMcu().isEmpty()) {
            IGtmMcu currentMcu = (IGtmMcu)this.getMcu();
            if (currentMcu != null && commonConfig.getMcuIdentification().equals(currentMcu.getMcuIdentification()) && !SWToolsProperties.isVerificationOn() && !(currentMcu instanceof GtmEmptyMcu)) {
                selectedMcu = currentMcu;
            } else {
                ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
                selectedMcu = McuFactory.create((ISupportedDerivativesForSwTools)derivatives, (ICommonConfig)commonConfig);
            }
        } else {
            selectedMcu = new GtmEmptyMcu(UtilsText.safeString((String)com.nxp.swtools.common.uct.utils.Messages.Msg_NoMcuSelected));
        }
        return selectedMcu != null ? selectedMcu : new GtmEmptyMcu(UtilsText.safeString((String)com.nxp.swtools.common.uct.utils.Messages.Msg_CorruptedMcuData));
    }

    protected void reloadFromSharedConfig(ISharedConfiguration sharedConfiguration) {
    }

    public void handleSettingChange(int eventType, @Nullable Object eventOriginator, @Nullable String actionLabel) {
    }

    protected StorageGtmTool storeTool() {
        StorageGtmTool stGtmTool = this.getSharedConfig().getTools().getGtmTool();
        if (stGtmTool == null) {
            stGtmTool = new StorageGtmTool();
            this.getSharedConfig().getTools().setGtmTool(stGtmTool);
        }
        return stGtmTool;
    }

    public void resetToProcessorDefaults() {
    }

    public IGtmMcu getGtmMcu() {
        return this.gtmMcu;
    }

    public GtmXmlConfiguration getGtmXmlConfig() {
        return this.gtmXmlConfig;
    }

    public void setGtmXmlConfig() {
        this.gtmXmlConfig = this.gtmMcu.getGtmXmlConfig();
    }

    public GtmProblemsManager getProblemsManager() {
        return (GtmProblemsManager)this.problemsManager;
    }

    protected void reloadFromSharedConfig(ISharedConfiguration sharedConfiguration, ConfigChangeReason reason) {
        if (this.getSharedConfig() != sharedConfiguration) {
            LOGGER.log(Level.SEVERE, "Unexpected change of shared configuration for GTM tool");
            throw new IllegalArgumentException("Unexpected change of shared configuration");
        }
        this.gtmMcu = this.getMcuFromSharedConfig(sharedConfiguration);
        this.setMcu((IMcu)this.gtmMcu);
        this.setGtmXmlConfig();
        this.getProblemsManager().clearAllProblems();
        StorageGtmTool stGtmTool = sharedConfiguration.getTools().getGtmTool();
        this.setToolEnabled(stGtmTool == null || stGtmTool.isEnabled());
        if (this.isToolEnabled().get()) {
            this.storeTool();
            this.loadGtmConfiguration(reason);
            this.addValidationListener(this.getGtmMcu().getGtmLayoutContent(), this.validationHandler);
        } else {
            this.gtmMcu = new GtmEmptyMcu(Messages.Msg_ToolDisabled);
            this.setMcu((IMcu)this.gtmMcu);
        }
        this.refreshCodeAndSourceView();
        this.handleSettingChange(2, this.getSharedConfig(), null, null);
    }

    public void addValidationListener(GtmStructSetting structSetting, GtmValidationHandler handler) {
        for (GtmIntegerSetting integerSetting : structSetting.getIntegerSettings()) {
            integerSetting.addPropertyChangeListener(handler.getValueChangeListener());
        }
        for (GtmStructSetting childStructSetting : structSetting.getStructSettings()) {
            this.addValidationListener(childStructSetting, handler);
        }
    }

    private void loadGtmConfiguration(ConfigChangeReason reason) {
        StorageGtmTool stGtmTool = this.getSharedConfig().getTools().getGtmTool();
        if (stGtmTool != null) {
            StorageGtmConfiguration stGtmConfiguration = stGtmTool.getGtmConfiguration();
            if (stGtmConfiguration == null || reason.equals((Object)ConfigChangeReason.CLEAR_CONFIG)) {
                stGtmConfiguration = new StorageGtmConfiguration();
                stGtmTool.setGtmConfiguration(stGtmConfiguration);
                StorageGtmUtils.initAllStorageContainers(this.gtmMcu, stGtmTool);
                GtmUtils.initAllUiComponents((GtmXmlConfiguration)this.gtmXmlConfig);
            } else {
                this.loadGtmSettingsFromContainers(stGtmConfiguration.getContainers());
            }
        }
        if (reason.equals((Object)ConfigChangeReason.UNDO_REDO)) {
            this.handleSettingChange(16, this.getSharedConfig(), null, null);
        } else {
            this.handleSettingChange(8, this.getSharedConfig(), null, null);
        }
    }

    private void loadGtmSettingsFromContainers(List<StorageGtmContainer> gtmContainers) {
        for (StorageGtmContainer gtmContainer : gtmContainers) {
            ABaseUIComponentSetting containerSetting = UctUtils.getComponentSettingById((IMcu)this.gtmMcu, (String)gtmContainer.getId());
            if (containerSetting instanceof GtmStructSetting) {
                GtmStructSetting structSeting = (GtmStructSetting)containerSetting;
                for (StorageGtmSetting stSetting : gtmContainer.getSettings()) {
                    ABaseUIComponentSetting uiSetting = GtmUtils.getChildFromStructSetting((GtmStructSetting)structSeting, (String)stSetting.getId());
                    if (uiSetting == null) continue;
                    GtmController.setUIComponentValue(uiSetting, stSetting.getValue());
                }
            }
            this.loadGtmSettingsFromContainers(gtmContainer.getChildContainers());
        }
    }

    private static void setUIComponentValue(ABaseUIComponentSetting uiSetting, String value) {
        if (uiSetting instanceof EnumSetting) {
            EnumSetting enumSetting = (EnumSetting)uiSetting;
            ItemSetting itemSetting = enumSetting.getItemByName(value);
            if (itemSetting != null) {
                enumSetting.setCurrentValue(itemSetting.getId());
                enumSetting.setCurrentSelection(itemSetting.getLabel());
            }
        } else if (uiSetting instanceof BoolSetting) {
            BoolSetting boolSetting = (BoolSetting)uiSetting;
            boolSetting.setCurrentValue(value);
        } else if (uiSetting instanceof IntegerSetting) {
            IntegerSetting integerSetting = (IntegerSetting)uiSetting;
            integerSetting.setCurrentValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSettingChange(int eventType, @Nullable Object eventOriginator, @Nullable Object inputObject, @Nullable String actionLabel) {
        ISharedConfiguration currentSharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        GtmController gtmController = this;
        synchronized (gtmController) {
            IMcu currentMcu = this.getMcu();
            if (currentMcu != null && this.getShouldUpdateConfiguration().get() && this.isToolEnabled().get() && GtmController.isMcuSupported((IMcu)currentMcu)) {
                if (eventOriginator != currentSharedConfig) {
                    StorageGtmTool stGtmTool = this.storeTool();
                    currentSharedConfig.getTools().setGtmTool(stGtmTool);
                    this.setDirty(currentSharedConfig, "GTM", stGtmTool, actionLabel, IConfigChangeContext.ConfigChangeType.TOOL_SETTING_CHANGE);
                }
                this.setSaved(false);
            }
        }
        UIJobHelper.runNowOrInJob(() -> this.fireListeners(new ToolEvent.Builder(eventType).setObject(inputObject).setOriginator(eventOriginator).build()), (String)"Refresh GTM tool", (Display)this.display);
    }

    private ScriptResult getCodeScriptResult() {
        if (GtmController.isMcuSupported((IMcu)this.gtmMcu)) {
            ISharedConfiguration sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
            String gtmCodeGenScriptPath = DataDirectoryUtils.getDataDir((IMcuIdentification)this.gtmMcu.getMcuIdentification(), (String)"gtm_scripts");
            ScriptFileProvider fileProvider = new ScriptFileProvider(new String[]{gtmCodeGenScriptPath});
            File file = fileProvider.findScriptFile("exportcodegeneration.js");
            if (file != null) {
                CompiledScript compiledScript = JavaScriptHelper.compile((File)file);
                if (compiledScript != null) {
                    final GtmScriptProfile gtmScriptProfile = new GtmScriptProfile(this.gtmMcu);
                    IProfileProvider profileProvider = new IProfileProvider(){

                        public IScriptProfile getProfile(Thread uiThread) {
                            return gtmScriptProfile;
                        }
                    };
                    gtmScriptProfile.applyDependencies();
                    return new CodeGenerator(profileProvider, (IScriptFileProvider)fileProvider, (IStorageConfigurationPreferencesRead)sharedConfig.getPreferences()).generate(compiledScript);
                }
            } else {
                LOGGER.severe(MessageFormat.format("Code generator script {0} not found at these paths: {1}", "exportcodegeneration.js", gtmCodeGenScriptPath));
            }
        }
        return new ScriptResult.Builder().appendError(UtilsText.safeString((String)Messages.CodeGenerationError)).build();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private boolean isCodeConfigurationChanged() {
        AExportWizard.GenerationResult previousGenerationResult = AExportWizard.GenerationResult.fromScriptResult((ScriptResult)this.getGeneratedCode());
        ScriptResult currentScriptResult = this.getCodeScriptResult();
        AExportWizard.GenerationResult currentGenerationResult = AExportWizard.GenerationResult.fromScriptResult((ScriptResult)currentScriptResult);
        @NonNull Collection previousSourceFiles = previousGenerationResult.getGeneratedSourceFiles();
        @NonNull Collection currentSourceFiles = currentGenerationResult.getGeneratedSourceFiles();
        if (previousSourceFiles != null && currentSourceFiles != null) {
            Iterator previousFile = previousSourceFiles.iterator();
            for (ISourceFile currentFile : currentSourceFiles) {
                if (previousFile.hasNext()) {
                    if (currentFile.getAsString().equals(((ISourceFile)previousFile.next()).getAsString())) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public @Nullable GtmSourceCodeRefreshHandler getSourceCodeRefreshManager() {
        return this.codeRefreshManagerHandler;
    }

    public void setSourceCodeRefreshManager(GtmSourceCodeRefreshHandler managerHandler) {
        this.codeRefreshManagerHandler = managerHandler;
    }

    public void removeSourceCodeRefreshManager() {
        this.codeRefreshManagerHandler = null;
    }

    public void refreshSourceView() {
        IViewRefreshManager refreshManager;
        GtmSourceCodeRefreshHandler refreshManagerHandler = this.getSourceCodeRefreshManager();
        if (refreshManagerHandler != null && (refreshManager = refreshManagerHandler.getRefreshManager()) != null) {
            refreshManager.refresh();
        }
    }

    public void refreshCodeAndSourceView() {
        if (this.isCodeConfigurationChanged()) {
            this.requestCodeGeneration();
            this.refreshSourceView();
        }
    }

    public GtmValidationHandler getValidationHandler() {
        return this.validationHandler;
    }

    public synchronized void dispose() {
        this.setDisposed(true);
        ISharedConfigurationListener listenerLoc = this.sharedConfigListener;
        if (listenerLoc != null) {
            this.getSharedConfig().removeListener(listenerLoc);
        }
    }
}

