/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data.setting;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.resourcetables.model.data.Description;
import com.nxp.swtools.resourcetables.model.data.OptionsExpr;
import com.nxp.swtools.resourcetables.model.data.setting.AMinMaxSetting;
import com.nxp.swtools.resourcetables.model.data.setting.IUIName;
import com.nxp.swtools.resourcetables.model.data.setting.ReferenceSetting;
import java.util.Collection;
import java.util.StringJoiner;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;

@Root(name="integer", strict=false)
@Order(attributes={"id", "label", "label_expr", "available", "public", "enable", "options", "min_expr", "max_expr", "type"})
public class IntegerSetting
extends AMinMaxSetting {
    private static final String RESTRICTION_OCT = "oct";
    private static final String RESTRICTION_BIN = "bin";
    private static final String RESTRICTION_DEC = "dec";
    private static final String RESTRICTION_HEX = "hex";
    @Attribute(name="type")
    private IntegerType integerType;
    private boolean hexInputAllowed = false;
    private boolean decInputAllowed = false;
    private boolean binInputAllowed = false;
    private boolean octInputAllowed = false;

    @Attribute(name="restriction", required=false)
    public void setRestrictions(String restrictionString) {
        String[] restrictions;
        String[] stringArray = restrictions = restrictionString.split(",");
        int n = restrictions.length;
        int n2 = 0;
        while (n2 < n) {
            String restriction = stringArray[n2];
            switch (restriction.trim()) {
                case "hex": {
                    this.setHexInputAllowed(true);
                    break;
                }
                case "dec": {
                    this.setDecInputAllowed(true);
                    break;
                }
                case "oct": {
                    this.setOctInputAllowed(true);
                    break;
                }
                case "bin": {
                    this.setBinInputAllowed(true);
                }
            }
            ++n2;
        }
    }

    @Attribute(name="restriction", required=false)
    public @Attribute(name="restriction", required=false) String getRestrictions() {
        StringJoiner joiner = new StringJoiner(",");
        if (this.isHexInputAllowed()) {
            joiner.add(RESTRICTION_HEX);
        }
        if (this.isDecInputAllowed()) {
            joiner.add(RESTRICTION_DEC);
        }
        if (this.isOctInputAllowed()) {
            joiner.add(RESTRICTION_OCT);
        }
        if (this.isBinInputAllowed()) {
            joiner.add(RESTRICTION_BIN);
        }
        return joiner.toString();
    }

    public IntegerSetting(String id, @Nullable String uiName, @Nullable String uiNameExpr, @Nullable Description description, IntegerType integerType, @Nullable String availableCond, @Nullable String enableCond, @Nullable String publicCond, @Nullable String options, @Nullable OptionsExpr optionsExpr, @Nullable String minValue, @Nullable String maxValue) {
        super(id, uiName, uiNameExpr, description, availableCond, enableCond, publicCond, options, optionsExpr, minValue, maxValue);
        this.integerType = integerType;
    }

    @Deprecated
    protected IntegerSetting() {
        this("", null, null, null, IntegerType.int16_t, null, null, null, null, null, null, null);
    }

    public IntegerType getType() {
        return this.integerType;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + super.toString() + "," + " " + "type" + "=" + (Object)((Object)this.getType()) + "]";
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.integerType.hashCode();
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerSetting other = (IntegerSetting)obj;
        return this.integerType == other.integerType;
    }

    @Override
    public IntegerSetting fromReference(ReferenceSetting ref) {
        IntegerSetting integerSetting = new IntegerSetting(ref.getId(), (String)IUIName.getUiNames(ref, this).getFirst(), (String)IUIName.getUiNames(ref, this).getSecond(), this.getDescription(ref.getDescription()), this.integerType, IntegerSetting.andConditions(ref.getAvailableExprString(), this.getAvailableExprString()), IntegerSetting.andConditions(ref.getEnableExprString(), this.getEnableExprString()), IntegerSetting.andConditions(ref.getPublicCondition(), this.getPublicCondition()), null, null, this.getMinValueString(), this.getMaxValueString());
        integerSetting.setOptionsMap(this.createOptionsMap(this.getOptionsMap(), ref.getOptionsMap()));
        integerSetting.setValidation(this.mergeValidations(ref.getValidation(), this.getValidation()));
        integerSetting.setMigrations(ref.getMigrations());
        integerSetting.setRestrictions(this.getRestrictions());
        integerSetting.setAssigns(CollectionsUtils.mergeToList((Collection[])new Collection[]{ref.getAssigns(), this.getAssigns()}));
        integerSetting.verify();
        return integerSetting;
    }

    public boolean isHexInputAllowed() {
        return this.hexInputAllowed;
    }

    public void setHexInputAllowed(boolean hexInputAllowed) {
        this.hexInputAllowed = hexInputAllowed;
    }

    public boolean isDecInputAllowed() {
        return this.decInputAllowed;
    }

    public void setDecInputAllowed(boolean decInputAllowed) {
        this.decInputAllowed = decInputAllowed;
    }

    public boolean isBinInputAllowed() {
        return this.binInputAllowed;
    }

    public void setBinInputAllowed(boolean binInputAllowed) {
        this.binInputAllowed = binInputAllowed;
    }

    public boolean isOctInputAllowed() {
        return this.octInputAllowed;
    }

    public void setOctInputAllowed(boolean octInputAllowed) {
        this.octInputAllowed = octInputAllowed;
    }

    @Override
    public @NonNull String getTypeName() {
        return "integer";
    }

    public static enum IntegerType {
        uint8_t,
        int8_t,
        uint16_t,
        int16_t,
        uint32_t,
        int32_t,
        uint64_t,
        int64_t;

    }
}

