/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data.setting;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.resourcetables.model.data.Description;
import com.nxp.swtools.resourcetables.model.data.OptionsExpr;
import com.nxp.swtools.resourcetables.model.data.setting.ASetting;
import com.nxp.swtools.resourcetables.model.data.setting.IUIName;
import com.nxp.swtools.resourcetables.model.data.setting.ReferenceSetting;
import java.util.Collection;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;

@Root(name="dynamic_enum", strict=false)
@Order(attributes={"id", "label", "label_expr", "available", "enable", "options", "public", "items"})
public class DynamicEnumSetting
extends ASetting {
    @Nullable
    private Expression itemsExpr;
    @Element(name="custom_value_support", required=false)
    @Nullable
    private @Element(name="custom_value_support", required=false) @Nullable CustomValueSupport customValueSupport;

    public @Nullable Expression getItemsExpr() {
        return this.itemsExpr;
    }

    @Attribute(required=true, name="items")
    public @Attribute(required=true, name="items") @Nullable String getItemsExprString() {
        return this.itemsExpr != null ? this.itemsExpr.formatOutput(FormatOptions.DEFAULT) : null;
    }

    @Attribute(required=true, name="items")
    public void setItemsExprString(String newExpr) {
        if (!newExpr.isEmpty()) {
            try {
                this.itemsExpr = Expression.create((String)newExpr);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Items expression of enum \"" + this.getId() + "\" caused exception: " + e.getLocalizedMessage());
            }
        }
    }

    public @Nullable CustomValueSupport getCustomValueSupport() {
        return this.customValueSupport;
    }

    @Deprecated
    protected DynamicEnumSetting() {
        this("", null, null, null, "", null, null, null, null, null, null);
    }

    public DynamicEnumSetting(String id, @Nullable String uiName, @Nullable String uiNameExpr, @Nullable Description description, String itemsExpression, @Nullable CustomValueSupport customValueSupport, @Nullable String availableCond, @Nullable String enableCond, @Nullable String publicCond, @Nullable String options, @Nullable OptionsExpr optionsExpr) {
        super(id, uiName, uiNameExpr, description, availableCond, enableCond, publicCond, options, optionsExpr);
        if (!itemsExpression.isEmpty()) {
            this.itemsExpr = Expression.tryCreate((String)itemsExpression);
        }
        this.customValueSupport = customValueSupport;
    }

    @Override
    public DynamicEnumSetting fromReference(ReferenceSetting ref) {
        String items = this.itemsExpr != null ? this.itemsExpr.formatOutput(FormatOptions.DEFAULT) : "";
        DynamicEnumSetting dynamicEnumSetting = new DynamicEnumSetting(ref.getId(), (String)IUIName.getUiNames(ref, this).getFirst(), (String)IUIName.getUiNames(ref, this).getSecond(), this.getDescription(ref.getDescription()), items, this.customValueSupport, DynamicEnumSetting.andConditions(ref.getAvailableExprString(), this.getAvailableExprString()), DynamicEnumSetting.andConditions(ref.getEnableExprString(), this.getEnableExprString()), DynamicEnumSetting.andConditions(ref.getPublicCondition(), this.getPublicCondition()), null, null);
        dynamicEnumSetting.setOptionsMap(this.createOptionsMap(this.getOptionsMap(), ref.getOptionsMap()));
        dynamicEnumSetting.setValidation(this.mergeValidations(ref.getValidation(), this.getValidation()));
        dynamicEnumSetting.setMigrations(ref.getMigrations());
        dynamicEnumSetting.setAssigns(CollectionsUtils.mergeToList((Collection[])new Collection[]{ref.getAssigns(), this.getAssigns()}));
        dynamicEnumSetting.verify();
        return dynamicEnumSetting;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        DynamicEnumSetting other = (DynamicEnumSetting)obj;
        if (!Objects.equals(this.itemsExpr, other.itemsExpr)) {
            return false;
        }
        return Objects.equals(this.customValueSupport, other.customValueSupport);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.itemsExpr);
        result = 31 * result + Objects.hashCode(this.customValueSupport);
        return result;
    }

    @Override
    public @NonNull String getTypeName() {
        return "dynamic_enum";
    }

    @Root(name="custom_value_support", strict=false)
    @Order(attributes={"default", "validation_expr"})
    public static class CustomValueSupport {
        private String defaultValue = "";
        @Nullable
        private Expression validationExpr;

        @Attribute(name="validation_expr", required=true)
        public void setValidationExprString(String validationExprString) {
            try {
                this.validationExpr = Expression.create((String)validationExprString);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Validation condition of custom value support caused exception: " + e.getLocalizedMessage());
            }
        }

        @Attribute(name="default", required=true)
        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public @Nullable Expression getValidationExpression() {
            return this.validationExpr;
        }

        @Attribute(name="validation_expr")
        public @Attribute(name="validation_expr") String getValidationExprString() {
            if (this.validationExpr != null) {
                return this.validationExpr.formatOutput(FormatOptions.DEFAULT);
            }
            return "";
        }

        @Attribute(name="default")
        public @Attribute(name="default") String getDefaultValue() {
            return this.defaultValue;
        }

        @Deprecated
        public CustomValueSupport() {
        }

        public CustomValueSupport(String defaultValue, String validationExpr) {
            this.defaultValue = defaultValue;
            this.setValidationExprString(validationExpr);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.defaultValue.hashCode();
            result = 31 * result + Objects.hashCode(this.validationExpr);
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CustomValueSupport other = (CustomValueSupport)obj;
            if (!this.defaultValue.equals(other.defaultValue)) {
                return false;
            }
            return Objects.equals(this.validationExpr, other.validationExpr);
        }
    }
}

