/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.resourcetables.model.data.Option;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class OptionsMap {
    private Map<String, Option> options = new HashMap<String, Option>();

    public OptionsMap() {
    }

    public OptionsMap(Map<String, Option> newOptions) {
        this.setOptions(newOptions);
    }

    public void setOptions(Map<String, Option> newOptions) {
        this.options.clear();
        this.options.putAll(newOptions);
    }

    public void addOption(String id, Option option) {
        this.options.put(id, option);
    }

    public boolean isAvailable(String id, IContext context) {
        Option option = this.options.get(id);
        if (option != null) {
            return option.isAvailable(context);
        }
        return false;
    }

    public boolean isOptionSet(String id) {
        return this.options.containsKey(id);
    }

    public @Nullable Expression getOptionExpr(String id) {
        Option option = this.options.get(id);
        if (option != null) {
            return option.getExpr();
        }
        return null;
    }

    public @Nullable Object getOptionValue(String id, IContext context) {
        Option option = this.options.get(id);
        if (option != null) {
            if (!option.isAvailable(context)) {
                return null;
            }
            Expression expr = option.getExpr();
            if (expr == null) {
                return null;
            }
            return expr.resolve(context).getValue();
        }
        return null;
    }

    public Collection<String> getPresentOptions() {
        return CollectionsUtils.unmodifiableCollection((Collection)CollectionsUtils.safeKeySet(this.options));
    }

    public Map<String, Option> getOptions() {
        return this.options;
    }

    public void mergeWith(OptionsMap otherMap) {
        this.options.putAll(otherMap.getOptions());
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionsMap)) {
            return false;
        }
        OptionsMap other = (OptionsMap)obj;
        return Objects.equals(this.options, other.options);
    }

    public int hashCode() {
        return Objects.hash(this.options);
    }

    public @Nullable Option getOption(String id) {
        return this.options.get(id);
    }
}

