/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.config;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.CollectionMap;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.runtime.JobsHelper;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.ComparatorHelpers;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsSetSetting;
import com.nxp.swtools.resourcetables.model.Messages;
import com.nxp.swtools.resourcetables.model.config.ASettingConfig;
import com.nxp.swtools.resourcetables.model.config.AssignConfig;
import com.nxp.swtools.resourcetables.model.config.CacheHelper;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.ChildProviderHelper;
import com.nxp.swtools.resourcetables.model.config.DependencyResponseConfig;
import com.nxp.swtools.resourcetables.model.config.DumpFormatOptions;
import com.nxp.swtools.resourcetables.model.config.DumpHelper;
import com.nxp.swtools.resourcetables.model.config.ExpressionContext;
import com.nxp.swtools.resourcetables.model.config.ICacheable;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.QuickSelectionHelper;
import com.nxp.swtools.resourcetables.model.config.RegisterConfig;
import com.nxp.swtools.resourcetables.model.config.RegistersModelSingleton;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.data.Assign;
import com.nxp.swtools.resourcetables.model.data.DependencyResponse;
import com.nxp.swtools.resourcetables.model.data.Description;
import com.nxp.swtools.resourcetables.model.data.IQuickSelection;
import com.nxp.swtools.resourcetables.model.data.IQuickSetting;
import com.nxp.swtools.resourcetables.model.data.Level;
import com.nxp.swtools.resourcetables.model.data.SettingUtils;
import com.nxp.swtools.resourcetables.model.data.SortTarget;
import com.nxp.swtools.resourcetables.model.data.Validation;
import com.nxp.swtools.resourcetables.model.data.setting.IBaseModel;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.data.setting.SetSetting;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class SetConfig
extends ASettingConfig
implements IChildProvidable {
    private final Map<String, SetPresence> values = new HashMap<String, SetPresence>();

    public SetConfig(SetConfig original) {
        super(original.id, original.name, original.setting, (AStoragePeriphsSetting)new StoragePeriphsSetSetting(), original.getChildContext().clone(), original.mcu);
        for (SetPresence oldChild : original.getChildren()) {
            SetPresence newChild = new SetPresence(oldChild);
            this.values.put(newChild.getItem().getId(), newChild);
        }
        this.updateStorage();
    }

    protected SetConfig(String id, String name, ISetting setting, ChildContext parentContext, ICommonMcu mcu) {
        super(id, name, setting, (AStoragePeriphsSetting)new StoragePeriphsSetSetting(), parentContext, mcu);
        for (SetSetting.Item item : this.getModelData().getItems()) {
            this.values.put(item.getId(), new SetPresence(item));
        }
        this.updateStorage();
    }

    protected SetConfig(String id, ISetting setting, ChildContext parentContext, StoragePeriphsSetSetting storageSetting, ICommonMcu mcu) {
        super(id, storageSetting.getName(), setting, (AStoragePeriphsSetting)storageSetting, parentContext, mcu);
        this.childContext.setCurrent(this);
        for (SetSetting.Item item : this.getModelData().getItems()) {
            boolean itemValue = storageSetting.getSelected().contains(item.getId());
            this.values.put(item.getId(), new SetPresence(item, itemValue));
        }
    }

    final void updateStorage() {
        this.getStorageSetting().getSelected().clear();
        for (SetPresence itemPresence : this.getChildren()) {
            if (!itemPresence.getBoolValue()) continue;
            this.getStorageSetting().getSelected().add(itemPresence.getItem().getId());
        }
    }

    @Override
    public void applyOther(ISettingConfig config) {
        if (!(config instanceof SetConfig)) {
            throw new IllegalArgumentException(MessageFormat.format("Unexpected setting type with id {0} - expected {1}", config.getId(), SetConfig.class.getName()));
        }
        SetConfig set = (SetConfig)config;
        for (SetSetting.Item item : this.getModelData().getItems()) {
            SetPresence itemConfig = (SetPresence)set.getChildById(item.getId());
            boolean itemValue = itemConfig == null ? false : itemConfig.getBoolValue();
            SetPresence setPresence = this.values.get(item.getId());
            if (setPresence == null) {
                LOGGER.severe(MessageFormat.format("SetPresence of item: {0} of setting: {1} does not exist", item.getId(), this.setting.getId()));
                continue;
            }
            setPresence.setValue(itemValue);
        }
        this.updateStorage();
    }

    @Override
    public void applyQuickSelection(@Nullable IQuickSelection quickSelection, IChild relativeTo) {
        if (!this.applyQuickSelectionFromResource(quickSelection, relativeTo)) {
            if (quickSelection == null) {
                return;
            }
            String quickSelId = QuickSelectionHelper.getQuickSelectionId(this, relativeTo);
            for (SetSetting.Item item : this.getModelData().getItems()) {
                IQuickSetting setToUse = quickSelection.getSetting(SettingUtils.buildId(quickSelId, item.getId()));
                if (setToUse == null) continue;
                SetPresence setPresence = this.values.get(item.getId());
                boolean itemValue = false;
                Expression resource = setToUse.getResourceExpr();
                if (resource != null) {
                    ScalarConfig config;
                    ISettingConfig valueFromExpression = this.getConfigFromExpression(relativeTo.getChildContext(), resource);
                    if (valueFromExpression instanceof ScalarConfig && (config = (ScalarConfig)valueFromExpression).getType() == ScalarConfig.Type.BOOL) {
                        itemValue = Boolean.parseBoolean(config.getValue().toString());
                    }
                } else {
                    String itemQuickSel = setToUse.getValue();
                    boolean bl = itemValue = itemQuickSel == null ? false : Boolean.parseBoolean(itemQuickSel);
                }
                if (setPresence == null) {
                    LOGGER.severe(MessageFormat.format("[DATA] SetPresence of item: {0} of setting: {1} does not exist", item.getId(), this.setting.getId()));
                    continue;
                }
                setPresence.setValue(itemValue, false);
            }
            this.updateStorage();
        }
    }

    public StoragePeriphsSetSetting getStorageSetting() {
        return (StoragePeriphsSetSetting)this.storageSetting;
    }

    @Override
    public @NonNull SetSetting getModelData() {
        return (SetSetting)super.getModelData();
    }

    @Override
    public Object getValue() {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*value", () -> this);
    }

    @Override
    public @Nullable IChild getChildById(String childId) {
        return ChildProviderHelper.getChildRelative(this, childId);
    }

    @Override
    public @Nullable IChild getChild(String childName) {
        return this.values.get(childName);
    }

    public List<SetPresence> getChildren() {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*children", () -> {
            ArrayList<SetPresence> result;
            block9: {
                SortTarget sortTarget;
                result = new ArrayList<SetPresence>();
                for (SetSetting.Item item : this.getModelData().getItems()) {
                    SetPresence settingConfig = this.values.get(item.getId());
                    if (settingConfig == null) {
                        IComponentConfig cc = this.childContext.getComponentConfig();
                        String componentId = cc != null ? cc.getId() : "";
                        LOGGER.severe(MessageFormat.format("[DATA] Configuration not found for an item with ID {0} referenced in set setting with ID {1} of component with ID {2}", item.getId(), this.id, componentId));
                        continue;
                    }
                    result.add(settingConfig);
                }
                Object sortContentAsValue = this.getOptionValue("UI_SORT_CONTENT_AS");
                if (!(sortContentAsValue instanceof String) || (sortTarget = this.getSortTargetValue()) == SortTarget.UNKNOWN) break block9;
                switch ((String)sortContentAsValue) {
                    case "ASC_NATURAL": {
                        Collections.sort(result, (o1, o2) -> ComparatorHelpers.compareAscendingNatural((String)o1.getTargetValue(sortTarget), (String)o2.getTargetValue(sortTarget)));
                        break;
                    }
                    default: {
                        LOGGER.severe(MessageFormat.format("[DATA] Unknown {0} option value: {1} of setting: {2}", "UI_SORT_CONTENT_AS", sortContentAsValue, this.setting.getId()));
                    }
                }
            }
            return result;
        });
    }

    @Override
    public @NonNull String getTypeName() {
        return "set";
    }

    @Override
    public void initValue() {
        for (SetPresence item : this.getChildren()) {
            item.initialize();
        }
    }

    @Override
    public void updateStorageAvailability() {
        this.getStorageSetting().getSelected().clear();
        for (SetPresence itemPresence : this.getChildren()) {
            if (!itemPresence.value || !itemPresence.isAvailable()) continue;
            this.getStorageSetting().getSelected().add(itemPresence.item.getId());
        }
    }

    @Override
    public void setDefaultValue() {
        for (SetPresence child : this.getChildren()) {
            boolean defaultValue = false;
            if (child.isOptionSet("DEFAULT_VALUE") && child.isOptionAvailable("DEFAULT_VALUE")) {
                Object optionValue = child.getOptionValue("DEFAULT_VALUE");
                if (optionValue instanceof Boolean) {
                    defaultValue = (Boolean)optionValue;
                } else if (optionValue instanceof String) {
                    defaultValue = Boolean.parseBoolean((String)optionValue);
                }
            }
            child.setValue(defaultValue);
        }
    }

    @Override
    public void deInitialize() {
        for (SetPresence presence : this.values.values()) {
            presence.deInitialize();
        }
        this.updateStorageAvailability();
    }

    @Override
    public List<DependencyResponseConfig> getDependencyResponses() {
        ArrayList<DependencyResponseConfig> result = new ArrayList<DependencyResponseConfig>();
        Validation validation = this.setting.getValidation();
        if (validation != null) {
            result.addAll((Collection)validation.getDependencyResponses().stream().map(r -> new DependencyResponseConfig(this, (DependencyResponse)r)).collect(CollectorsUtils.toList()));
        }
        for (SetPresence settingConfig : this.getChildren()) {
            result.addAll(settingConfig.getDependencyResponses());
        }
        return result;
    }

    @Override
    public void dispose() {
        this.values.clear();
        super.dispose();
    }

    @Override
    public StringBuilder dump(StringBuilder builder, DumpFormatOptions options) {
        return DumpHelper.dump(builder, options, this);
    }

    public class SetPresence
    implements IChild,
    ICacheable {
        final SetSetting.Item item;
        boolean value;
        private final ExpressionContext exprContext;
        private final ChildContext itemContext;
        @Nullable
        protected List<AssignConfig> assignConfigs;
        private boolean initialized;

        protected SetPresence(SetPresence original) {
            this.item = original.item;
            this.value = original.value;
            this.itemContext = original.getChildContext().clone();
            this.exprContext = new ExpressionContext(this.itemContext, SetConfig.this.mcu);
            RegistersModelSingleton.getInstance().getAssignCreationLatch().decrease();
            JobsHelper.runjob((String)UtilsText.safeString((String)Messages.get().ScalarConfig_JobTitle_CreateAssigns), this::createAssignConfig);
        }

        protected SetPresence(SetSetting.Item item) {
            this.item = item;
            this.itemContext = SetConfig.this.childContext.createForChild(this);
            this.exprContext = new ExpressionContext(this.itemContext, SetConfig.this.mcu);
            RegistersModelSingleton.getInstance().getAssignCreationLatch().decrease();
            JobsHelper.runjob((String)UtilsText.safeString((String)Messages.get().ScalarConfig_JobTitle_CreateAssigns), this::createAssignConfig);
        }

        protected SetPresence(SetSetting.Item item, boolean value) {
            this.item = item;
            this.value = value;
            this.itemContext = SetConfig.this.childContext.createForChild(this);
            this.exprContext = new ExpressionContext(this.itemContext, SetConfig.this.mcu);
            this.initialized = true;
            RegistersModelSingleton.getInstance().getAssignCreationLatch().decrease();
            JobsHelper.runjob((String)UtilsText.safeString((String)Messages.get().ScalarConfig_JobTitle_CreateAssigns), this::createAssignConfig);
        }

        public synchronized void addAssign(AssignConfig assignConfig) {
            List<AssignConfig> assignConfigsLoc = this.assignConfigs;
            if (assignConfigsLoc == null) {
                this.assignConfigs = assignConfigsLoc = new ArrayList<AssignConfig>();
            }
            assignConfigsLoc.add(assignConfig);
        }

        public synchronized List<AssignConfig> getAssignConfigs() {
            return Collections.unmodifiableList(CollectionsUtils.safeList(this.assignConfigs));
        }

        public SetSetting.Item getItem() {
            return this.item;
        }

        public void setValue(boolean value) {
            this.setValue(value, true);
        }

        protected void setValue(boolean value, boolean update) {
            this.value = value;
            this.initialized = true;
            this.getChildContext().getRoot().clearCacheForValueChange(this);
            if (update) {
                SetConfig.this.updateStorage();
            }
        }

        public String getTargetValue(SortTarget target) {
            switch (target) {
                case LABEL: {
                    return this.getUiName();
                }
                case VALUE: {
                    return this.getValue().toString();
                }
            }
            return "";
        }

        @Override
        public Object getValue() {
            return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*value", () -> this.value);
        }

        public boolean getBoolValue() {
            return this.value;
        }

        @Override
        public boolean isAvailable() {
            return SetConfig.this.isAvailable() && this.item.isAvailable(this.exprContext);
        }

        @Override
        public boolean isEnabled() {
            return SetConfig.this.isEnabled() && this.item.isEnabled(this.exprContext);
        }

        @Override
        public String getId() {
            return SettingUtils.buildId(SetConfig.this.id, this.item.getId());
        }

        @Override
        public String getName() {
            return this.item.getId();
        }

        @Override
        public String getUiName() {
            return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*label", () -> this.item.getUIName(SetConfig.this.expressionContext));
        }

        public @Nullable String getDescription() {
            StringBuilder builder = new StringBuilder();
            Description description = this.item.getDescription();
            if (description != null) {
                builder.append(description.getDescription(SetConfig.this.expressionContext));
            }
            this.addDescriptionOfRegisterAssigns(builder);
            return builder.length() == 0 ? null : builder.toString();
        }

        public @NonNull String getValueName() {
            return Boolean.toString(this.value);
        }

        @Override
        public ChildContext getChildContext() {
            return this.itemContext;
        }

        @Override
        public IContext getExpressionContext() {
            return this.exprContext;
        }

        @Override
        public @Nullable String getProblems(Level level) {
            return null;
        }

        @Override
        public void updateStorageAvailability() {
        }

        @Override
        public @NonNull IBaseModel getModelData() {
            return this.item;
        }

        @Override
        public boolean isOptionSet(String option) {
            return this.item.isOptionSet(option) && this.isOptionAvailable(option);
        }

        @Override
        public boolean isOptionAvailable(String option) {
            return this.item.isOptionAvailable(option, SetConfig.this.expressionContext);
        }

        @Override
        public @Nullable Object getOptionValue(String option) {
            return this.item.getOptionValue(option, this.getExpressionContext());
        }

        private void createAssignConfig() {
            this.item.getAssigns().forEach(e -> this.addAssign(new AssignConfig((Assign)e, this)));
            RegistersModelSingleton.getInstance().getAssignCreationLatch().increase();
        }

        private void addDescriptionOfRegisterAssigns(StringBuilder builder) {
            IComponentInstanceConfig instance = this.getChildContext().getComponentInstanceConfig();
            if (!this.getAssignConfigs().isEmpty() && instance != null && instance.getComponent().isRegistersInitialization()) {
                builder.append("<br/>").append(Messages.get().ASettingConfig_InfluencedRegistersBitfields);
                StringJoiner joiner = new StringJoiner(", ");
                for (AssignConfig assign : this.getAssignConfigs()) {
                    if (!assign.isEnabled()) continue;
                    for (RegisterConfig register : assign.getRegisters()) {
                        try {
                            this.addDescriptionOfRegisterAssign(UtilsText.safeString((String)instance.getPeripheral()), joiner, register);
                        }
                        catch (RegistersModelSingleton.RegisterNotFoundException e) {
                            e.log(this.getId());
                        }
                    }
                }
                builder.append(joiner.toString());
            }
        }

        private void addDescriptionOfRegisterAssign(String defaultPeripheral, StringJoiner joiner, RegisterConfig registerAssign) {
            StringBuilder registerStringBuilder = new StringBuilder();
            String peripheral = registerAssign.getPeripheral(this.getExpressionContext());
            if (peripheral == null) {
                peripheral = defaultPeripheral;
            }
            String registerWholeName = RegistersModelSingleton.computeFullNameOfRegister(peripheral, registerAssign.getName(this.getExpressionContext()));
            String bitfieldName = registerAssign.getBitfield(this.getExpressionContext());
            IFunctionalGroup functionalGroup = this.getChildContext().getFunctionalGroup();
            if (functionalGroup != null) {
                BigInteger valueOfBitField = RegistersModelSingleton.getInstance().getValueOfBitField(functionalGroup, registerWholeName, bitfieldName);
                registerStringBuilder.append(registerWholeName).append("[").append(bitfieldName).append("]");
                if (valueOfBitField != null) {
                    registerStringBuilder.append("=").append(valueOfBitField);
                }
            }
            joiner.add(registerStringBuilder.toString());
        }

        public Collection<DependencyResponseConfig> getDependencyResponses() {
            return Collections.emptyList();
        }

        @Override
        public Map<String, Object> getCache() {
            IConfigSetConfig configSetLoc = this.getChildContext().getConfigSetConfig();
            if (configSetLoc != null) {
                return configSetLoc.getCache();
            }
            return new HashMap<String, Object>();
        }

        @Override
        public CollectionMap<String, CollectionsUtils.Pair<String, ICacheable>> getDependencyMap() {
            IConfigSetConfig configSetLoc = this.getChildContext().getConfigSetConfig();
            if (configSetLoc != null) {
                return configSetLoc.getDependencyMap();
            }
            return new CollectionMap();
        }

        public boolean getDefaultValue() {
            if (this.isOptionSet("DEFAULT_VALUE") && this.isOptionAvailable("DEFAULT_VALUE")) {
                Object optionValue = this.getOptionValue("DEFAULT_VALUE");
                if (optionValue instanceof Boolean) {
                    return (Boolean)optionValue;
                }
                if (optionValue instanceof String) {
                    return Boolean.parseBoolean((String)optionValue);
                }
            }
            return false;
        }

        public void setDefaultValue() {
            this.setValue(this.getDefaultValue());
        }

        public void initialize() {
            if (!this.initialized) {
                this.setDefaultValue();
                this.initialized = true;
            }
        }

        public void deInitialize() {
            this.setValue(false);
            this.initialized = false;
        }

        @Override
        public void dispose() {
            if (this.assignConfigs != null) {
                this.assignConfigs.clear();
                this.assignConfigs = null;
            }
        }

        @Override
        public StringBuilder dump(StringBuilder builder, DumpFormatOptions options) {
            return DumpHelper.dump(builder, options, this);
        }
    }
}

