/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.config;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.configuration.dependencies.IDependency;
import com.nxp.swtools.provider.configuration.storage.StorageDependency;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.ChildValidationHelper;
import com.nxp.swtools.resourcetables.model.config.DumpFormatOptions;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.data.Level;
import com.nxp.swtools.resourcetables.model.data.setting.IBaseModel;
import com.nxp.swtools.resourcetables.model.validation.ValidationHelper;
import com.nxp.swtools.utils.tooltip.IToolTipable;
import com.nxp.swtools.validation.engine.IValidationProblem;
import java.util.List;

public interface IChild
extends IToolTipable {
    public @Nullable IBaseModel getModelData();

    public String getId();

    default public String getComponentId() {
        IComponentInstanceConfig instanceConfig = this.getChildContext().getComponentInstanceConfig();
        IComponentConfig config = this.getChildContext().getComponentConfig();
        return instanceConfig != null ? instanceConfig.getId() : (config != null ? config.getId() : "");
    }

    default public String getConfigurationComponentType() {
        IComponentInstanceConfig instanceConfig = this.getChildContext().getComponentInstanceConfig();
        IComponentConfig config = this.getChildContext().getComponentConfig();
        return instanceConfig != null ? instanceConfig.getComponent().getId() : (config != null ? config.getComponent().getId() : "");
    }

    default public String getOriginatorId() {
        return StorageDependency.makeOriginatorId((String)this.getComponentId(), (String)this.getId());
    }

    public Object getValue();

    public @NonNull String getName();

    default public boolean hasDescription() {
        return false;
    }

    default public @NonNull String getIdForTooltip() {
        return this.getName();
    }

    public @NonNull String getUiName();

    public boolean isAvailable();

    public boolean isEnabled();

    default public boolean isSettingVisible() {
        return this.isAvailable() && this.isEnabled() && !this.isControlHidden();
    }

    public ChildContext getChildContext();

    public IContext getExpressionContext();

    default public IDependency @Nullable [] getOwnDependencies(String source) {
        return null;
    }

    default public @Nullable String getProblems(Level level) {
        return ChildValidationHelper.mergeProblems(ChildValidationHelper.mergeProblems((String[])CollectionsUtils.toNullableTypeArrayUnchecked((Object[])this.getOwnProblems(level))), null);
    }

    default public List<IValidationProblem> getOwnValidationProblems(int level) {
        return ValidationHelper.getComponentValidationProblems(this, level);
    }

    default public String @Nullable [] getOwnProblems(Level level) {
        return null;
    }

    default public @Nullable String getError() {
        return this.getProblems(Level.ERROR);
    }

    default public @Nullable String getWarning() {
        return this.getProblems(Level.WARNING);
    }

    default public @Nullable String getInfo() {
        return this.getProblems(Level.INFO);
    }

    public void updateStorageAvailability();

    public boolean isOptionSet(String var1);

    public boolean isOptionAvailable(String var1);

    public @Nullable Object getOptionValue(String var1);

    default public List<String> getProblemsPaths(Level level) {
        if (this.isOptionSet("UI_LABEL_HIDDEN") || this.getOwnProblems(level) == null) {
            return CollectionsUtils.asList((Object)"");
        }
        return CollectionsUtils.asList((Object)UtilsText.safeString((String)this.getUiName()));
    }

    default public int getHighestSeverityProblemLevel() {
        int highestSeverityProblemLevel = -1;
        String status = this.getError();
        if (status != null) {
            highestSeverityProblemLevel = 2;
        } else if (this.getWarning() != null) {
            highestSeverityProblemLevel = 1;
        } else if (this.getInfo() != null) {
            highestSeverityProblemLevel = 0;
        }
        return highestSeverityProblemLevel;
    }

    default public String makeOriginatorId(ChildContext context) {
        IComponentInstanceConfig instanceConfig = context.getComponentInstanceConfig();
        IComponentConfig componentConfig = context.getComponentConfig();
        String componentId = instanceConfig != null ? instanceConfig.getId() : (componentConfig != null ? componentConfig.getId() : "");
        return StorageDependency.makeOriginatorId((String)componentId, (String)this.getId());
    }

    default public void delayedInitAfterCreation() {
    }

    default public void synchronizeValue(@Nullable IChild config) {
    }

    default public boolean isSynchronizationEnabled() {
        return false;
    }

    default public boolean isControlHidden() {
        return this.isOptionSet("UI_CONTROL_HIDDEN");
    }

    default public boolean isStorable() {
        return true;
    }

    default public boolean canBeStoredUnavailable() {
        if (this.isOptionSet("STORE_UNAVAILABLE_STOP") && this.isOptionAvailable("STORE_UNAVAILABLE_STOP")) {
            return false;
        }
        return this.isOptionSet("STORE_UNAVAILABLE") && this.isOptionAvailable("STORE_UNAVAILABLE");
    }

    default public boolean providesSnippet() {
        return false;
    }

    public void dispose();

    default public StringBuilder dump(StringBuilder builder, DumpFormatOptions options) {
        return builder;
    }
}

