/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.config;

import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.RegisterConfig;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.data.Assign;
import com.nxp.swtools.resourcetables.model.data.Register;
import com.nxp.swtools.resourcetables.model.data.Setting;
import java.util.ArrayList;
import java.util.List;

public class AssignConfig {
    private final Assign rule;
    private final List<ScalarConfig> targetVariables;
    private final IChild node;
    private List<RegisterConfig> registers = new ArrayList<RegisterConfig>();

    public AssignConfig(Assign rule, IChild node) {
        this.rule = rule;
        this.node = node;
        this.targetVariables = new ArrayList<ScalarConfig>();
        rule.getRegisters().forEach(register -> {
            boolean bl = this.registers.add(new RegisterConfig((Register)register));
        });
        rule.getSettings().forEach(variable -> {
            IChild settConf;
            IConfigSetConfig confSetConf = node.getChildContext().getConfigSetConfig();
            if (confSetConf != null && (settConf = confSetConf.getChildById(variable.getName())) instanceof ScalarConfig) {
                this.targetVariables.add((ScalarConfig)settConf);
            }
        });
    }

    public Assign getRule() {
        return this.rule;
    }

    public IChild getParent() {
        return this.node;
    }

    public List<ScalarConfig> getTargetVariables() {
        return this.targetVariables;
    }

    public boolean isEnabled() {
        Expression whenConditionExpr = this.getRule().getWhenConditionExpr();
        return whenConditionExpr != null ? whenConditionExpr.resolve(this.node.getExpressionContext()).getBoolean() : true;
    }

    public List<RegisterConfig> getRegisters() {
        return this.registers;
    }

    public List<Setting> getSettings() {
        return this.getRule().getSettings();
    }

    public String toString() {
        return this.rule.toString();
    }
}

