/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.migration.actions.toolchains;

import com.nxp.s32ds.cle.cdt.internal.migration.CdtMigrationActivator;
import com.nxp.s32ds.cle.cdt.internal.migration.Messages;
import com.nxp.s32ds.cle.cdt.migration.entities.toolchains.ToolMigrationCompaibilities;
import com.nxp.s32ds.cle.runtime.migration.action.MigrationAction;
import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationEntityAnnotation;
import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationPropertyAnnotation;
import com.nxp.s32ds.cle.runtime.migration.property.MigrationProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

@MigrationEntityAnnotation(name="Update configurations for ARM 32 or ARM 64 toolchain.", description="Update configurations with specified ID for ARM 32 or ARM 64 toolchain.")
public class UpdateToolchainConfigurationAction
implements MigrationAction {
    private static final String DEFAULT_SYSROOT_OPTION = "--sysroot=\"${S32DS_ARM32_NEWLIB_DIR}\"";
    private static final String GCC_10_2_TOOLCHAIN_ID = "com.nxp.s32ds.cle.arm.mbs.arm32.bare.gnu.10.2.toolchain";
    private static final List<String> LIB_OPTION_VALUE_VALID_SUFFIXES = Arrays.asList(".newlib_noio", ".newlib_hosted", ".newlib_nano_noio", ".newlib_nano_hosted", ".newlib_hosted_v2m", ".newlib_nano_hosted_v2m");
    @MigrationPropertyAnnotation(name="sourceConfigurationIdPrefix", description="The prefix of source configuration ID.")
    private List<String> sourceConfigurationIdPrefixes;
    @MigrationPropertyAnnotation(description="The ID of target toolchain, prefix of target configuration ID.")
    private String targetToolchainId;
    @MigrationPropertyAnnotation(description="The ID of sysroot option.")
    private String sysRootOptionId;
    @MigrationPropertyAnnotation(description="The source ID of library option.")
    private String librarySourceOptionId;
    @MigrationPropertyAnnotation(description="The default value of library option.")
    private String defaultLibOptionValue;
    @MigrationPropertyAnnotation(description="Key/value map, defined as sub properties, used as templates for changing the option value. The property name is a substring of the option value that must be replaced with the property value.")
    private MigrationProperty optionModificationPattern;

    public void perform(IProject project, IProgressMonitor monitor) throws CoreException {
        for (String sourceConfigurationIdPrefix : this.sourceConfigurationIdPrefixes) {
            Collection<IConfiguration> configurations = UpdateToolchainConfigurationAction.getConfigurations(project, sourceConfigurationIdPrefix);
            for (IConfiguration config : configurations) {
                Map<String, Object> configOptions = UpdateToolchainConfigurationAction.getConfigOptions(config);
                Map<String, List<IOption>> toolchainOptions = UpdateToolchainConfigurationAction.getToolchainOptions(config);
                this.convertToolchain(project, config, sourceConfigurationIdPrefix);
                UpdateToolchainConfigurationAction.setToolchainOption(config, toolchainOptions);
                UpdateToolchainConfigurationAction.setConfigOptions(config, configOptions);
                this.modifyLibraryOption(config, configOptions);
                this.setSysRootOption(config);
                ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
                this.notifyOptionHandler(config);
            }
            if (!configurations.isEmpty()) break;
        }
    }

    private static Supplier<? extends CoreException> createToolchainNotFoundException(String id) {
        return () -> new CoreException(CdtMigrationActivator.getInstance().createError(NLS.bind((String)Messages.UpdateToolchainConfigurationActionBase_cannot_find_toolchain_for_configuration_0, (Object)id)));
    }

    private static Map<String, Object> getConfigOptions(IConfiguration configuration) {
        return Arrays.stream(configuration.getToolChain().getOptions()).collect(Collectors.toMap(o -> o.getBaseId() == null ? o.getId() : o.getBaseId(), o -> o.getValue()));
    }

    private static Map<String, List<IOption>> getToolchainOptions(IConfiguration configuration) {
        return Arrays.stream(configuration.getTools()).collect(Collectors.toMap(IBuildObject::getBaseId, t -> Arrays.asList(t.getOptions())));
    }

    private static Collection<IConfiguration> getConfigurations(IProject project, String configBaseIdPrefix) {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        return Arrays.stream(buildInfo.getManagedProject().getConfigurations()).filter(c -> c.getBaseId().startsWith(configBaseIdPrefix)).collect(Collectors.toList());
    }

    private static void setToolchainOption(IConfiguration configuration, Map<String, List<IOption>> toolchainOption) {
        ITool[] iToolArray = configuration.getTools();
        int n = iToolArray.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                List<IOption> list;
                ITool tool;
                block7: {
                    tool = iToolArray[n2];
                    list = toolchainOption.get(tool.getBaseId());
                    if (list != null) break block7;
                    String migrationCompatibilityToolId = ToolMigrationCompaibilities.getCompatibilityToolId(tool.getBaseId());
                    if (migrationCompatibilityToolId != null) {
                        list = toolchainOption.get(migrationCompatibilityToolId);
                    }
                    if (list == null) break block8;
                }
                for (IOption option : list) {
                    IOption optionById = tool.getOptionById(option.getId());
                    if (optionById != null && option.getValue() != null) {
                        optionById.setValue(option.getValue());
                        continue;
                    }
                    IOption newOption = tool.createOption(option.getSuperClass(), option.getId(), option.getName(), option.isExtensionElement());
                    if (newOption == null) continue;
                    newOption.setValue(option.getValue());
                }
            }
            ++n2;
        }
    }

    private void convertToolchain(IProject project, IConfiguration configuration, String sourceConfigurationIdPrefix) throws CoreException {
        try {
            String targetConfigurationId = configuration.getBaseId().replace(sourceConfigurationIdPrefix, this.targetToolchainId);
            IToolChain targetToolchain = (IToolChain)((ToolChain)Arrays.stream(ManagedBuildManager.getRealToolChains()).filter(p -> p.getId().equals(this.targetToolchainId)).findFirst().orElseThrow(UpdateToolchainConfigurationAction.createToolchainNotFoundException(this.targetToolchainId))).getIdenticalList().stream().filter(p -> p.getId().equals(targetConfigurationId)).findFirst().orElseThrow(UpdateToolchainConfigurationAction.createToolchainNotFoundException(targetConfigurationId));
            IToolChain targetChildToolchain = Arrays.stream(ManagedBuildManager.getExtensionToolChains()).filter(p -> p.getId().equals(targetConfigurationId)).findFirst().orElseThrow(UpdateToolchainConfigurationAction.createToolchainNotFoundException(targetConfigurationId));
            ManagedBuildManager.getBuildInfo((IResource)project).getManagedProject().getProjectType().setConvertToId(targetConfigurationId);
            String targetChildToolchainId = ManagedBuildManager.calculateChildId((String)targetChildToolchain.getId(), null);
            IFolderInfo rootFolderInfo = configuration.getRootFolderInfo();
            rootFolderInfo.changeToolChain(targetToolchain, targetChildToolchainId, targetChildToolchain.getName());
        }
        catch (BuildException e) {
            throw new CoreException(CdtMigrationActivator.getInstance().createError(NLS.bind((String)Messages.UpdateToolchainConfigurationActionBase_cannot_convert_toolchain_for_project_0, (Object)project.getName()), e));
        }
    }

    private static void setConfigOptions(IConfiguration configuration, Map<String, Object> configurationOptions) {
        IOption[] iOptionArray = configuration.getToolChain().getOptions();
        int n = iOptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOption option = iOptionArray[n2];
            for (Map.Entry<String, Object> targetOption : configurationOptions.entrySet()) {
                if (!option.getId().equals(targetOption.getKey())) continue;
                UpdateToolchainConfigurationAction.setOptionValue(configuration, option, targetOption.getValue());
            }
            ++n2;
        }
    }

    private static void setOptionValue(IConfiguration configuration, IOption option, Object targetOptionValue) {
        try {
            switch (option.getValueType()) {
                case 1: 
                case 2: {
                    ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)configuration.getToolChain(), (IOption)option, (String)String.valueOf(targetOptionValue));
                    break;
                }
                case 0: {
                    ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)configuration.getToolChain(), (IOption)option, (boolean)Boolean.parseBoolean(String.valueOf(targetOptionValue)));
                    break;
                }
                default: {
                    ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)configuration.getToolChain(), (IOption)option, (String)String.valueOf(targetOptionValue));
                    break;
                }
            }
        }
        catch (BuildException e) {
            CdtMigrationActivator.getInstance().logError(String.valueOf(Messages.UpdateToolchainConfigurationActionBase_error_during_setting_value_for_option_0) + option.getId(), e);
        }
    }

    public void modifyLibraryOption(IConfiguration configuration, Map<String, Object> configurationOptions) {
        String libraryTargetOptionId = this.applyOptionModificationPattern(this.librarySourceOptionId);
        IOption option = Arrays.stream(configuration.getToolChain().getOptions()).filter(opt -> libraryTargetOptionId.equals(opt.getBaseId())).findFirst().orElse(null);
        if (option == null) {
            return;
        }
        Object currentValue = option.getValue();
        if (currentValue instanceof String && !((String)currentValue).endsWith(".none")) {
            return;
        }
        Object oldValue = configurationOptions.get(this.librarySourceOptionId);
        if (oldValue instanceof String) {
            String originalValue = (String)oldValue;
            String updatedValue = this.getLibOptionValue(originalValue);
            UpdateToolchainConfigurationAction.setOptionValue(configuration, option, updatedValue);
        } else {
            UpdateToolchainConfigurationAction.setOptionValue(configuration, option, this.defaultLibOptionValue);
        }
    }

    private String getLibOptionValue(String originalValue) {
        String valueSuffix = originalValue.substring(originalValue.lastIndexOf(46));
        if (!LIB_OPTION_VALUE_VALID_SUFFIXES.contains(valueSuffix)) {
            return this.defaultLibOptionValue;
        }
        return this.applyOptionModificationPattern(originalValue);
    }

    private String applyOptionModificationPattern(String originalValue) {
        List patterns = this.optionModificationPattern.getProperties();
        if (patterns.size() > 0) {
            MigrationProperty pattern = (MigrationProperty)patterns.get(0);
            String replaceFrom = pattern.getName();
            String replaceTo = pattern.getValue();
            return originalValue.replace(replaceFrom, replaceTo);
        }
        return originalValue;
    }

    private void setSysRootOption(IConfiguration configuration) {
        if (configuration.getToolChain().getId().contains(GCC_10_2_TOOLCHAIN_ID)) {
            Arrays.stream(configuration.getToolChain().getOptions()).filter(o -> this.sysRootOptionId.equals(o.getBaseId())).findFirst().ifPresent(o -> {
                IOption iOption = ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)configuration.getToolChain(), (IOption)o, (String)"");
            });
        } else {
            Arrays.stream(configuration.getToolChain().getOptions()).filter(o -> this.sysRootOptionId.equals(o.getBaseId())).findFirst().ifPresent(o -> {
                IOption iOption = ManagedBuildManager.setOption((IConfiguration)configuration, (IHoldsOptions)configuration.getToolChain(), (IOption)o, (String)UpdateToolchainConfigurationAction.getDefaultSysRootValue(o));
            });
        }
    }

    private static String getDefaultSysRootValue(IOption option) {
        Object defaultValue = option.getDefaultValue();
        if (defaultValue instanceof String) {
            return (String)defaultValue;
        }
        return DEFAULT_SYSROOT_OPTION;
    }

    public void notifyOptionHandler(IConfiguration configuration) {
        ManagedBuildManager.performValueHandlerEvent((IConfiguration)configuration, (int)4);
    }
}

