/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.views;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.model.scenarios.IScenarioElement;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class VStagesView
extends Composite {
    @Nullable
    private ITreeContentProvider stageTreeContentProvider;
    @Nullable
    private ITableLabelProvider stageTreeLabelProvider;
    @Nullable
    private Listener scenarioSelectionListener;
    private int numStages;
    @Nullable
    private CTabFolder stagesFolder;
    @Nullable
    private @Nullable Composite @Nullable [] stagePanels;
    @Nullable
    private @Nullable Tree @Nullable [] stageTrees;
    @Nullable
    private transient @Nullable TreeViewer @Nullable [] stageTreeViewers;

    public VStagesView(Composite parentView) {
        super(parentView, 0);
        this.createUi();
    }

    private void createStagePanels(int numPanels) {
        this.stagePanels = new Composite[numPanels];
        this.stageTrees = new Tree[numPanels];
        this.stageTreeViewers = new TreeViewer[numPanels];
        @Nullable Composite[] stagePanelsLoc = this.stagePanels;
        @Nullable Tree[] stageTreesLoc = this.stageTrees;
        @Nullable TreeViewer[] stageTreeViewersLoc = this.stageTreeViewers;
        int i = 0;
        while (i < numPanels) {
            if (stagePanelsLoc != null && stageTreesLoc != null && stageTreeViewersLoc != null && this.stagesFolder != null) {
                stagePanelsLoc[i] = new Composite((Composite)this.stagesFolder, 0);
                Composite stageLoc = stagePanelsLoc[i];
                if (stageLoc != null) {
                    stageLoc.setLayout((Layout)new GridLayout());
                    stageTreesLoc[i] = new Tree(stagePanelsLoc[i], 68386);
                    Tree stageTreeLoc = stageTreesLoc[i];
                    if (stageTreeLoc != null) {
                        stageTreeLoc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
                        stageTreeLoc.setHeaderVisible(true);
                        TreeColumn testNameColumn = new TreeColumn(stageTreeLoc, 4);
                        testNameColumn.setText(Messages.ScenariosLabel);
                        testNameColumn.setWidth(220);
                        TreeColumn testResultColumn = new TreeColumn(stageTreeLoc, 4);
                        testResultColumn.setText(Messages.ResultLabel);
                        testResultColumn.setWidth(70);
                        stageTreeViewersLoc[i] = new TreeViewer(stageTreeLoc);
                        TreeViewer stageTVLoc = stageTreeViewersLoc[i];
                        if (stageTVLoc != null) {
                            stageTVLoc.setContentProvider((IContentProvider)this.stageTreeContentProvider);
                            stageTVLoc.setLabelProvider((IBaseLabelProvider)this.stageTreeLabelProvider);
                        }
                        if (this.scenarioSelectionListener != null) {
                            stageTreeLoc.addListener(13, this.scenarioSelectionListener);
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected void createUi() {
        this.setLayout((Layout)new GridLayout());
        GridData gd_view = new GridData(4, 4, true, true, 1, 1);
        gd_view.minimumHeight = 180;
        gd_view.heightHint = 200;
        gd_view.minimumWidth = 100;
        this.setLayoutData(gd_view);
        this.stagesFolder = new CTabFolder((Composite)this, 3072);
        this.stagesFolder.setSimple(false);
        if (this.stagesFolder != null) {
            this.stagesFolder.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        }
    }

    public void enableUI(boolean enabled) {
        if (this.stagesFolder != null) {
            this.stagesFolder.setEnabled(enabled);
        }
        if (this.stageTrees != null) {
            Tree[] treeArray = this.stageTrees;
            int n = this.stageTrees.length;
            int n2 = 0;
            while (n2 < n) {
                Tree stageTree = treeArray[n2];
                if (stageTree != null) {
                    stageTree.setEnabled(enabled);
                }
                ++n2;
            }
        }
    }

    public void expandAll() {
        if (this.stageTreeViewers != null) {
            TreeViewer[] treeViewerArray = this.stageTreeViewers;
            int n = this.stageTreeViewers.length;
            int n2 = 0;
            while (n2 < n) {
                TreeViewer stageTreeViewer = treeViewerArray[n2];
                if (stageTreeViewer != null) {
                    stageTreeViewer.expandAll();
                }
                ++n2;
            }
        }
    }

    public @Nullable CTabFolder getStagesFolder() {
        return this.stagesFolder;
    }

    public @Nullable TreeViewer @Nullable [] getStageTreeViewers() {
        return this.stageTreeViewers != null ? (TreeViewer[])this.stageTreeViewers.clone() : null;
    }

    public void refresh() {
        if (this.stageTreeViewers != null) {
            TreeViewer[] treeViewerArray = this.stageTreeViewers;
            int n = this.stageTreeViewers.length;
            int n2 = 0;
            while (n2 < n) {
                TreeViewer stageTreeViewer = treeViewerArray[n2];
                if (stageTreeViewer != null) {
                    stageTreeViewer.refresh();
                }
                ++n2;
            }
        }
    }

    public void setInput(ValidationPresentationModel stagesModel) {
        VStagePresentation[] modelStages = stagesModel.getStages();
        if (modelStages != null) {
            int numPanels = modelStages.length;
            this.createStagePanels(numPanels);
            this.numStages = 0;
            VStagePresentation[] vStagePresentationArray = modelStages;
            int n = modelStages.length;
            int n2 = 0;
            while (n2 < n) {
                VStagePresentation stage = vStagePresentationArray[n2];
                if (stage.isVisible()) {
                    ++this.numStages;
                }
                ++n2;
            }
            CTabFolder stagesFolderLoc = this.stagesFolder;
            if (stagesFolderLoc != null) {
                VStagePresentation stage;
                CTabItem item;
                int numItems = stagesFolderLoc.getItemCount();
                int i = 0;
                while (i < numItems) {
                    item = stagesFolderLoc.getItem(i);
                    if (this.stagePanels != null) {
                        item.setControl((Control)this.stagePanels[i]);
                    }
                    ++i;
                }
                if (this.numStages < numItems) {
                    i = 0;
                    while (i < this.numStages) {
                        item = stagesFolderLoc.getItem(i);
                        VStagePresentation stage2 = modelStages[i];
                        item.setText(stage2.getName());
                        item.setData((Object)stage2);
                        ++i;
                    }
                    i = this.numStages;
                    while (i < numItems) {
                        stagesFolderLoc.getItem(i).dispose();
                        ++i;
                    }
                } else {
                    i = numItems;
                    while (i < this.numStages) {
                        item = new CTabItem(stagesFolderLoc, 0);
                        if (this.stagePanels != null) {
                            item.setControl((Control)this.stagePanels[i]);
                        }
                        ++i;
                    }
                }
                i = 0;
                VStagePresentation[] vStagePresentationArray2 = modelStages;
                int n3 = modelStages.length;
                int n4 = 0;
                while (n4 < n3) {
                    stage = vStagePresentationArray2[n4];
                    if (stage.isVisible()) {
                        CTabItem stageTab = stagesFolderLoc.getItem(i);
                        stageTab.setText(stage.getName());
                        stageTab.setData((Object)stage);
                        ++i;
                    }
                    ++n4;
                }
                i = 0;
                vStagePresentationArray2 = modelStages;
                n3 = modelStages.length;
                n4 = 0;
                while (n4 < n3) {
                    TreeViewer stageTreeViewerLoc;
                    stage = vStagePresentationArray2[n4];
                    if (stage.isVisible() && this.stageTreeViewers != null && (stageTreeViewerLoc = this.stageTreeViewers[i]) != null) {
                        stageTreeViewerLoc.setInput((Object)stage);
                        stageTreeViewerLoc.expandAll();
                        ++i;
                    }
                    ++n4;
                }
                i = 0;
                vStagePresentationArray2 = modelStages;
                n3 = modelStages.length;
                n4 = 0;
                while (n4 < n3) {
                    stage = vStagePresentationArray2[n4];
                    if (stage.isVisible()) {
                        if (stage == stagesModel.getSelectedStage()) {
                            stagesFolderLoc.setSelection(i);
                            break;
                        }
                        ++i;
                    }
                    ++n4;
                }
                this.updateCheckedState(stagesModel);
                i = 0;
                vStagePresentationArray2 = modelStages;
                n3 = modelStages.length;
                n4 = 0;
                while (n4 < n3) {
                    stage = vStagePresentationArray2[n4];
                    if (stage.isVisible()) {
                        TreeViewer stageTreeViewerLoc;
                        IScenarioElement scenElem = stage.getSelectedScenarioElement();
                        if (this.stageTreeViewers != null && (stageTreeViewerLoc = this.stageTreeViewers[i]) != null) {
                            stageTreeViewerLoc.setSelection((ISelection)new StructuredSelection((Object)scenElem));
                            ++i;
                        }
                    }
                    ++n4;
                }
            }
        }
    }

    public void setScenarioSelectionListener(Listener listener) {
        this.scenarioSelectionListener = listener;
    }

    public void setStageSelectionListener(SelectionListener listener) {
        if (this.stagesFolder != null) {
            this.stagesFolder.addSelectionListener(listener);
        }
    }

    public void setStageTabsEnabled(boolean enabled) {
        if (this.stagesFolder != null) {
            this.stagesFolder.setEnabled(enabled);
        }
    }

    public void setStageTreeContentProvider(ITreeContentProvider contentProvider) {
        this.stageTreeContentProvider = contentProvider;
    }

    public void setStageTreeLabelProvider(ITableLabelProvider labelProvider) {
        this.stageTreeLabelProvider = labelProvider;
    }

    private void updateCheckedState(TreeItem item) {
        IScenarioElement elem = (IScenarioElement)item.getData();
        if (elem != null) {
            int n;
            item.setChecked(elem.isSelected());
            TreeItem parentItem = item.getParentItem();
            if (parentItem != null) {
                int nOfSelectedChildren = 0;
                TreeItem[] treeItemArray = parentItem.getItems();
                int n2 = treeItemArray.length;
                n = 0;
                while (n < n2) {
                    TreeItem childItem = treeItemArray[n];
                    if (childItem.getChecked()) {
                        ++nOfSelectedChildren;
                    }
                    ++n;
                }
                boolean checked = nOfSelectedChildren > 0;
                boolean grayed = checked && nOfSelectedChildren < parentItem.getItemCount();
                parentItem.setChecked(checked);
                parentItem.setGrayed(grayed);
            }
            TreeItem[] treeItemArray = item.getItems();
            n = treeItemArray.length;
            int n3 = 0;
            while (n3 < n) {
                TreeItem childItem = treeItemArray[n3];
                if (childItem != null) {
                    this.updateCheckedState(childItem);
                }
                ++n3;
            }
        }
    }

    public void updateCheckedState(ValidationPresentationModel stagesModel) {
        VStagePresentation selectedStage = stagesModel.getSelectedStage();
        int i = 0;
        int selIdx = 0;
        VStagePresentation[] modelStages = stagesModel.getStages();
        if (modelStages != null) {
            VStagePresentation[] vStagePresentationArray = modelStages;
            int n = modelStages.length;
            int n2 = 0;
            while (n2 < n) {
                VStagePresentation stage = vStagePresentationArray[n2];
                if (stage.isVisible()) {
                    if (stage == selectedStage) {
                        selIdx = i;
                        break;
                    }
                    ++i;
                }
                ++n2;
            }
            if (selectedStage != null) {
                this.updateCheckedState(selectedStage, selIdx);
            }
        }
    }

    private void updateCheckedState(VStagePresentation stage, int selIdx) {
        if (this.stageTreeViewers != null) {
            Tree selectedStageTree;
            TreeViewer selectedStageTreeViewer = this.stageTreeViewers[selIdx];
            if (selectedStageTreeViewer != null) {
                selectedStageTreeViewer.setSelection((ISelection)new StructuredSelection((Object)stage.getSelectedScenarioElement()));
            }
            if (this.stageTrees != null && (selectedStageTree = this.stageTrees[selIdx]) != null) {
                TreeItem[] treeItemArray = selectedStageTree.getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem treeItem = treeItemArray[n2];
                    if (treeItem != null) {
                        this.updateCheckedState(treeItem);
                    }
                    ++n2;
                }
            }
        }
    }
}

