/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.utils;

import java.util.ArrayList;
import java.util.Random;

public final class MathUtils {
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    public static final int GB = 0x40000000;
    public static final String KB_UNIT_NAME = "KB";
    public static final String MB_UNIT_NAME = "MB";
    public static final String GB_UNIT_NAME = "GB";
    public static final int MB_IN_GB = 1024;
    public static final int BITS_IN_BYTE = 8;
    private static Random RANDOM = new Random();

    private MathUtils() {
    }

    public static boolean isInteger(double n, double tolerance) {
        double absN = Math.abs(n);
        return Math.abs(absN - (double)Math.round(absN)) <= tolerance;
    }

    public static double round(double val, int precision) {
        return (double)Math.round(val * Math.pow(10.0, precision)) / Math.pow(10.0, precision);
    }

    public static Long[] getRandom(int size, int maxValue) {
        assert (size >= 0 && maxValue >= 1);
        ArrayList<Long> list = new ArrayList<Long>();
        while (size-- != 0) {
            list.add(new Long(RANDOM.nextInt(maxValue)));
        }
        return list.toArray(new Long[list.size()]);
    }

    public static long getPowerOf2(long n, boolean upperBound) {
        if (n <= 0L) {
            throw new IllegalArgumentException("The number should be positive!");
        }
        if ((n & n - 1L) == 0L) {
            return n;
        }
        return Long.highestOneBit(n) << (upperBound ? 1 : 0);
    }
}

